/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.awt.RenderingHints;
import java.util.Map;
import org.geotools.factory.FactoryNotFoundException;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.filter.FilterFactory;
import org.opengis.geometry.coordinate.GeometryFactory;
import org.opengis.geometry.primitive.PrimitiveFactory;
import org.opengis.metadata.citation.CitationFactory;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.util.NameFactory;

public class BasicFactories {
    private static final String DEFAULT_AUTHORITY = "EPSG";
    private static BasicFactories DEFAULT;
    protected final Hints hints;

    public BasicFactories(Map hints) {
        this.hints = hints != null ? new Hints(hints) : null;
    }

    public static synchronized BasicFactories getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new BasicFactories((Map)new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
        }
        return DEFAULT;
    }

    private static String unsupportedFactory(Class type) {
        return Errors.format((int)189, (Object)Utilities.getShortName((Class)type));
    }

    public FeatureTypeFactory getTypeFactory() throws FactoryRegistryException {
        return this.getFeatureTypeFactory();
    }

    public FeatureTypeFactory getFeatureTypeFactory() throws FactoryRegistryException {
        throw new FactoryNotFoundException(BasicFactories.unsupportedFactory(FeatureTypeFactory.class));
    }

    public FilterFactory getFilterFactory() throws FactoryRegistryException {
        throw new FactoryNotFoundException(BasicFactories.unsupportedFactory(FilterFactory.class));
    }

    public NameFactory getNameFactory() throws FactoryRegistryException {
        throw new FactoryNotFoundException(BasicFactories.unsupportedFactory(NameFactory.class));
    }

    public CitationFactory getCitationFactory() throws FactoryRegistryException {
        throw new FactoryNotFoundException(BasicFactories.unsupportedFactory(CitationFactory.class));
    }

    public CRSAuthorityFactory getCRSAuthorityFactory() throws FactoryRegistryException {
        return ReferencingFactoryFinder.getCRSAuthorityFactory((String)DEFAULT_AUTHORITY, (Hints)this.hints);
    }

    public CRSFactory getCRSFactory() throws FactoryRegistryException {
        return ReferencingFactoryFinder.getCRSFactory((Hints)this.hints);
    }

    public CSAuthorityFactory getCSAuthorityFactory() throws FactoryRegistryException {
        return ReferencingFactoryFinder.getCSAuthorityFactory((String)DEFAULT_AUTHORITY, (Hints)this.hints);
    }

    public CSFactory getCSFactory() throws FactoryRegistryException {
        return ReferencingFactoryFinder.getCSFactory((Hints)this.hints);
    }

    public DatumAuthorityFactory getDatumAuthorityFactory() throws FactoryRegistryException {
        return ReferencingFactoryFinder.getDatumAuthorityFactory((String)DEFAULT_AUTHORITY, (Hints)this.hints);
    }

    public DatumFactory getDatumFactory() throws FactoryRegistryException {
        return ReferencingFactoryFinder.getDatumFactory((Hints)this.hints);
    }

    public CoordinateOperationAuthorityFactory getCoordinateOperationAuthorityFactory() throws FactoryRegistryException {
        return ReferencingFactoryFinder.getCoordinateOperationAuthorityFactory((String)DEFAULT_AUTHORITY, (Hints)this.hints);
    }

    public CoordinateOperationFactory getCoordinateOperationFactory() throws FactoryRegistryException {
        return ReferencingFactoryFinder.getCoordinateOperationFactory((Hints)this.hints);
    }

    public GeometryFactory getGeometryFactory(CoordinateReferenceSystem crs) throws FactoryRegistryException {
        throw new FactoryNotFoundException(BasicFactories.unsupportedFactory(GeometryFactory.class));
    }

    public PrimitiveFactory getPrimitiveFactory(CoordinateReferenceSystem crs) throws FactoryRegistryException {
        throw new FactoryNotFoundException(BasicFactories.unsupportedFactory(PrimitiveFactory.class));
    }
}

