/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileImpl
implements Schema {
    private Schema parent;
    private Set<Name> profile;
    private Map contents = null;

    public ProfileImpl(Schema parent, Set<Name> profile) {
        this.parent = parent;
        this.profile = Collections.unmodifiableSet(profile);
    }

    public Set<Name> keySet() {
        return this.profile;
    }

    public String getURI() {
        return this.parent.getURI();
    }

    public Schema profile(Set<Name> profile) {
        return this.parent.profile(profile);
    }

    public int size() {
        return this.profile.size();
    }

    public boolean isEmpty() {
        return this.profile.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.profile.contains(key);
    }

    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    public AttributeType get(Object key) {
        if (this.profile.contains(key)) {
            return (AttributeType)this.parent.get(key);
        }
        return null;
    }

    public AttributeType put(Name key, AttributeType value) {
        throw new UnsupportedOperationException("Profile not mutable");
    }

    public AttributeType remove(Object key) {
        throw new UnsupportedOperationException("Profile not mutable");
    }

    public void putAll(Map<? extends Name, ? extends AttributeType> t) {
        throw new UnsupportedOperationException("Profile not mutable");
    }

    public void clear() {
        throw new UnsupportedOperationException("Profile not mutable");
    }

    public void add(AttributeType type) {
        throw new UnsupportedOperationException("Profile not mutable");
    }

    public Collection<AttributeType> values() {
        return this.contents().values();
    }

    public Set<Map.Entry<Name, AttributeType>> entrySet() {
        return this.contents().entrySet();
    }

    private synchronized Map<Name, AttributeType> contents() {
        if (this.contents == null) {
            this.contents = new LinkedHashMap();
            for (Name key : this.profile) {
                this.contents.put(key, this.parent.get((Object)key));
            }
        }
        return this.contents;
    }
}

