/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geotools.data.DataStore;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.RemoteOWS;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayerImpl;
import org.geotools.styling.UserLayer;
import org.geotools.util.Utilities;
import org.opengis.feature.simple.SimpleFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserLayerImpl
extends StyledLayerImpl
implements UserLayer {
    private DataStore inlineFeatureDatastore = null;
    private SimpleFeatureType inlineFeatureType = null;
    RemoteOWS remoteOWS;
    List<Style> styles = new ArrayList<Style>();
    List<FeatureTypeConstraint> constraints = new ArrayList<FeatureTypeConstraint>();

    public RemoteOWS getRemoteOWS() {
        return this.remoteOWS;
    }

    public DataStore getInlineFeatureDatastore() {
        return this.inlineFeatureDatastore;
    }

    public SimpleFeatureType getInlineFeatureType() {
        return this.inlineFeatureType;
    }

    public void setInlineFeatureDatastore(DataStore store) {
        this.inlineFeatureDatastore = store;
    }

    public void setInlineFeatureType(SimpleFeatureType ft) {
        this.inlineFeatureType = ft;
    }

    public void setRemoteOWS(RemoteOWS service) {
        this.remoteOWS = service;
    }

    public List<FeatureTypeConstraint> layerFeatureConstraints() {
        return this.constraints;
    }

    public FeatureTypeConstraint[] getLayerFeatureConstraints() {
        return this.constraints.toArray(new FeatureTypeConstraint[0]);
    }

    public void setLayerFeatureConstraints(FeatureTypeConstraint[] array) {
        this.constraints.clear();
        this.constraints.addAll(Arrays.asList(array));
    }

    public List<Style> userStyles() {
        return this.styles;
    }

    public Style[] getUserStyles() {
        return this.styles.toArray(new Style[0]);
    }

    public void setUserStyles(Style[] styles) {
        this.styles.clear();
        this.styles.addAll(Arrays.asList(styles));
    }

    public void addUserStyle(Style style) {
        this.styles.add(style);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((UserLayer)this);
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof UserLayerImpl) {
            UserLayerImpl other = (UserLayerImpl)oth;
            if (!(Utilities.equals((Object)this.inlineFeatureDatastore, (Object)other.inlineFeatureDatastore) && Utilities.equals((Object)this.inlineFeatureType, (Object)other.inlineFeatureType) && Utilities.equals((Object)this.remoteOWS, (Object)other.remoteOWS) && Utilities.equals(this.styles, other.styles))) {
                return false;
            }
            return Utilities.equals(this.constraints, other.constraints);
        }
        return false;
    }
}

