/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import junit.framework.TestCase;
import org.geotools.data.crs.ForceCoordinateSystemFeatureResults;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ForceCoordinateFeatureResultsTest
extends TestCase {
    private static final String FEATURE_TYPE_NAME = "testType";
    private MemoryDataStore store;
    private CoordinateReferenceSystem wgs84;
    private CoordinateReferenceSystem utm32n;

    protected void setUp() throws Exception {
        this.wgs84 = CRS.decode((String)"EPSG:4326");
        this.utm32n = CRS.decode((String)"EPSG:32632");
        GeometryFactory fac = new GeometryFactory();
        Point p = fac.createPoint(new Coordinate(10.0, 10.0));
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(FEATURE_TYPE_NAME);
        builder.setCRS(this.wgs84);
        builder.add("geom", Point.class);
        SimpleFeatureType ft = builder.buildFeatureType();
        SimpleFeatureBuilder b = new SimpleFeatureBuilder(ft);
        b.add((Object)p);
        SimpleFeature[] features = new SimpleFeature[]{b.buildFeature(null)};
        this.store = new MemoryDataStore(features);
    }

    public void testSchema() throws Exception {
        FeatureCollection original = this.store.getFeatureSource(FEATURE_TYPE_NAME).getFeatures();
        ForceCoordinateFeatureResultsTest.assertEquals((Object)this.wgs84, (Object)original.getSchema().getCoordinateReferenceSystem());
        ForceCoordinateSystemFeatureResults forced = new ForceCoordinateSystemFeatureResults(original, this.utm32n);
        ForceCoordinateFeatureResultsTest.assertEquals((Object)this.utm32n, (Object)forced.getSchema().getCoordinateReferenceSystem());
    }

    public void testBounds() throws Exception {
        FeatureCollection original = this.store.getFeatureSource(FEATURE_TYPE_NAME).getFeatures();
        ForceCoordinateSystemFeatureResults forced = new ForceCoordinateSystemFeatureResults(original, this.utm32n);
        ForceCoordinateFeatureResultsTest.assertEquals((Object)new ReferencedEnvelope(10.0, 10.0, 10.0, 10.0, this.utm32n), (Object)forced.getBounds());
    }
}

