/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SampleFeatureFixtures;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class FeatureFlatTest
extends TestCase {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.defaultcore");
    private SimpleFeature testFeature = null;
    TestSuite suite = null;

    public FeatureFlatTest(String testName) {
        super(testName);
    }

    public static void main(String[] args) {
        Logging.GEOTOOLS.forceMonolineConsoleOutput();
        TestRunner.run((Test)FeatureFlatTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(FeatureFlatTest.class);
        return suite;
    }

    public void setUp() {
        this.testFeature = SampleFeatureFixtures.createFeature();
    }

    public void testRetrieve() {
        GeometryFactory gf = new GeometryFactory();
        FeatureFlatTest.assertTrue((String)"geometry retrieval and match", (boolean)((Point)this.testFeature.getAttribute("testGeometry")).equals((Geometry)gf.createPoint(new Coordinate(1.0, 2.0))));
        FeatureFlatTest.assertTrue((String)"boolean retrieval and match", (boolean)((Boolean)this.testFeature.getAttribute("testBoolean")).equals(new Boolean(true)));
        FeatureFlatTest.assertTrue((String)"character retrieval and match", (boolean)((Character)this.testFeature.getAttribute("testCharacter")).equals(new Character('t')));
        FeatureFlatTest.assertTrue((String)"byte retrieval and match", (boolean)((Byte)this.testFeature.getAttribute("testByte")).equals(new Byte("10")));
        FeatureFlatTest.assertTrue((String)"short retrieval and match", (boolean)((Short)this.testFeature.getAttribute("testShort")).equals(new Short("101")));
        FeatureFlatTest.assertTrue((String)"integer retrieval and match", (boolean)((Integer)this.testFeature.getAttribute("testInteger")).equals(new Integer(1002)));
        FeatureFlatTest.assertTrue((String)"long retrieval and match", (boolean)((Long)this.testFeature.getAttribute("testLong")).equals(new Long(10003L)));
        FeatureFlatTest.assertTrue((String)"float retrieval and match", (boolean)((Float)this.testFeature.getAttribute("testFloat")).equals(new Float(10000.4)));
        FeatureFlatTest.assertTrue((String)"double retrieval and match", (boolean)((Double)this.testFeature.getAttribute("testDouble")).equals(new Double(100000.5)));
        FeatureFlatTest.assertTrue((String)"string retrieval and match", (boolean)((String)this.testFeature.getAttribute("testString")).equals("test string data"));
    }

    public void testBogusCreation() throws Exception {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("test1");
        tb.nillable(false).add("billy", String.class);
        tb.nillable(false).add("jimmy", String.class);
        SimpleFeatureType test = tb.buildFeatureType();
        try {
            SimpleFeatureBuilder.build((SimpleFeatureType)test, (Object[])new Object[32], null);
            FeatureFlatTest.fail((String)"no error");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testBounds() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        Object[] g = new Geometry[]{gf.createPoint(new Coordinate(0.0, 0.0)), gf.createPoint(new Coordinate(0.0, 10.0)), gf.createPoint(new Coordinate(10.0, 0.0)), gf.createPoint(new Coordinate(10.0, 10.0))};
        GeometryCollection gc = gf.createGeometryCollection((Geometry[])g);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("bounds");
        tb.add("p1", Point.class);
        tb.add("p2", Point.class);
        tb.add("p3", Point.class);
        tb.add("p4", Point.class);
        SimpleFeatureType t = tb.buildFeatureType();
        SimpleFeature f = SimpleFeatureBuilder.build((SimpleFeatureType)t, (Object[])g, null);
        FeatureFlatTest.assertEquals((Object)gc.getEnvelopeInternal(), (Object)f.getBounds());
        g[1].getCoordinate().y = 20.0;
        g[2].getCoordinate().x = 20.0;
        f.setAttribute(1, g[1]);
        f.setAttribute(2, g[2]);
        gc = gf.createGeometryCollection((Geometry[])g);
        FeatureFlatTest.assertEquals((Object)gc.getEnvelopeInternal(), (Object)f.getBounds());
    }

    public void testClone() {
        SimpleFeature f = SampleFeatureFixtures.createFeature();
        SimpleFeature c = SimpleFeatureBuilder.copy((SimpleFeature)f);
        int ii = c.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            FeatureFlatTest.assertEquals((Object)c.getAttribute(i), (Object)f.getAttribute(i));
        }
    }

    public void testClone2() throws Exception {
        SimpleFeatureType type = SampleFeatureFixtures.createTestType();
        Object[] attributes = SampleFeatureFixtures.createAttributes();
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])attributes, (String)"fid");
        SimpleFeature clone = SimpleFeatureBuilder.deep((SimpleFeature)feature);
        FeatureFlatTest.assertTrue((String)"Clone was not equal", (boolean)feature.equals(clone));
    }

    public void testToStringWontThrow() throws IllegalAttributeException {
        SimpleFeature f = SampleFeatureFixtures.createFeature();
        f.setAttributes(new Object[f.getAttributeCount()]);
        String s = f.toString();
    }

    static AttributeDescriptor newAtt(String name, Class c) {
        AttributeTypeBuilder ab = new AttributeTypeBuilder();
        ab.setBinding(c);
        return ab.buildDescriptor(name);
    }

    static AttributeDescriptor newAtt(String name, Class c, boolean nillable) {
        AttributeTypeBuilder ab = new AttributeTypeBuilder();
        ab.setNillable(nillable);
        ab.setBinding(c);
        return ab.buildDescriptor(name);
    }

    public void testModify() throws IllegalAttributeException {
        String newData = "new test string data";
        this.testFeature.setAttribute("testString", (Object)newData);
        FeatureFlatTest.assertEquals((String)"match modified (string) attribute", (Object)this.testFeature.getAttribute("testString"), (Object)newData);
        GeometryFactory gf = new GeometryFactory();
        Point newGeom = gf.createPoint(new Coordinate(3.0, 4.0));
        this.testFeature.setAttribute("testGeometry", (Object)newGeom);
        FeatureFlatTest.assertEquals((String)"match modified (geometry) attribute", (Object)this.testFeature.getAttribute("testGeometry"), (Object)newGeom);
        this.testFeature.setDefaultGeometry((Object)newGeom);
        FeatureFlatTest.assertEquals((String)"match modified (geometry) attribute", (Object)this.testFeature.getAttribute("testGeometry"), (Object)newGeom);
    }

    public void testEquals() throws Exception {
        SimpleFeature f1 = SampleFeatureFixtures.createFeature();
        SimpleFeature f2 = SampleFeatureFixtures.createFeature();
        FeatureFlatTest.assertTrue((boolean)f1.equals(f1));
        FeatureFlatTest.assertTrue((boolean)f2.equals(f2));
        FeatureFlatTest.assertTrue((!f1.equals(f2) ? 1 : 0) != 0);
        FeatureFlatTest.assertTrue((!f1.equals(null) ? 1 : 0) != 0);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("different");
        tb.add("name", String.class);
        SimpleFeatureType type = tb.buildFeatureType();
        FeatureFlatTest.assertTrue((!f1.equals(SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[1], null)) ? 1 : 0) != 0);
    }
}

