/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.util.logging.Logging;

public class FilterCapabilitiesTest
extends TestCase {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.defaultcore");
    private Filter gFilter;
    private Filter compFilter;
    private Filter logFilter;
    private FilterCapabilities capabilities;
    private FilterFactory fact = FilterFactoryFinder.createFilterFactory();
    TestSuite suite = null;
    String dataFolder = "";
    boolean setup = false;

    public FilterCapabilitiesTest(String testName) {
        super(testName);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)FilterCapabilitiesTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(FilterCapabilitiesTest.class);
        return suite;
    }

    protected void setUp() {
        LOGGER.finer("Setting up FilterCapabilitiesTest");
        if (this.setup) {
            return;
        }
        this.setup = true;
        this.capabilities = new FilterCapabilities();
        try {
            this.gFilter = this.fact.createGeometryFilter((short)10);
            this.compFilter = this.fact.createCompareFilter((short)15);
        }
        catch (IllegalFilterException ife) {
            LOGGER.fine("Bad filter " + (Object)((Object)ife));
        }
        this.capabilities.addType((short)1);
        this.capabilities.addType((short)2);
        this.capabilities.addType((short)3);
        this.capabilities.addType((short)14);
        this.capabilities.addType((short)15);
        this.capabilities.addType((short)19);
    }

    public void testAdd() {
        this.capabilities.addType((short)16);
        this.capabilities.addType((short)17);
        this.capabilities.addType((short)21);
        FilterCapabilitiesTest.assertTrue((boolean)this.capabilities.supports((short)21));
    }

    public void testShortSupports() {
        FilterCapabilitiesTest.assertTrue((boolean)this.capabilities.supports((short)2));
        FilterCapabilitiesTest.assertTrue((!this.capabilities.supports((short)20) ? 1 : 0) != 0);
    }

    public void testFilterSupports() {
        FilterCapabilitiesTest.assertTrue((boolean)this.capabilities.supports((org.opengis.filter.Filter)this.compFilter));
        FilterCapabilitiesTest.assertTrue((!this.capabilities.supports((org.opengis.filter.Filter)this.gFilter) ? 1 : 0) != 0);
    }

    public void testFullySupports() {
        try {
            this.logFilter = this.gFilter.and((org.opengis.filter.Filter)this.compFilter);
            FilterCapabilitiesTest.assertTrue((boolean)this.capabilities.fullySupports((org.opengis.filter.Filter)this.compFilter));
            FilterCapabilitiesTest.assertTrue((!this.capabilities.fullySupports((org.opengis.filter.Filter)this.gFilter) ? 1 : 0) != 0);
            FilterCapabilitiesTest.assertTrue((!this.capabilities.fullySupports((org.opengis.filter.Filter)this.logFilter) ? 1 : 0) != 0);
            this.logFilter = this.compFilter.and((org.opengis.filter.Filter)this.fact.createBetweenFilter());
            FilterCapabilitiesTest.assertTrue((boolean)this.capabilities.fullySupports((org.opengis.filter.Filter)this.logFilter));
            this.logFilter = this.logFilter.or((org.opengis.filter.Filter)this.fact.createBetweenFilter());
            FilterCapabilitiesTest.assertTrue((boolean)this.capabilities.fullySupports((org.opengis.filter.Filter)this.logFilter));
            this.logFilter = this.logFilter.and((org.opengis.filter.Filter)this.gFilter);
            FilterCapabilitiesTest.assertTrue((!this.capabilities.fullySupports((org.opengis.filter.Filter)this.logFilter) ? 1 : 0) != 0);
        }
        catch (IllegalFilterException e) {
            LOGGER.fine("Bad filter " + (Object)((Object)e));
        }
    }
}

