/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import junit.framework.TestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;

public class IsNotEqualToImpltest
extends TestCase {
    FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);

    public void testOperandsSameType() {
        Literal e1 = this.filterFactory.literal(1);
        Literal e2 = this.filterFactory.literal(2);
        PropertyIsNotEqualTo notEqual = this.filterFactory.notEqual((Expression)e1, (Expression)e2, true);
        IsNotEqualToImpltest.assertTrue((boolean)notEqual.evaluate(null));
    }

    public void testOperandsDifferentType() {
        Literal e1 = this.filterFactory.literal(1);
        Literal e2 = this.filterFactory.literal((Object)"2");
        PropertyIsNotEqualTo notEqual = this.filterFactory.notEqual((Expression)e1, (Expression)e2, true);
        IsNotEqualToImpltest.assertTrue((boolean)notEqual.evaluate(null));
    }

    public void testCaseSensitivity() {
        Literal e1 = this.filterFactory.literal((Object)"foo");
        Literal e2 = this.filterFactory.literal((Object)"FoO");
        PropertyIsNotEqualTo caseSensitive = this.filterFactory.notEqual((Expression)e1, (Expression)e2, true);
        IsNotEqualToImpltest.assertTrue((boolean)caseSensitive.evaluate(null));
        PropertyIsNotEqualTo caseInsensitive = this.filterFactory.notEqual((Expression)e1, (Expression)e2, false);
        IsNotEqualToImpltest.assertFalse((boolean)caseInsensitive.evaluate(null));
    }
}

