/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import junit.framework.TestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.visitor.RescaleStyleVisitor;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;

public class RescaleStyleVisitorTest
extends TestCase {
    StyleBuilder sb;
    StyleFactory sf;
    FilterFactory2 ff;
    RescaleStyleVisitor visitor;
    double scale;

    public RescaleStyleVisitorTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        this.sf = CommonFactoryFinder.getStyleFactory(null);
        this.ff = CommonFactoryFinder.getFilterFactory2(null);
        this.sb = new StyleBuilder(this.sf, (FilterFactory)this.ff);
        this.scale = 2.0;
        this.visitor = new RescaleStyleVisitor(this.scale);
    }

    public void testStyleDuplication() throws IllegalFilterException {
        Style oldStyle = this.sb.createStyle("FTSName", (Symbolizer)this.sf.createPolygonSymbolizer());
        oldStyle.getFeatureTypeStyles()[0].setSemanticTypeIdentifiers(new String[]{"simple", "generic:geometry"});
        oldStyle.accept((StyleVisitor)this.visitor);
        Style newStyle = (Style)this.visitor.getCopy();
        RescaleStyleVisitorTest.assertNotNull((Object)newStyle);
    }

    public void testStyle() throws Exception {
        FeatureTypeStyle fts = this.sf.createFeatureTypeStyle();
        fts.setFeatureTypeName("feature-type-1");
        FeatureTypeStyle fts2 = this.fts2();
        Style style = this.sf.getDefaultStyle();
        style.addFeatureTypeStyle(fts);
        style.addFeatureTypeStyle(fts2);
        style.accept((StyleVisitor)this.visitor);
        Style copy = (Style)this.visitor.getCopy();
        Style notEq = this.sf.getDefaultStyle();
        fts2 = this.fts2();
        notEq.addFeatureTypeStyle(fts2);
    }

    private FeatureTypeStyle fts2() {
        FeatureTypeStyle fts2 = this.sf.createFeatureTypeStyle();
        Rule rule = this.sf.createRule();
        fts2.addRule(rule);
        fts2.setFeatureTypeName("feature-type-2");
        return fts2;
    }

    public void testRule() throws Exception {
        LineSymbolizer symb1 = this.sf.createLineSymbolizer(this.sf.getDefaultStroke(), "geometry");
        PolygonSymbolizer symb2 = this.sf.createPolygonSymbolizer(this.sf.getDefaultStroke(), this.sf.getDefaultFill(), "shape");
        RasterSymbolizer symb3 = this.sf.createRasterSymbolizer();
        Rule rule = this.sf.createRule();
        rule.setSymbolizers(new Symbolizer[]{symb1, symb2, symb3});
        rule.accept((StyleVisitor)this.visitor);
        Rule clone = (Rule)this.visitor.getCopy();
        RescaleStyleVisitorTest.assertNotNull((Object)clone);
    }
}

