/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import java.util.Iterator;
import org.geotools.data.store.FeatureCollectionWrapperTestSupport;
import org.geotools.data.store.ReprojectingFeatureCollection;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;

public class ReprojectingFeatureCollectionTest
extends FeatureCollectionWrapperTestSupport {
    CoordinateReferenceSystem target;
    GeometryCoordinateSequenceTransformer transformer;

    protected void setUp() throws Exception {
        super.setUp();
        this.target = CRS.parseWKT((String)"PROJCS[\"BC_Albers\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS_1980\",6378137,298.257222101],TOWGS84[0,0,0]],PRIMEM[\"Greenwich\",0],UNIT[\"Degree\",0.017453292519943295]],PROJECTION[\"Albers_Conic_Equal_Area\"],PARAMETER[\"False_Easting\",1000000],PARAMETER[\"False_Northing\",0],PARAMETER[\"Central_Meridian\",-126],PARAMETER[\"Standard_Parallel_1\",50],PARAMETER[\"Standard_Parallel_2\",58.5],PARAMETER[\"Latitude_Of_Origin\",45],UNIT[\"Meter\",1],AUTHORITY[\"EPSG\",\"42102\"]]");
        MathTransform2D tx = (MathTransform2D)ReferencingFactoryFinder.getCoordinateOperationFactory(null).createOperation(this.crs, this.target).getMathTransform();
        this.transformer = new GeometryCoordinateSequenceTransformer();
        this.transformer.setMathTransform((MathTransform)tx);
    }

    public void testNormal() throws Exception {
        Iterator reproject = new ReprojectingFeatureCollection(this.delegate, this.target).iterator();
        for (SimpleFeature normal : this.delegate) {
            SimpleFeature reprojected = (SimpleFeature)reproject.next();
            Point p1 = (Point)normal.getAttribute("defaultGeom");
            Point p2 = (Point)reprojected.getAttribute("defaultGeom");
            if (p1 != null) {
                p1 = (Point)this.transformer.transform((Geometry)p1);
                ReprojectingFeatureCollectionTest.assertTrue((boolean)p1.equals((Geometry)p2));
            } else {
                ReprojectingFeatureCollectionTest.assertNull((Object)p2);
            }
            LineString l1 = (LineString)normal.getAttribute("otherGeom");
            LineString l2 = (LineString)reprojected.getAttribute("otherGeom");
            if (l1 != null) {
                l1 = (LineString)this.transformer.transform((Geometry)l1);
                ReprojectingFeatureCollectionTest.assertTrue((boolean)l1.equals((Geometry)l2));
                continue;
            }
            ReprojectingFeatureCollectionTest.assertNull((Object)l2);
        }
    }

    public void testBounds() throws Exception {
        ReprojectingFeatureCollection rfc = new ReprojectingFeatureCollection(this.delegate, this.target);
        rfc.getBounds();
    }
}

