/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.BetweenFilterImpl;
import org.geotools.filter.Expression;
import org.geotools.filter.FidFilterImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LikeFilterImpl;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.NullFilterImpl;
import org.geotools.filter.expression.AddImpl;
import org.geotools.filter.expression.SubtractImpl;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.spatial.Disjoint;

public class FilterEqualsTest
extends TestCase {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.defaultcore");
    private FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    private Expression testExp1;
    private Expression testExp2;
    private Expression testExp3;
    private Expression testExp4;
    private Filter tFilter1;
    private Filter tFilter2;
    private static SimpleFeature testFeature = null;
    private static SimpleFeatureType testSchema = null;
    boolean set = false;

    public FilterEqualsTest(String testName) {
        super(testName);
    }

    public static void main(String[] args) {
        Logging.GEOTOOLS.forceMonolineConsoleOutput();
        TestRunner.run((Test)FilterEqualsTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(FilterEqualsTest.class);
        return suite;
    }

    protected void setUp() throws SchemaException, IllegalAttributeException {
        if (this.set) {
            return;
        }
        this.set = true;
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.add("testGeometry", LineString.class);
        ftb.add("testBoolean", Boolean.class);
        ftb.add("testCharacter", Character.class);
        ftb.add("testByte", Byte.class);
        ftb.add("testShort", Short.class);
        ftb.add("testInteger", Integer.class);
        ftb.add("testLong", Long.class);
        ftb.add("testFloat", Float.class);
        ftb.add("testDouble", Double.class);
        ftb.add("testString", String.class);
        ftb.add("testZeroDouble", Double.class);
        ftb.setName("testSchema");
        testSchema = ftb.buildFeatureType();
        Coordinate[] coords = new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(3.0, 4.0), new Coordinate(5.0, 6.0)};
        Object[] attributes = new Object[11];
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        attributes[0] = gf.createLineString(coords);
        attributes[1] = new Boolean(true);
        attributes[2] = new Character('t');
        attributes[3] = new Byte("10");
        attributes[4] = new Short("101");
        attributes[5] = new Integer(1002);
        attributes[6] = new Long(10003L);
        attributes[7] = new Float(10000.4);
        attributes[8] = new Double(100000.5);
        attributes[9] = "test string data";
        attributes[10] = "0.0";
        testFeature = SimpleFeatureBuilder.build((SimpleFeatureType)testSchema, (Object[])attributes, null);
    }

    public void testLiteralExpressionImplEquals() {
        try {
            LiteralExpressionImpl testString1 = new LiteralExpressionImpl("test literal");
            LiteralExpressionImpl testString2 = new LiteralExpressionImpl("test literal");
            FilterEqualsTest.assertTrue((boolean)testString1.equals(testString2));
            LiteralExpressionImpl testOtherString = new LiteralExpressionImpl("not test literal");
            FilterEqualsTest.assertFalse((boolean)testString1.equals(testOtherString));
            LiteralExpressionImpl testNumber34 = new LiteralExpressionImpl((Object)new Integer(34));
            FilterEqualsTest.assertFalse((boolean)testString1.equals(testNumber34));
            LiteralExpressionImpl testOtherNumber34 = new LiteralExpressionImpl((Object)new Integer(34));
            FilterEqualsTest.assertTrue((boolean)testNumber34.equals(testOtherNumber34));
        }
        catch (IllegalFilterException e) {
            LOGGER.warning("bad filter " + e.getMessage());
        }
    }

    public void testFidFilter() {
        FidFilterImpl ff = new FidFilterImpl();
        ff.addFid("1");
        FidFilterImpl ff2 = new FidFilterImpl("1");
        FilterEqualsTest.assertNotNull((Object)ff2);
        FilterEqualsTest.assertEquals((Object)ff, (Object)ff2);
        FilterEqualsTest.assertTrue((!ff.equals(null) ? 1 : 0) != 0);
        FilterEqualsTest.assertTrue((!ff.equals("a string not even a filter") ? 1 : 0) != 0);
        ff2.addFid("2");
        FilterEqualsTest.assertTrue((!ff.equals(ff2) ? 1 : 0) != 0);
        ff.addFid("2");
        FilterEqualsTest.assertEquals((Object)ff, (Object)ff2);
        FidFilterImpl ff3 = new FidFilterImpl();
        ff3.filterType = (short)-1;
        FilterEqualsTest.assertTrue((!ff2.equals(ff3) ? 1 : 0) != 0);
    }

    public void testExpressionMath() {
        try {
            this.testExp1 = new LiteralExpressionImpl((Object)new Double(5.0));
            this.testExp2 = new LiteralExpressionImpl((Object)new Double(5.0));
            AddImpl testMath1 = new AddImpl(null, null);
            testMath1.addLeftValue(this.testExp1);
            testMath1.addRightValue(this.testExp2);
            AddImpl testMath2 = new AddImpl(null, null);
            testMath2.addLeftValue(this.testExp2);
            testMath2.addRightValue(this.testExp1);
            FilterEqualsTest.assertTrue((boolean)testMath1.equals(testMath2));
            this.testExp3 = new LiteralExpressionImpl((Object)new Integer(4));
            this.testExp4 = new LiteralExpressionImpl((Object)new Integer(4));
            testMath2.addLeftValue(this.testExp3);
            FilterEqualsTest.assertTrue((!testMath1.equals(testMath2) ? 1 : 0) != 0);
            testMath1.addLeftValue(this.testExp4);
            FilterEqualsTest.assertTrue((boolean)testMath1.equals(testMath2));
            testMath1 = new SubtractImpl(null, null);
            testMath1.addLeftValue(this.testExp4);
            testMath1.addLeftValue(this.testExp2);
            FilterEqualsTest.assertTrue((!testMath1.equals(testMath2) ? 1 : 0) != 0);
            FilterEqualsTest.assertTrue((!testMath1.equals("Random Object that happens to be a string") ? 1 : 0) != 0);
        }
        catch (IllegalFilterException e) {
            LOGGER.warning("bad filter: " + e.getMessage());
        }
    }

    public void testExpressionAttribute() throws IllegalFilterException, SchemaException {
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.add("testBoolean", Boolean.class);
        ftb.add("testString", String.class);
        ftb.setName("test2");
        SimpleFeatureType testSchema2 = ftb.buildFeatureType();
        this.testExp1 = new AttributeExpressionImpl(testSchema, "testBoolean");
        this.testExp2 = new AttributeExpressionImpl(testSchema, "testBoolean");
        FilterEqualsTest.assertTrue((boolean)this.testExp1.equals(this.testExp2));
        this.testExp3 = new AttributeExpressionImpl(testSchema, "testString");
        FilterEqualsTest.assertTrue((!this.testExp1.equals(this.testExp3) ? 1 : 0) != 0);
        this.testExp4 = new AttributeExpressionImpl(testSchema2, "testBoolean");
        FilterEqualsTest.assertTrue((!this.testExp1.equals(this.testExp4) ? 1 : 0) != 0);
        this.testExp1 = new AttributeExpressionImpl(testSchema2, "testBoolean");
        FilterEqualsTest.assertTrue((boolean)this.testExp1.equals(this.testExp4));
    }

    public void testCompareFilter() throws IllegalFilterException {
        this.testExp1 = new LiteralExpressionImpl((Object)new Integer(45));
        this.testExp2 = new LiteralExpressionImpl((Object)new Integer(45));
        this.testExp3 = new AttributeExpressionImpl(testSchema, "testInteger");
        this.testExp4 = new AttributeExpressionImpl(testSchema, "testInteger");
        PropertyIsEqualTo cFilter1 = this.ff.equals((org.opengis.filter.expression.Expression)this.testExp1, (org.opengis.filter.expression.Expression)this.testExp3);
        PropertyIsEqualTo cFilter2 = this.ff.equals((org.opengis.filter.expression.Expression)this.testExp1, (org.opengis.filter.expression.Expression)this.testExp3);
        FilterEqualsTest.assertTrue((boolean)cFilter1.equals(cFilter2));
        cFilter2 = this.ff.equals((org.opengis.filter.expression.Expression)this.testExp2, (org.opengis.filter.expression.Expression)this.testExp4);
        FilterEqualsTest.assertTrue((boolean)cFilter1.equals(cFilter2));
        cFilter2 = this.ff.equals((org.opengis.filter.expression.Expression)this.ff.literal((Object)new Double(45.0)), (org.opengis.filter.expression.Expression)this.testExp3);
        FilterEqualsTest.assertTrue((boolean)cFilter1.equals(cFilter2));
        this.tFilter1 = this.ff.between((org.opengis.filter.expression.Expression)this.testExp1, (org.opengis.filter.expression.Expression)this.testExp2, (org.opengis.filter.expression.Expression)this.testExp3);
        FilterEqualsTest.assertTrue((!cFilter1.equals(this.tFilter1) ? 1 : 0) != 0);
    }

    public void testBetweenFilter() throws IllegalFilterException {
        BetweenFilterImpl bFilter1 = new BetweenFilterImpl();
        BetweenFilterImpl bFilter2 = new BetweenFilterImpl();
        LiteralExpressionImpl testLit1 = new LiteralExpressionImpl((Object)new Integer(55));
        LiteralExpressionImpl testLit2 = new LiteralExpressionImpl((Object)new Integer(55));
        this.testExp1 = new LiteralExpressionImpl((Object)new Integer(45));
        this.testExp2 = new LiteralExpressionImpl((Object)new Integer(45));
        this.testExp3 = new AttributeExpressionImpl(testSchema, "testInteger");
        this.testExp4 = new AttributeExpressionImpl(testSchema, "testInteger");
        bFilter1.addLeftValue(this.testExp1);
        bFilter2.addLeftValue(this.testExp2);
        bFilter1.addMiddleValue(this.testExp3);
        bFilter2.addMiddleValue(this.testExp4);
        bFilter1.addRightValue((Expression)testLit1);
        bFilter2.addRightValue((Expression)testLit2);
        FilterEqualsTest.assertTrue((boolean)bFilter2.equals((Object)bFilter1));
        this.tFilter1 = this.ff.equals(org.opengis.filter.expression.Expression.NIL, org.opengis.filter.expression.Expression.NIL);
        FilterEqualsTest.assertTrue((!bFilter2.equals((Object)this.tFilter1) ? 1 : 0) != 0);
        bFilter2.addRightValue((Expression)new LiteralExpressionImpl((Object)new Integer(65)));
        FilterEqualsTest.assertTrue((!bFilter2.equals((Object)bFilter1) ? 1 : 0) != 0);
    }

    public void testLikeFilter() throws IllegalFilterException {
        LikeFilterImpl lFilter1 = new LikeFilterImpl();
        LikeFilterImpl lFilter2 = new LikeFilterImpl();
        String pattern = "te_st!";
        String wcMulti = "!";
        String wcSingle = "_";
        String escape = "#";
        this.testExp2 = new LiteralExpressionImpl((Object)new Integer(45));
        this.testExp3 = new AttributeExpressionImpl(testSchema, "testInteger");
        this.testExp4 = new AttributeExpressionImpl(testSchema, "testInteger");
        lFilter1.setValue(this.testExp3);
        lFilter2.setValue(this.testExp4);
        lFilter1.setPattern(pattern, wcMulti, wcSingle, escape);
        lFilter2.setPattern(pattern, wcMulti, wcSingle, escape);
        FilterEqualsTest.assertTrue((boolean)lFilter1.equals((Object)lFilter2));
        lFilter2.setPattern("te__t!", wcMulti, wcSingle, escape);
        FilterEqualsTest.assertTrue((!lFilter1.equals((Object)lFilter2) ? 1 : 0) != 0);
        lFilter2.setPattern(pattern, wcMulti, wcSingle, escape);
        lFilter2.setValue(this.testExp2);
        FilterEqualsTest.assertTrue((!lFilter1.equals((Object)lFilter2) ? 1 : 0) != 0);
    }

    public void testLogicFilter() throws IllegalFilterException {
        this.testExp1 = new LiteralExpressionImpl((Object)new Integer(45));
        this.testExp2 = new LiteralExpressionImpl((Object)new Integer(45));
        this.testExp3 = new AttributeExpressionImpl(testSchema, "testInteger");
        this.testExp4 = new AttributeExpressionImpl(testSchema, "testInteger");
        PropertyIsEqualTo cFilter1 = this.ff.equals((org.opengis.filter.expression.Expression)this.testExp1, (org.opengis.filter.expression.Expression)this.testExp2);
        PropertyIsEqualTo cFilter2 = this.ff.equals((org.opengis.filter.expression.Expression)this.testExp2, (org.opengis.filter.expression.Expression)this.testExp4);
        And logFilter1 = this.ff.and((Filter)cFilter1, (Filter)cFilter2);
        And logFilter2 = this.ff.and((Filter)cFilter1, (Filter)cFilter2);
        FilterEqualsTest.assertTrue((boolean)logFilter1.equals(logFilter2));
        logFilter1 = this.ff.not((Filter)cFilter2);
        FilterEqualsTest.assertTrue((!logFilter1.equals(logFilter2) ? 1 : 0) != 0);
        cFilter1 = this.ff.equals((org.opengis.filter.expression.Expression)this.testExp1, (org.opengis.filter.expression.Expression)this.testExp3);
        logFilter2 = this.ff.not((Filter)cFilter1);
        FilterEqualsTest.assertTrue((boolean)logFilter1.equals(logFilter2));
        FilterEqualsTest.assertTrue((!logFilter1.equals(this.ff.between((org.opengis.filter.expression.Expression)this.testExp1, (org.opengis.filter.expression.Expression)this.testExp2, (org.opengis.filter.expression.Expression)this.testExp3)) ? 1 : 0) != 0);
        Or logFilter3 = this.ff.or((Filter)logFilter1, (Filter)logFilter2);
        Or logFilter4 = this.ff.or((Filter)logFilter1, (Filter)logFilter2);
        FilterEqualsTest.assertTrue((boolean)logFilter3.equals(logFilter4));
        Or logFilter5 = this.ff.or((Filter)cFilter1, (Filter)logFilter3);
        Or logFilter6 = this.ff.or((Filter)logFilter4, (Filter)cFilter1);
        FilterEqualsTest.assertTrue((boolean)logFilter5.equals(logFilter6));
        FilterEqualsTest.assertTrue((boolean)logFilter4.equals(logFilter3));
    }

    public void testNullFilter() throws IllegalFilterException {
        this.testExp1 = new AttributeExpressionImpl(testSchema, "testDouble");
        this.testExp2 = new AttributeExpressionImpl(testSchema, "testDouble");
        this.testExp3 = new AttributeExpressionImpl(testSchema, "testBoolean");
        NullFilterImpl nullFilter1 = new NullFilterImpl();
        NullFilterImpl nullFilter2 = new NullFilterImpl();
        nullFilter1.nullCheckValue(this.testExp1);
        nullFilter2.nullCheckValue(this.testExp2);
        FilterEqualsTest.assertTrue((boolean)nullFilter1.equals((Object)nullFilter2));
        nullFilter1.nullCheckValue(this.testExp3);
        FilterEqualsTest.assertTrue((!nullFilter1.equals((Object)nullFilter2) ? 1 : 0) != 0);
        FilterEqualsTest.assertTrue((!nullFilter1.equals((Object)new BetweenFilterImpl()) ? 1 : 0) != 0);
    }

    public void testGeometryFilter() throws IllegalFilterException {
        Disjoint geomFilter1 = this.ff.disjoint((org.opengis.filter.expression.Expression)this.testExp1, (org.opengis.filter.expression.Expression)this.testExp4);
        Disjoint geomFilter2 = this.ff.disjoint((org.opengis.filter.expression.Expression)this.testExp2, (org.opengis.filter.expression.Expression)this.testExp4);
        FilterEqualsTest.assertTrue((boolean)geomFilter1.equals(geomFilter2));
        geomFilter2 = this.ff.disjoint((org.opengis.filter.expression.Expression)this.testExp2, (org.opengis.filter.expression.Expression)new LiteralExpressionImpl((Object)new Double(45.0)));
        FilterEqualsTest.assertTrue((!geomFilter1.equals(geomFilter2) ? 1 : 0) != 0);
        this.tFilter1 = this.ff.between((org.opengis.filter.expression.Expression)this.ff.literal(1), (org.opengis.filter.expression.Expression)this.ff.literal(-1), (org.opengis.filter.expression.Expression)this.ff.literal(3));
        FilterEqualsTest.assertTrue((!geomFilter1.equals(this.tFilter1) ? 1 : 0) != 0);
    }
}

