/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FidFilter;
import org.geotools.filter.FidFilterImpl;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.Filters;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.MathExpression;
import org.geotools.filter.NullFilter;
import org.geotools.filter.expression.AddImpl;
import org.geotools.filter.function.math.FilterFunction_min;
import org.geotools.util.logging.Logging;

public class FilterVisitorTest
extends TestCase
implements FilterVisitor {
    int checkcode;

    public FilterVisitorTest(String testName) {
        super(testName);
    }

    public static void main(String[] args) {
        Logging.GEOTOOLS.forceMonolineConsoleOutput();
        TestRunner.run((Test)FilterVisitorTest.suite());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(FilterVisitorTest.class);
        return suite;
    }

    public void visit(Filter filter) {
        FilterVisitorTest.fail((String)"should never end up here, overloaded method should have been called instead");
    }

    public void visit(BetweenFilter filter) {
        DefaultExpression left = (DefaultExpression)filter.getLeftValue();
        DefaultExpression right = (DefaultExpression)filter.getRightValue();
        DefaultExpression mid = (DefaultExpression)filter.getMiddleValue();
    }

    public void visit(LikeFilter filter) {
    }

    public void visit(LogicFilter filter) {
        Iterator list = filter.getFilterIterator();
        if (filter.getFilterType() == 3) {
            Filters.accept((org.opengis.filter.Filter)((org.opengis.filter.Filter)list.next()), (FilterVisitor)this);
        } else {
            while (list.hasNext()) {
                Filters.accept((org.opengis.filter.Filter)((org.opengis.filter.Filter)list.next()), (FilterVisitor)this);
            }
        }
    }

    public void visit(CompareFilter filter) {
        DefaultExpression left = (DefaultExpression)filter.getLeftValue();
        DefaultExpression right = (DefaultExpression)filter.getRightValue();
        left.accept((FilterVisitor)this);
        right.accept((FilterVisitor)this);
    }

    public void visit(GeometryFilter filter) {
    }

    public void visit(NullFilter filter) {
        DefaultExpression expr = (DefaultExpression)filter.getNullCheckValue();
        expr.accept((FilterVisitor)this);
    }

    public void visit(FidFilter filter) {
        this.checkcode = 9;
    }

    public void visit(AttributeExpression expression) {
    }

    public void visit(Expression expression) {
    }

    public void visit(LiteralExpression expression) {
        ++this.checkcode;
    }

    public void visit(MathExpression expression) {
        this.checkcode += 3;
        ((DefaultExpression)expression.getLeftValue()).accept((FilterVisitor)this);
        ((DefaultExpression)expression.getRightValue()).accept((FilterVisitor)this);
    }

    public void visit(FunctionExpression expression) {
        this.checkcode += 6;
    }

    public void testVisitLiteral() {
        this.checkcode = 0;
        LiteralExpressionImpl exp = new LiteralExpressionImpl(4);
        exp.accept((FilterVisitor)this);
        FilterVisitorTest.assertEquals((int)this.checkcode, (int)1);
    }

    public void testVisitMathExpression() throws IllegalFilterException {
        this.checkcode = 0;
        LiteralExpressionImpl testAttribute1 = new LiteralExpressionImpl((Object)new Integer(4));
        LiteralExpressionImpl testAttribute2 = new LiteralExpressionImpl((Object)new Integer(2));
        AddImpl mathTest = new AddImpl(null, null);
        mathTest.addLeftValue((Expression)testAttribute1);
        mathTest.addRightValue((Expression)testAttribute2);
        mathTest.accept((FilterVisitor)this);
        FilterVisitorTest.assertEquals((int)5, (int)this.checkcode);
    }

    public void testVisitFidFilter() throws IllegalFilterException {
        this.checkcode = 0;
        FidFilterImpl ff = new FidFilterImpl();
        ff.accept((FilterVisitor)this);
        FilterVisitorTest.assertEquals((int)9, (int)this.checkcode);
    }

    public void testFunctionExpression() {
        this.checkcode = 0;
        FilterFunction_min min = new FilterFunction_min();
        min.accept((FilterVisitor)this);
        FilterVisitorTest.assertEquals((int)6, (int)this.checkcode);
    }
}

