/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import junit.framework.Assert;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.Test;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class StringFunctionTest {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    @Test
    public void testStrReplace() {
        Literal foo = this.ff.literal((Object)"foo");
        Literal o = this.ff.literal((Object)"o");
        Literal bar = this.ff.literal((Object)"bar");
        Function f = this.ff.function("strReplace", new Expression[]{foo, o, bar, this.ff.literal(true)});
        String s = (String)f.evaluate(null, String.class);
        Assert.assertEquals((String)"fbarbar", (String)s);
        f = this.ff.function("strReplace", new Expression[]{foo, o, bar, this.ff.literal(false)});
        s = (String)f.evaluate(null, String.class);
        Assert.assertEquals((String)"fbaro", (String)s);
    }

    @Test
    public void testParseLong() {
        Assert.assertEquals((Object)Long.MAX_VALUE, (Object)this.ff.function("parseLong", new Expression[]{this.ff.literal((Object)"9223372036854775807")}).evaluate(null));
        Assert.assertEquals((Object)5L, (Object)this.ff.function("parseLong", new Expression[]{this.ff.literal((Object)"5.0")}).evaluate(null));
    }

    @Test
    public void testCapitalize() {
        Assert.assertEquals((Object)"United Kingdom", (Object)this.ff.function("strCapitalize", new Expression[]{this.ff.literal((Object)"UNITED KINGDOM")}).evaluate(null));
        Assert.assertEquals((Object)"United Kingdom", (Object)this.ff.function("strCapitalize", new Expression[]{this.ff.literal((Object)"UnItEd kInGdOm")}).evaluate(null));
    }
}

