/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import junit.framework.TestCase;
import org.geotools.factory.Hints;
import org.geotools.util.ConverterFactory;
import org.geotools.util.NumericConverterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericConverterFactoryTest
extends TestCase {
    NumericConverterFactory factory;

    protected void setUp() throws Exception {
        this.factory = new NumericConverterFactory();
    }

    public void testIntegral() throws Exception {
        NumericConverterFactoryTest.assertEquals((Object)new Byte(127), (Object)this.convert(new Byte(127), Byte.class));
        NumericConverterFactoryTest.assertEquals((Object)new Byte(127), (Object)this.convert(new Short(127), Byte.class));
        NumericConverterFactoryTest.assertEquals((Object)new Byte(127), (Object)this.convert(new Integer(127), Byte.class));
        NumericConverterFactoryTest.assertEquals((Object)new Byte(127), (Object)this.convert(new Long(127L), Byte.class));
        NumericConverterFactoryTest.assertEquals((Object)new Byte(127), (Object)this.convert(BigInteger.valueOf(127L), Byte.class));
        NumericConverterFactoryTest.assertEquals((Object)new Short(127), (Object)this.convert(new Byte(127), Short.class));
        NumericConverterFactoryTest.assertEquals((Object)new Short(127), (Object)this.convert(new Short(127), Short.class));
        NumericConverterFactoryTest.assertEquals((Object)new Short(127), (Object)this.convert(new Integer(127), Short.class));
        NumericConverterFactoryTest.assertEquals((Object)new Short(127), (Object)this.convert(new Long(127L), Short.class));
        NumericConverterFactoryTest.assertEquals((Object)new Short(127), (Object)this.convert(BigInteger.valueOf(127L), Short.class));
        NumericConverterFactoryTest.assertEquals((Object)new Integer(127), (Object)this.convert(new Byte(127), Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)new Integer(127), (Object)this.convert(new Short(127), Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)new Integer(127), (Object)this.convert(new Integer(127), Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)new Integer(127), (Object)this.convert(new Long(127L), Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)new Integer(127), (Object)this.convert(BigInteger.valueOf(127L), Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)new Long(127L), (Object)this.convert(new Byte(127), Long.class));
        NumericConverterFactoryTest.assertEquals((Object)new Long(127L), (Object)this.convert(new Short(127), Long.class));
        NumericConverterFactoryTest.assertEquals((Object)new Long(127L), (Object)this.convert(new Integer(127), Long.class));
        NumericConverterFactoryTest.assertEquals((Object)new Long(127L), (Object)this.convert(new Long(127L), Long.class));
        NumericConverterFactoryTest.assertEquals((Object)new Long(127L), (Object)this.convert(BigInteger.valueOf(127L), Long.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convert(new Byte(127), BigInteger.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convert(new Short(127), BigInteger.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convert(new Integer(127), BigInteger.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convert(new Long(127L), BigInteger.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convert(BigInteger.valueOf(127L), BigInteger.class));
    }

    public void testFloat() throws Exception {
        NumericConverterFactoryTest.assertEquals((Object)new Float(127.127), (Object)this.convert(new Float(127.127), Float.class));
        NumericConverterFactoryTest.assertEquals((Object)new Float(127.127), (Object)this.convert(new Double(127.127), Float.class));
        NumericConverterFactoryTest.assertEquals((Object)new Float(127.127), (Object)this.convert(new BigDecimal(127.127), Float.class));
        NumericConverterFactoryTest.assertEquals((double)new Double(127.127), (double)((Double)this.convert(new Float(127.127), Double.class)), (double)1.0E-10);
        NumericConverterFactoryTest.assertEquals((Object)new Double(127.127), (Object)this.convert(new Double(127.127), Double.class));
        NumericConverterFactoryTest.assertEquals((Object)new Double(127.127), (Object)this.convert(new BigDecimal(127.127), Double.class));
        NumericConverterFactoryTest.assertEquals((double)new BigDecimal(127.127).doubleValue(), (double)((BigDecimal)this.convert(new Float(127.127), BigDecimal.class)).doubleValue(), (double)1.0E-10);
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal("127.127"), (Object)this.convert(new Double(127.127), BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(127.127), (Object)this.convert(new BigDecimal(127.127), BigDecimal.class));
    }

    public void testIntegralToFloat() throws Exception {
        NumericConverterFactoryTest.assertEquals((Object)new Float(127.0), (Object)this.convert(new Byte(127), Float.class));
        NumericConverterFactoryTest.assertEquals((Object)new Float(127.0), (Object)this.convert(new Short(127), Float.class));
        NumericConverterFactoryTest.assertEquals((Object)new Float(127.0), (Object)this.convert(new Integer(127), Float.class));
        NumericConverterFactoryTest.assertEquals((Object)new Float(127.0), (Object)this.convert(new Long(127L), Float.class));
        NumericConverterFactoryTest.assertEquals((Object)new Float(127.0), (Object)this.convert(BigInteger.valueOf(127L), Float.class));
        NumericConverterFactoryTest.assertEquals((Object)new Double(127.0), (Object)this.convert(new Byte(127), Double.class));
        NumericConverterFactoryTest.assertEquals((Object)new Double(127.0), (Object)this.convert(new Short(127), Double.class));
        NumericConverterFactoryTest.assertEquals((Object)new Double(127.0), (Object)this.convert(new Integer(127), Double.class));
        NumericConverterFactoryTest.assertEquals((Object)new Double(127.0), (Object)this.convert(new Long(127L), Double.class));
        NumericConverterFactoryTest.assertEquals((Object)new Double(127.0), (Object)this.convert(BigInteger.valueOf(127L), Double.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(127.0), (Object)this.convert(new Byte(127), BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(127.0), (Object)this.convert(new Short(127), BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(127.0), (Object)this.convert(new Integer(127), BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(127.0), (Object)this.convert(new Long(127L), BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(127.0), (Object)this.convert(BigInteger.valueOf(127L), BigDecimal.class));
    }

    public void testFloatToIntegral() throws Exception {
        NumericConverterFactoryTest.assertEquals((Object)new Byte(127), (Object)this.convert(new Float(127.127), Byte.class));
        NumericConverterFactoryTest.assertEquals((Object)new Byte(127), (Object)this.convert(new Double(127.127), Byte.class));
        NumericConverterFactoryTest.assertEquals((Object)new Byte(127), (Object)this.convert(new BigDecimal(127.127), Byte.class));
        NumericConverterFactoryTest.assertEquals((Object)new Short(127), (Object)this.convert(new Float(127.127), Short.class));
        NumericConverterFactoryTest.assertEquals((Object)new Short(127), (Object)this.convert(new Double(127.127), Short.class));
        NumericConverterFactoryTest.assertEquals((Object)new Short(127), (Object)this.convert(new BigDecimal(127.127), Short.class));
        NumericConverterFactoryTest.assertEquals((Object)new Integer(127), (Object)this.convert(new Float(127.127), Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)new Integer(127), (Object)this.convert(new Double(127.127), Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)new Integer(127), (Object)this.convert(new BigDecimal(127.127), Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)new Long(127L), (Object)this.convert(new Float(127.127), Long.class));
        NumericConverterFactoryTest.assertEquals((Object)new Long(127L), (Object)this.convert(new Double(127.127), Long.class));
        NumericConverterFactoryTest.assertEquals((Object)new Long(127L), (Object)this.convert(new BigDecimal(127.127), Long.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convert(new Float(127.127), BigInteger.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convert(new Double(127.127), BigInteger.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convert(new BigDecimal(127.127), BigInteger.class));
    }

    public void testStringToInteger() throws Exception {
        NumericConverterFactoryTest.assertEquals((Object)new Integer(127), (Object)this.convert("127", Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)new Integer(127), (Object)this.convert(" 127 ", Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)new Integer(3), (Object)this.convert(" 3.0 ", Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)new Integer(-3), (Object)this.convert("-3.0 ", Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)new Integer(3000), (Object)this.convert("3000.0 ", Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)new Integer(3000), (Object)this.convert("3000,0 ", Integer.class));
    }

    public void testStringToDouble() throws Exception {
        NumericConverterFactoryTest.assertEquals((Object)new Double(4.4), (Object)this.convert("4.4", Double.class));
        NumericConverterFactoryTest.assertEquals((Object)new Double(127.0), (Object)this.convert("127", Double.class));
        NumericConverterFactoryTest.assertEquals((Object)new Double(127.0), (Object)this.convert(" 127 ", Double.class));
        NumericConverterFactoryTest.assertEquals((Object)new Double(3.0), (Object)this.convert(" 3.0 ", Double.class));
        NumericConverterFactoryTest.assertEquals((Object)new Double(-3.0), (Object)this.convert("-3.0 ", Double.class));
        NumericConverterFactoryTest.assertEquals((Object)new Double(3000.0), (Object)this.convert("3000.0 ", Double.class));
    }

    public void testStringToNumber() throws Exception {
        NumericConverterFactoryTest.assertEquals((Object)new Double(4.4), (Object)this.convert("4.4", Number.class));
    }

    Object convert(Object source, Class target) throws Exception {
        return this.factory.createConverter(source.getClass(), target, null).convert(source, target);
    }

    public static void testIntegralHandling() {
        NumericConverterFactoryTest.assertEquals((String)"3", (String)NumericConverterFactory.toIntegral((String)"3"));
        NumericConverterFactoryTest.assertEquals((String)"3", (String)NumericConverterFactory.toIntegral((String)"3.0"));
        NumericConverterFactoryTest.assertEquals((String)"-3", (String)NumericConverterFactory.toIntegral((String)"-3"));
        NumericConverterFactoryTest.assertEquals((String)"-3", (String)NumericConverterFactory.toIntegral((String)"-3.0"));
        NumericConverterFactoryTest.assertEquals((String)"3000", (String)NumericConverterFactory.toIntegral((String)"3000.0"));
        NumericConverterFactoryTest.assertEquals((String)"3000", (String)NumericConverterFactory.toIntegral((String)"3000,0"));
    }

    Object convertSafe(Object source, Class<?> target) throws Exception {
        Hints hints = new Hints();
        hints.put((Object)ConverterFactory.SAFE_CONVERSION, (Object)new Boolean(true));
        return this.factory.createConverter(source.getClass(), target, hints).convert(source, target);
    }

    public void testSafeConversion() throws Exception {
        NumericConverterFactoryTest.assertEquals((Object)new Byte(127), (Object)this.convertSafe(new Byte(127), Byte.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new Short(128), Byte.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new Integer(128), Byte.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new Long(128L), Byte.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(BigInteger.valueOf(128L), Byte.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new Double(128.1), Byte.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new BigDecimal(128.1), Byte.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new Float(128.1), Byte.class));
        NumericConverterFactoryTest.assertEquals((Object)new Short(127), (Object)this.convertSafe(new Byte(127), Short.class));
        NumericConverterFactoryTest.assertEquals((Object)new Short(1111), (Object)this.convertSafe(new Short(1111), Short.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new Integer(128), Short.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new Long(128L), Short.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(BigInteger.valueOf(128L), Short.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new Double(128.1), Short.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new BigDecimal(128.1), Short.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new Float(128.1), Short.class));
        NumericConverterFactoryTest.assertEquals((Object)new Integer(127), (Object)this.convertSafe(new Byte(127), Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)new Integer(1111), (Object)this.convertSafe(new Short(1111), Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)new Integer(12345), (Object)this.convertSafe(new Integer(12345), Integer.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new Long(128L), Integer.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(BigInteger.valueOf(128L), Integer.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new Double(128.1), Integer.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new BigDecimal(128.1), Integer.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new Float(128.1), Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)new Long(127L), (Object)this.convertSafe(new Byte(127), Long.class));
        NumericConverterFactoryTest.assertEquals((Object)new Long(1111L), (Object)this.convertSafe(new Short(1111), Long.class));
        NumericConverterFactoryTest.assertEquals((Object)new Long(12345L), (Object)this.convertSafe(new Integer(12345), Long.class));
        NumericConverterFactoryTest.assertEquals((Object)new Long(1234567L), (Object)this.convertSafe(new Integer(1234567), Long.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(BigInteger.valueOf(128L), Long.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new Double(128.1), Long.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new BigDecimal(128.1), Long.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new Float(128.1), Long.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(127L), (Object)this.convertSafe(new Byte(127), BigInteger.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(1111L), (Object)this.convertSafe(new Short(1111), BigInteger.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(12345L), (Object)this.convertSafe(new Integer(12345), BigInteger.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(1234567L), (Object)this.convertSafe(new Integer(1234567), BigInteger.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(12345678L), (Object)this.convertSafe(BigInteger.valueOf(12345678L), BigInteger.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new Double(128.1), Long.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new BigDecimal(128.1), Long.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new Float(128.1), Long.class));
        NumericConverterFactoryTest.assertEquals((Object)new Double(127.0), (Object)this.convertSafe(new Byte(127), Double.class));
        NumericConverterFactoryTest.assertEquals((Object)new Double(1111.0), (Object)this.convertSafe(new Short(1111), Double.class));
        NumericConverterFactoryTest.assertEquals((Object)new Double(12345.0), (Object)this.convertSafe(new Integer(12345), Double.class));
        NumericConverterFactoryTest.assertEquals((Object)new Double(1234567.0), (Object)this.convertSafe(new Integer(1234567), Double.class));
        NumericConverterFactoryTest.assertEquals((Object)new Double(12.123456), (Object)this.convertSafe(new Double(12.123456), Double.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new BigDecimal(128.1), Long.class));
        NumericConverterFactoryTest.assertEquals((Object)new Double(12.12), (Object)this.convertSafe(new Float(12.12), Double.class));
        NumericConverterFactoryTest.assertEquals((Object)new Float(127.0f), (Object)this.convertSafe(new Byte(127), Float.class));
        NumericConverterFactoryTest.assertEquals((Object)new Float(1111.0f), (Object)this.convertSafe(new Short(1111), Float.class));
        NumericConverterFactoryTest.assertEquals((Object)new Float(12345.0f), (Object)this.convertSafe(new Integer(12345), Float.class));
        NumericConverterFactoryTest.assertEquals((Object)new Float(1234567.0f), (Object)this.convertSafe(new Integer(1234567), Float.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(BigInteger.valueOf(12345678L), Float.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new Double(128.1), Float.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe(new BigDecimal(128.1), Float.class));
        NumericConverterFactoryTest.assertEquals((Object)new Float(12.12), (Object)this.convertSafe(new Float(12.12), Float.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(127), (Object)this.convertSafe(new Byte(127), BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(1111), (Object)this.convertSafe(new Short(1111), BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(12345), (Object)this.convertSafe(new Integer(12345), BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(1234567), (Object)this.convertSafe(new Integer(1234567), BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(12345678), (Object)this.convertSafe(BigInteger.valueOf(12345678L), BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(new Double(12.123456).toString()), (Object)this.convertSafe(new Double(12.123456), BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(128.1), (Object)this.convertSafe(new BigDecimal(128.1), BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(new Float(12.12).toString()), (Object)this.convertSafe(new Float(12.12), BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new BigDecimal(127), (Object)this.convertSafe("127", BigDecimal.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe("127f", BigDecimal.class));
        NumericConverterFactoryTest.assertEquals((Object)new Double(127.123), (Object)this.convertSafe("127.123", Double.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe("123.456.456", Double.class));
        NumericConverterFactoryTest.assertEquals((Object)new Float(127.123), (Object)this.convertSafe("127.123", Float.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe("123.456.456", Float.class));
        NumericConverterFactoryTest.assertEquals((Object)BigInteger.valueOf(1234567L), (Object)this.convertSafe("1234567", BigInteger.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe("123.456", BigInteger.class));
        NumericConverterFactoryTest.assertEquals((Object)new Long(54L), (Object)this.convertSafe("54", Long.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe("123.6", Long.class));
        NumericConverterFactoryTest.assertEquals((Object)new Integer(54), (Object)this.convertSafe("54", Integer.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe("123.6", Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)new Short(54), (Object)this.convertSafe("54", Short.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe("123.6", Short.class));
        NumericConverterFactoryTest.assertEquals((Object)new Byte("1"), (Object)this.convertSafe("1", Byte.class));
        NumericConverterFactoryTest.assertNull((Object)this.convertSafe("123.6", Byte.class));
    }

    public void testPrimitiveTypes() throws Exception {
        NumericConverterFactoryTest.assertEquals((Object)1, (Object)this.convert(new Integer(1), Integer.TYPE));
        NumericConverterFactoryTest.assertEquals((Object)new Integer(1), (Object)this.convert(new Integer(1), Integer.TYPE));
        NumericConverterFactoryTest.assertEquals((Object)1, (Object)this.convert(1, Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)new Integer(1), (Object)this.convert(1, Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)1, (Object)this.convert("1", Integer.TYPE));
        NumericConverterFactoryTest.assertEquals((Object)new Integer(1), (Object)this.convert("1", Integer.TYPE));
        NumericConverterFactoryTest.assertEquals((Object)1, (Object)this.convert("1", Integer.class));
        NumericConverterFactoryTest.assertEquals((Object)new Integer(1), (Object)this.convert("1", Integer.class));
    }
}

