/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.matfile5;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class UTMUtilities {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.coverageio.matfile5.sas");
    public static final List<String> UTM_NORTHS = new ArrayList<String>(60);
    public static final List<String> UTM_SOUTHS = new ArrayList<String>(60);
    private static final String EPSG_N = "EPSG:326";
    private static final String EPSG_S = "EPSG:327";
    private static final Map<String, ReferencedEnvelope> AOI_MAP = new HashMap<String, ReferencedEnvelope>(120);
    private static final SoftValueHashMap<String, CoordinateReferenceSystem> CRS_MAP = new SoftValueHashMap();
    private static final String DEFAULT_FIRST_TO_BE_SEEKED = "EPSG:32634";

    private UTMUtilities() {
    }

    private static ReferencedEnvelope getReferencedEnvelopeFromGeographicBoundingBox(GeographicBoundingBox geographicBBox) {
        if (geographicBBox == null) {
            throw new IllegalArgumentException("Provided null bounding box");
        }
        return new ReferencedEnvelope(geographicBBox.getEastBoundLongitude(), geographicBBox.getWestBoundLongitude(), geographicBBox.getSouthBoundLatitude(), geographicBBox.getNorthBoundLatitude(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CoordinateReferenceSystem getCRS(String epsgCode) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = null;
        if (epsgCode != null && epsgCode.trim().length() > 1) {
            SoftValueHashMap<String, CoordinateReferenceSystem> softValueHashMap = CRS_MAP;
            synchronized (softValueHashMap) {
                if (!CRS_MAP.containsKey((Object)epsgCode)) {
                    crs = CRS.decode((String)epsgCode);
                    CRS_MAP.put((Object)epsgCode, (Object)crs);
                } else {
                    crs = (CoordinateReferenceSystem)CRS_MAP.get((Object)epsgCode);
                    if (crs == null) {
                        crs = CRS.decode((String)epsgCode);
                        CRS_MAP.put((Object)epsgCode, (Object)crs);
                    }
                }
            }
        }
        return crs;
    }

    public static CoordinateReferenceSystem getProperUTM(double lon, double lat) {
        CoordinateReferenceSystem crs;
        block6: {
            crs = null;
            try {
                ReferencedEnvelope env;
                if (AOI_MAP.containsKey(DEFAULT_FIRST_TO_BE_SEEKED) && (env = AOI_MAP.get(DEFAULT_FIRST_TO_BE_SEEKED)).contains(lon, lat)) {
                    return UTMUtilities.getCRS(DEFAULT_FIRST_TO_BE_SEEKED);
                }
                for (String code : AOI_MAP.keySet()) {
                    if (!AOI_MAP.containsKey(code) || !(env = AOI_MAP.get(code)).contains(lon, lat)) continue;
                    return UTMUtilities.getCRS(code);
                }
            }
            catch (NoSuchAuthorityCodeException e) {
                crs = null;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.getLocalizedMessage());
                }
            }
            catch (FactoryException e) {
                crs = null;
                if (!LOGGER.isLoggable(Level.FINE)) break block6;
                LOGGER.log(Level.FINE, e.getLocalizedMessage());
            }
        }
        return crs;
    }

    static {
        for (int i = 1; i < 61; ++i) {
            StringBuilder sbn = new StringBuilder(EPSG_N);
            StringBuilder sbs = new StringBuilder(EPSG_S);
            if (i < 10) {
                sbn.append("0");
                sbs.append("0");
            }
            sbn.append(i);
            sbs.append(i);
            String epsgcodeN = sbn.toString();
            String epsgcodeS = sbs.toString();
            UTM_NORTHS.add(epsgcodeN);
            UTM_SOUTHS.add(epsgcodeS);
            for (int j = 0; j < 2; ++j) {
                CoordinateReferenceSystem crs;
                String epsgCode;
                block7: {
                    epsgCode = j == 0 ? epsgcodeN : epsgcodeS;
                    crs = null;
                    try {
                        crs = UTMUtilities.getCRS(epsgCode);
                    }
                    catch (NoSuchAuthorityCodeException e) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, e.getLocalizedMessage());
                        }
                    }
                    catch (FactoryException e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block7;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage());
                    }
                }
                if (crs == null) continue;
                Extent extent = crs.getDomainOfValidity();
                Collection geo = extent.getGeographicElements();
                GeographicExtent geoext = (GeographicExtent)geo.iterator().next();
                GeographicBoundingBoxImpl impl = (GeographicBoundingBoxImpl)geoext;
                ReferencedEnvelope env = UTMUtilities.getReferencedEnvelopeFromGeographicBoundingBox((GeographicBoundingBox)impl);
                AOI_MAP.put(epsgCode, env);
            }
        }
    }
}

