/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.util;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opengis.annotation.UML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CodeList<E extends CodeList<E>>
implements Comparable<E>,
Serializable {
    private static final long serialVersionUID = 5655809691319522885L;
    private static final Map<Class<? extends CodeList>, Collection<? extends CodeList>> VALUES = new HashMap<Class<? extends CodeList>, Collection<? extends CodeList>>();
    private static final Class<String>[] CONSTRUCTOR_PARAMETERS = new Class[]{String.class};
    private final transient int ordinal;
    private final String name;
    private transient String identifier;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CodeList(String name, Collection<E> values) {
        this.name = name = name.trim();
        Collection<CodeList> collection = values;
        synchronized (collection) {
            this.ordinal = values.size();
            if (!values.add(this)) {
                throw new IllegalArgumentException("Duplicated value: " + name);
            }
        }
        Class<?> codeType = this.getClass();
        Map<Class<? extends CodeList>, Collection<? extends CodeList>> map = VALUES;
        synchronized (map) {
            Collection<E> previous = VALUES.put(codeType, values);
            if (previous != null && previous != values) {
                VALUES.put(codeType, previous);
                throw new IllegalArgumentException("List already exists: " + values);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends CodeList> T valueOf(Class<T> codeType, String name) {
        Collection<? extends CodeList> values;
        if (name == null) {
            return null;
        }
        name = name.trim();
        Object object = VALUES;
        synchronized (object) {
            values = VALUES.get(codeType);
            if (values == null) {
                if (codeType == null) {
                    throw new IllegalArgumentException("Code type is null");
                }
                throw new IllegalStateException("No collection of " + codeType.getSimpleName());
            }
        }
        object = values;
        synchronized (object) {
            for (CodeList codeList : values) {
                if (!codeList.matches(name)) continue;
                return (T)((CodeList)codeType.cast(codeList));
            }
            try {
                Constructor<T> constructor = codeType.getDeclaredConstructor(CONSTRUCTOR_PARAMETERS);
                constructor.setAccessible(true);
                return (T)((CodeList)constructor.newInstance(name));
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Can't create code of type " + codeType.getSimpleName(), exception);
            }
        }
    }

    public final int ordinal() {
        return this.ordinal;
    }

    public String identifier() {
        String identifier = this.identifier;
        if (identifier == null) {
            Field field;
            Class<?> codeType = this.getClass();
            try {
                field = codeType.getField(this.name);
            }
            catch (NoSuchFieldException e) {
                field = null;
            }
            if (field != null && Modifier.isStatic(field.getModifiers())) {
                UML annotation;
                Object value;
                try {
                    value = field.get(null);
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
                if (this.equals(value) && (annotation = field.getAnnotation(UML.class)) != null) {
                    identifier = annotation.identifier();
                }
            }
            if (identifier == null) {
                identifier = "";
            }
            this.identifier = identifier;
        }
        return identifier.length() != 0 ? identifier : null;
    }

    public final String name() {
        return this.name;
    }

    public boolean matches(String name) {
        if (name == null) {
            return false;
        }
        if (name.equalsIgnoreCase(this.name)) {
            return true;
        }
        String identifier = this.identifier();
        return identifier != null && name.equalsIgnoreCase(identifier);
    }

    public abstract E[] family();

    @Override
    public final int compareTo(E other) {
        Class<?> co;
        Class<?> ct = this.getClass();
        if (!ct.equals(co = other.getClass())) {
            throw new ClassCastException("Can't compare " + ct.getSimpleName() + " to " + co.getSimpleName());
        }
        return this.ordinal - ((CodeList)other).ordinal;
    }

    public final boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            return this.ordinal == ((CodeList)object).ordinal;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + '[' + this.name + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object readResolve() throws ObjectStreamException {
        Collection<? extends CodeList> values;
        Class<?> codeType = this.getClass();
        Object object = VALUES;
        synchronized (object) {
            values = VALUES.get(codeType);
        }
        if (values != null) {
            object = values;
            synchronized (object) {
                for (CodeList codeList : values) {
                    if (!codeType.isInstance(codeList)) {
                        return this;
                    }
                    if (!codeList.matches(this.name)) continue;
                    return codeList;
                }
                Collection<? extends CodeList> collection = values;
                if (!collection.add(this)) {
                    throw new InvalidObjectException(this.name);
                }
            }
        }
        return this;
    }
}

