/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import oracle.jdbc.OracleConnection;
import oracle.sql.STRUCT;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.DefaultSQLBuilder;
import org.geotools.data.jdbc.FeatureTypeInfo;
import org.geotools.data.jdbc.JDBC1DataStore;
import org.geotools.data.jdbc.JDBCDataStore;
import org.geotools.data.jdbc.JDBCDataStoreConfig;
import org.geotools.data.jdbc.JDBCFeatureWriter;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.data.jdbc.attributeio.AttributeIO;
import org.geotools.data.jdbc.datasource.DataSourceFinder;
import org.geotools.data.jdbc.datasource.UnWrapper;
import org.geotools.data.oracle.OracleFeatureLocking;
import org.geotools.data.oracle.OracleFeatureSource;
import org.geotools.data.oracle.OracleFeatureStore;
import org.geotools.data.oracle.OracleFeatureWriter;
import org.geotools.data.oracle.SqlStatementEncoder;
import org.geotools.data.oracle.attributeio.SDOAttributeIO;
import org.geotools.data.oracle.referencing.OracleAuthorityFactory;
import org.geotools.data.oracle.sdo.GeometryConverter;
import org.geotools.data.oracle.sdo.TT;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.SchemaException;
import org.geotools.filter.SQLEncoder;
import org.geotools.filter.SQLEncoderException;
import org.geotools.filter.SQLEncoderOracle;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeodeticCRS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDataStore
extends JDBCDataStore {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.oracle");
    private OracleAuthorityFactory af;

    public OracleDataStore(DataSource dataSource, JDBCDataStoreConfig config) throws IOException {
        super(dataSource, config);
    }

    public OracleDataStore(DataSource dataSource, String schemaName, Map fidGeneration) throws IOException {
        this(dataSource, schemaName, schemaName, fidGeneration);
    }

    public OracleDataStore(DataSource dataSource, String namespace, String schemaName, Map fidGeneration) throws IOException {
        this(dataSource, new JDBCDataStoreConfig(namespace, schemaName, null, fidGeneration));
    }

    protected boolean allowTable(String tablename) {
        LOGGER.finer("checking table name: " + tablename);
        if (tablename.endsWith("$")) {
            return false;
        }
        if (tablename.startsWith("BIN$")) {
            return false;
        }
        if (tablename.startsWith("XDB$")) {
            return false;
        }
        if (tablename.startsWith("DR$")) {
            return false;
        }
        if (tablename.startsWith("DEF$")) {
            return false;
        }
        if (tablename.startsWith("SDO_")) {
            return false;
        }
        if (tablename.startsWith("WM$")) {
            return false;
        }
        if (tablename.startsWith("WK$")) {
            return false;
        }
        if (tablename.startsWith("AW$")) {
            return false;
        }
        if (tablename.startsWith("AQ$")) {
            return false;
        }
        if (tablename.startsWith("APPLY$")) {
            return false;
        }
        if (tablename.startsWith("REPCAT$")) {
            return false;
        }
        if (tablename.startsWith("CWM$")) {
            return false;
        }
        if (tablename.startsWith("CWM2$")) {
            return false;
        }
        if (tablename.startsWith("EXF$")) {
            return false;
        }
        if (tablename.startsWith("DM$")) {
            return false;
        }
        LOGGER.finer("returning true for tablename: " + tablename);
        return true;
    }

    protected AttributeDescriptor buildAttributeType(ResultSet rs) throws IOException {
        int TABLE_NAME = 3;
        int COLUMN_NAME = 4;
        int TYPE_NAME = 6;
        int IS_NULLABLE = 18;
        try {
            if (rs.getString(6).equals("SDO_GEOMETRY")) {
                String tableName = rs.getString(3);
                String columnName = rs.getString(4);
                String isNullable = rs.getString(18);
                return this.getSDOGeometryAttribute(tableName, columnName, "YES".equals(isNullable));
            }
            return super.buildAttributeType(rs);
        }
        catch (SQLException e) {
            throw new DataSourceException("Sql error occurred", (Throwable)e);
        }
    }

    private AttributeDescriptor getSDOGeometryAttribute(String tableName, String columnName, boolean isNullable) {
        int srid = 0;
        AttributeTypeBuilder build = new AttributeTypeBuilder();
        build.setNillable(isNullable);
        try {
            Class geomClass = this.determineGeometryClass(tableName, columnName);
            build.setBinding(geomClass);
        }
        catch (Exception e) {
            LOGGER.warning("could not determin Geometry class");
        }
        try {
            srid = this.determineSRID(tableName, columnName);
            CoordinateReferenceSystem crs = null;
            try {
                crs = CRS.decode((String)("EPSG:" + srid));
            }
            catch (Exception e) {
                crs = this.determineCRS(srid);
            }
            build.setCRS(crs);
        }
        catch (Exception e) {
            LOGGER.warning("Could not map SRID " + srid + " to CRS:" + e);
        }
        return build.buildDescriptor(columnName);
    }

    private Class determineGeometryClass(String tableName, String columnName) throws IOException {
        Class<Geometry> clazz;
        ResultSet result;
        Statement statement;
        Connection conn;
        block7: {
            conn = null;
            statement = null;
            result = null;
            String sqlStatement = "select meta.sdo_layer_gtype \nfrom mdsys.ALL_SDO_INDEX_INFO info \n inner join mdsys.user_sdo_index_metadata meta \n on info.index_name = meta.sdo_index_name \nwhere info.table_name = '" + tableName + "' \n" + "and info.column_name = '" + columnName + "'";
            String schema = this.config.getDatabaseSchemaName();
            if (schema != null && !"".equals(schema)) {
                sqlStatement = sqlStatement + " and info.table_owner = '" + schema + "'";
            }
            conn = this.getConnection(Transaction.AUTO_COMMIT);
            LOGGER.finer("the sql statement for geometry type check is " + sqlStatement);
            statement = conn.createStatement();
            result = statement.executeQuery(sqlStatement);
            if (!result.next()) break block7;
            String gType = result.getString(1);
            Class<Geometry> geometryClass = (Class<Geometry>)TT.GEOM_CLASSES.get(gType);
            if (geometryClass == null) {
                geometryClass = Geometry.class;
            }
            Class<Geometry> clazz2 = geometryClass;
            JDBCUtils.close((ResultSet)result);
            JDBCUtils.close((Statement)statement);
            JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
            return clazz2;
        }
        try {
            clazz = Geometry.class;
        }
        catch (SQLException sqle) {
            try {
                String message = sqle.getMessage();
                LOGGER.fine("Could not determine geometry class due to an error_: " + sqle);
                throw new DataSourceException(message, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                JDBCUtils.close(result);
                JDBCUtils.close(statement);
                JDBCUtils.close(conn, (Transaction)Transaction.AUTO_COMMIT, null);
                throw throwable;
            }
        }
        JDBCUtils.close((ResultSet)result);
        JDBCUtils.close((Statement)statement);
        JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
        return clazz;
    }

    protected CoordinateReferenceSystem determineCRS(int srid) throws IOException {
        try {
            return this.getOracleAuthorityFactory().createCRS(srid);
        }
        catch (FactoryException e) {
            return null;
        }
    }

    protected int determineSRID(String tableName, String geometryColumnName) throws IOException {
        Connection conn;
        block6: {
            conn = null;
            String sqlStatement = "SELECT SRID FROM MDSYS.ALL_SDO_GEOM_METADATA WHERE TABLE_NAME='" + tableName + "' AND COLUMN_NAME='" + geometryColumnName + "'";
            String schema = this.config.getDatabaseSchemaName();
            if (schema != null && !"".equals(schema)) {
                sqlStatement = sqlStatement + " and OWNER = '" + schema + "'";
            }
            conn = this.getConnection(Transaction.AUTO_COMMIT);
            LOGGER.finer("the sql statement for srid is " + sqlStatement);
            Statement statement = conn.createStatement();
            ResultSet result = statement.executeQuery(sqlStatement);
            if (!result.next()) break block6;
            int retSrid = result.getInt("srid");
            JDBCUtils.close((Statement)statement);
            int n = retSrid;
            JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
            return n;
        }
        try {
            try {
                String mesg = "No geometry column row for srid in table: " + tableName + ", geometry column " + geometryColumnName + ", be sure column is defined in USER_SDO_GEOM_METADATA";
                throw new DataSourceException(mesg);
            }
            catch (SQLException sqle) {
                String message = sqle.getMessage();
                throw new DataSourceException(message, (Throwable)sqle);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(conn, (Transaction)Transaction.AUTO_COMMIT, null);
            throw throwable;
        }
    }

    private OracleAuthorityFactory getOracleAuthorityFactory() {
        if (this.af == null) {
            this.af = new OracleAuthorityFactory(this.dataSource);
        }
        return this.af;
    }

    public SQLBuilder getSqlBuilder(String typeName) throws IOException {
        FeatureTypeInfo info = this.typeHandler.getFeatureTypeInfo(typeName);
        SQLEncoderOracle encoder = new SQLEncoderOracle(info.getSRIDs());
        encoder.setFIDMapper(this.getFIDMapper(typeName));
        return new DefaultSQLBuilder((SQLEncoder)encoder, info.getSchema(), null);
    }

    protected AttributeIO getGeometryAttributeIO(AttributeDescriptor type, QueryData queryData) throws IOException {
        return new SDOAttributeIO(type, queryData);
    }

    protected JDBCFeatureWriter createFeatureWriter(FeatureReader<SimpleFeatureType, SimpleFeature> fReader, QueryData queryData) throws IOException {
        return new OracleFeatureWriter(fReader, queryData);
    }

    public Envelope getEnvelope(String typeName) {
        try {
            return this.bounds((Query)new DefaultQuery(typeName));
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not compute feature type bounds", e);
            return null;
        }
    }

    public boolean sql(Transaction t, String sql) throws IOException, SQLException {
        Connection conn = this.getConnection(t);
        Statement st = conn.createStatement();
        LOGGER.info(sql);
        return st.execute(sql);
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        String tableName = featureType.getTypeName();
        DefaultTransaction t = new DefaultTransaction("createSchema");
        Envelope bounds = new Envelope();
        bounds.expandToInclude(-180.0, -90.0);
        bounds.expandToInclude(180.0, 90.0);
        int srid = -1;
        SQLEncoderOracle encoder = new SQLEncoderOracle("fid", srid);
        SqlStatementEncoder statements = new SqlStatementEncoder(encoder, tableName, "fid");
        try {
            this.sql((Transaction)t, "DROP TABLE " + tableName);
            this.sql((Transaction)t, "DELETE FROM user_sdo_geom_metadata WHERE TABLE_NAME='" + tableName + "'");
        }
        catch (SQLException ignore) {
            // empty catch block
        }
        try {
            this.sql((Transaction)t, statements.makeCreateTableSQL(featureType));
            this.sql((Transaction)t, statements.makeAddGeomMetadata(featureType, bounds, srid));
            t.commit();
        }
        catch (SQLException e) {
            t.rollback();
            throw (IOException)new IOException(e.getLocalizedMessage()).initCause(e);
        }
        finally {
            t.close();
        }
    }

    public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(String typeName) throws IOException {
        if (!this.typeHandler.getFIDMapper(typeName).isVolatile() || this.allowWriteOnVolatileFIDs) {
            if (this.getLockingManager() != null) {
                return new OracleFeatureLocking((JDBC1DataStore)this, this.getSchema(typeName));
            }
            return new OracleFeatureStore((JDBC1DataStore)this, this.getSchema(typeName));
        }
        return new OracleFeatureSource((JDBC1DataStore)this, this.getSchema(typeName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReferencedEnvelope bounds(Query query) throws IOException {
        Filter preFilter;
        Filter filter = query.getFilter();
        if (filter == Filter.EXCLUDE) {
            return new ReferencedEnvelope(new Envelope(), query.getCoordinateSystem());
        }
        SimpleFeatureType schema = this.getSchema(query.getTypeName());
        SQLBuilder sqlBuilder = this.getSqlBuilder(schema.getTypeName());
        Filter postQueryFilter = sqlBuilder.getPostQueryFilter(query.getFilter());
        if (postQueryFilter != null && !postQueryFilter.equals(Filter.INCLUDE)) {
            return null;
        }
        Connection conn = null;
        try {
            conn = this.getConnection(Transaction.AUTO_COMMIT);
            Envelope retEnv = new Envelope();
            preFilter = sqlBuilder.getPreQueryFilter(query.getFilter());
            SimpleFeatureType schemaNew = schema;
            if (!query.retrieveAllProperties()) {
                try {
                    schemaNew = DataUtilities.createSubType((SimpleFeatureType)schema, (String[])query.getPropertyNames());
                    if (schemaNew.getGeometryDescriptor() == null && schema.getGeometryDescriptor() != null) {
                        ArrayList<String> al = new ArrayList<String>(Arrays.asList(query.getPropertyNames()));
                        al.add((String)schema.getGeometryDescriptor().getName());
                        schemaNew = DataUtilities.createSubType((SimpleFeatureType)schema, (String[])al.toArray(new String[1]));
                    }
                }
                catch (SchemaException e1) {
                    throw new DataSourceException("Could not create subtype", (Throwable)e1);
                }
            }
            List attributeTypes = schemaNew.getAttributeDescriptors();
            int n = schemaNew.getAttributeCount();
            for (int j = 0; j < n; ++j) {
                if (!Geometry.class.isAssignableFrom(((AttributeDescriptor)attributeTypes.get(j)).getType().getBinding())) continue;
                String attName = ((AttributeDescriptor)attributeTypes.get(j)).getLocalName();
                Envelope curEnv = this.getEnvelope(conn, schemaNew, attName, sqlBuilder, filter);
                if (curEnv == null) {
                    ReferencedEnvelope referencedEnvelope = null;
                    return referencedEnvelope;
                }
                retEnv.expandToInclude(curEnv);
            }
            LOGGER.finer("returning bounds " + retEnv);
            if (schemaNew != null && schemaNew.getGeometryDescriptor() != null) {
                ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(retEnv, schemaNew.getGeometryDescriptor().getCoordinateReferenceSystem());
                return referencedEnvelope;
            }
            if (query.getCoordinateSystem() != null) {
                ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(retEnv, query.getCoordinateSystem());
                return referencedEnvelope;
            }
            ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(retEnv, null);
            return referencedEnvelope;
        }
        catch (SQLException sqlException) {
            JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, (SQLException)sqlException);
            conn = null;
            throw new DataSourceException("Could not count " + query.getHandle(), (Throwable)sqlException);
        }
        catch (SQLEncoderException e) {
            preFilter = null;
            return preFilter;
        }
        catch (ParseException parseE) {
            String message = "Could not read geometry: " + parseE.getMessage();
            ReferencedEnvelope referencedEnvelope = null;
            return referencedEnvelope;
        }
        finally {
            JDBCUtils.close((Connection)conn, (Transaction)Transaction.AUTO_COMMIT, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Envelope getEnvelope(Connection conn, SimpleFeatureType schema, String geomName, SQLBuilder sqlBuilder, Filter filter) throws SQLException, SQLEncoderException, IOException, ParseException {
        StringBuffer sql = new StringBuffer();
        GeometryDescriptor gat = (GeometryDescriptor)schema.getDescriptor(geomName);
        ArrayList<String> queries = new ArrayList<String>();
        if (Filter.INCLUDE.equals(filter) && !(gat.getCoordinateReferenceSystem() instanceof GeodeticCRS)) {
            sql.append("SELECT SDO_TUNE.EXTENT_OF('").append(schema.getTypeName()).append("', '");
            sql.append(geomName).append("') from dual");
            queries.add(sql.toString());
            sql = new StringBuffer();
        }
        sql.append("SELECT SDO_AGGR_MBR(").append(geomName).append(") ");
        sqlBuilder.sqlFrom(sql, schema.getTypeName());
        sqlBuilder.sqlWhere(sql, filter);
        queries.add(sql.toString());
        LOGGER.fine("SQL: " + sql);
        Statement statement = null;
        ResultSet results = null;
        Envelope result = null;
        for (String query : queries) {
            block4: {
                Envelope envelope;
                try {
                    statement = conn.createStatement();
                    results = statement.executeQuery(query);
                    results.next();
                    Geometry geom = null;
                    Object struct = results.getObject(1);
                    UnWrapper unwrapper = DataSourceFinder.getUnWrapper((Connection)conn);
                    OracleConnection oraConn = (OracleConnection)unwrapper.unwrap(conn);
                    GeometryConverter converter = new GeometryConverter(oraConn, new GeometryFactory());
                    geom = converter.asGeometry((STRUCT)struct);
                    if (geom == null) break block4;
                    envelope = geom.getEnvelopeInternal();
                }
                catch (Throwable throwable) {
                    JDBCUtils.close(results);
                    JDBCUtils.close((Statement)statement);
                    throw throwable;
                }
                JDBCUtils.close((ResultSet)results);
                JDBCUtils.close((Statement)statement);
                return envelope;
            }
            JDBCUtils.close((ResultSet)results);
            JDBCUtils.close((Statement)statement);
        }
        return result;
    }
}

