/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.sql.STRUCT;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.jdbc.JDBCTextFeatureWriter;
import org.geotools.data.jdbc.MutableFIDFeature;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.datasource.DataSourceFinder;
import org.geotools.data.jdbc.datasource.UnWrapper;
import org.geotools.data.oracle.sdo.GeometryConverter;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleFeatureWriter
extends JDBCTextFeatureWriter {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.oracle");
    GeometryConverter converter;

    public OracleFeatureWriter(FeatureReader<SimpleFeatureType, SimpleFeature> fReader, QueryData queryData) throws IOException {
        super(fReader, queryData);
        UnWrapper uw;
        Connection conn = queryData.getConnection();
        if (!(conn instanceof OracleConnection) && (uw = DataSourceFinder.getUnWrapper((Connection)conn)) != null) {
            conn = uw.unwrap(conn);
        }
        OracleConnection oracleConnection = (OracleConnection)conn;
        this.converter = new GeometryConverter(oracleConnection);
    }

    protected String getGeometryInsertText(Geometry geom, int srid) throws IOException {
        return "?";
    }

    protected void doUpdate(SimpleFeature live, SimpleFeature current) throws IOException, SQLException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("updating postgis feature " + current);
        }
        Statement statement = null;
        Connection conn = null;
        try {
            conn = this.queryData.getConnection();
            String sql = this.makeUpdateSql(live, current);
            statement = conn.prepareStatement(sql);
            SimpleFeatureType schema = current.getFeatureType();
            int position = 1;
            for (int i = 0; i < current.getAttributeCount(); ++i) {
                AttributeDescriptor type = schema.getDescriptor(i);
                if (!(type instanceof GeometryDescriptor) || DataUtilities.attributesEqual((Object)current.getAttribute(i), (Object)live.getAttribute(i))) continue;
                Geometry geometry = (Geometry)current.getAttribute(i);
                LOGGER.fine("ORACLE SPATIAL: geometry to be written:" + geometry);
                int srid = this.queryData.getFeatureTypeInfo().getSRID(type.getLocalName());
                geometry.setSRID(srid);
                STRUCT struct = this.converter.toSDO(geometry);
                statement.setObject(position, struct);
                LOGGER.fine("ORACLE SPATIAL: set geometry parameter at position:" + position);
                ++position;
                break;
            }
            LOGGER.fine(sql);
            statement.execute();
        }
        catch (SQLException sqle) {
            String msg = "SQL Exception writing geometry column" + sqle.getLocalizedMessage();
            LOGGER.log(Level.SEVERE, msg, sqle);
            this.queryData.close(sqle);
            throw new DataSourceException(msg, (Throwable)sqle);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    String msg = "Error closing JDBC Statement";
                    LOGGER.log(Level.WARNING, msg, e);
                }
            }
        }
    }

    protected void doInsert(MutableFIDFeature current) throws IOException, SQLException {
        LOGGER.fine("inserting into postgis feature " + current);
        Statement statement = null;
        Connection conn = null;
        try {
            conn = this.queryData.getConnection();
            String sql = this.makeInsertSql((SimpleFeature)current);
            statement = conn.prepareStatement(sql);
            int position = 1;
            SimpleFeatureType schema = current.getFeatureType();
            for (int i = 0; i < current.getNumberOfAttributes(); ++i) {
                AttributeDescriptor type = schema.getDescriptor(i);
                if (!(type instanceof GeometryDescriptor)) continue;
                Geometry geometry = (Geometry)current.getAttribute(i);
                int srid = this.queryData.getFeatureTypeInfo().getSRID(type.getLocalName());
                geometry.setSRID(srid);
                STRUCT struct = this.converter.toSDO(geometry);
                statement.setObject(position, struct);
                ++position;
            }
            LOGGER.fine(sql);
            statement.execute();
            if (this.mapper.getColumnCount() > 0 && this.mapper.hasAutoIncrementColumns()) {
                current.setID(this.mapper.createID(conn, (SimpleFeature)current, statement));
            }
        }
        catch (SQLException sqle) {
            String msg = "SQL Exception writing geometry column" + sqle.getLocalizedMessage();
            LOGGER.log(Level.SEVERE, msg, sqle);
            this.queryData.close(sqle);
            throw new DataSourceException(msg, (Throwable)sqle);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    String msg = "Error closing JDBC Statement";
                    LOGGER.log(Level.WARNING, msg, e);
                }
            }
        }
    }
}

