/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.util.List;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.postgis.AbstractPostgisOnlineTestCase;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class PostgisFeatureStoreOnlineTest
extends AbstractPostgisOnlineTestCase {
    public void testWrite() throws Exception {
        PostgisFeatureStoreOnlineTest.assertEquals((String)"tmp_pgtest1.1", (String)this.attemptWrite("tmp_pgtest1"));
        PostgisFeatureStoreOnlineTest.assertEquals((String)"tmp_pgtest1.2", (String)this.attemptWrite("tmp_pgtest1"));
        PostgisFeatureStoreOnlineTest.assertEquals((String)"tmp_pgtest2.1001", (String)this.attemptWrite("tmp_pgtest2"));
        PostgisFeatureStoreOnlineTest.assertEquals((String)"tmp_pgtest2.1002", (String)this.attemptWrite("tmp_pgtest2"));
        PostgisFeatureStoreOnlineTest.assertEquals((String)"tmp_pgtest3.1", (String)this.attemptWrite("tmp_pgtest3"));
        PostgisFeatureStoreOnlineTest.assertEquals((String)"tmp_pgtest3.2", (String)this.attemptWrite("tmp_pgtest3"));
        PostgisFeatureStoreOnlineTest.assertEquals((String)"tmp_pgtest4.1000001", (String)this.attemptWrite("tmp_pgtest4"));
        PostgisFeatureStoreOnlineTest.assertEquals((String)"tmp_pgtest4.1000002", (String)this.attemptWrite("tmp_pgtest4"));
        PostgisFeatureStoreOnlineTest.assertEquals((String)"tmp_pgtest 5.1", (String)this.attemptWrite("tmp_pgtest 5"));
        PostgisFeatureStoreOnlineTest.assertEquals((String)"tmp_pgtest 5.2", (String)this.attemptWrite("tmp_pgtest 5"));
        PostgisFeatureStoreOnlineTest.assertEquals((String)"tmp_pgtest 6.1001", (String)this.attemptWrite("tmp_pgtest 6"));
        PostgisFeatureStoreOnlineTest.assertEquals((String)"tmp_pgtest 6.1002", (String)this.attemptWrite("tmp_pgtest 6"));
    }

    public String attemptWrite(String table) throws Exception {
        DefaultTransaction transaction = new DefaultTransaction("attemptWriteFS");
        FeatureStore fs = (FeatureStore)this.ds.getFeatureSource(table);
        fs.setTransaction((Transaction)transaction);
        SimpleFeatureType ft = (SimpleFeatureType)fs.getSchema();
        FeatureCollection fc = FeatureCollections.newCollection();
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)ft, (Object[])new Object[]{"test"}, null);
        fc.add((Feature)feature);
        List set = fs.addFeatures(fc);
        String id = (String)set.toArray()[0];
        transaction.commit();
        return id;
    }
}

