/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.impl;

import java.awt.RenderingHints;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.geotools.data.Parameter;
import org.geotools.feature.NameImpl;
import org.geotools.process.Process;
import org.geotools.process.ProcessFactory;
import org.opengis.feature.type.Name;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SingleProcessFactory
implements ProcessFactory {
    Name processName;

    protected SingleProcessFactory() {
        String factoryName = this.getClass().getSimpleName();
        String localName = factoryName.endsWith("Factory") && !factoryName.equals("Factory") ? factoryName.substring(0, factoryName.length() - 7) : factoryName;
        this.processName = new NameImpl("gt", localName);
    }

    protected SingleProcessFactory(Name processName) {
        if (processName == null) {
            throw new NullPointerException("Process name cannot be null");
        }
        this.processName = processName;
    }

    void checkName(Name name) {
        if (name == null) {
            throw new NullPointerException("Process name cannot be null");
        }
        if (!this.processName.equals(name)) {
            throw new IllegalArgumentException("Unknown process '" + name + "', this factory knows only about '" + this.processName + "'");
        }
    }

    @Override
    public Process create(Name name) {
        this.checkName(name);
        return this.create();
    }

    @Override
    public Set<Name> getNames() {
        return Collections.singleton(this.processName);
    }

    @Override
    public InternationalString getDescription(Name name) {
        this.checkName(name);
        return this.getDescription();
    }

    @Override
    public Map<String, Parameter<?>> getParameterInfo(Name name) {
        this.checkName(name);
        return this.getParameterInfo();
    }

    @Override
    public Map<String, Parameter<?>> getResultInfo(Name name, Map<String, Object> parameters) throws IllegalArgumentException {
        this.checkName(name);
        return this.getResultInfo(parameters);
    }

    @Override
    public InternationalString getTitle(Name name) {
        this.checkName(name);
        return this.getTitle();
    }

    @Override
    public String getVersion(Name name) {
        this.checkName(name);
        return this.getVersion();
    }

    @Override
    public boolean supportsProgress(Name name) {
        this.checkName(name);
        return this.supportsProgress();
    }

    public boolean isAvailable() {
        return true;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }

    protected abstract Process create();

    protected abstract InternationalString getDescription();

    protected abstract Map<String, Parameter<?>> getParameterInfo();

    protected abstract Map<String, Parameter<?>> getResultInfo(Map<String, Object> var1) throws IllegalArgumentException;

    protected abstract InternationalString getTitle();

    protected abstract String getVersion();

    protected abstract boolean supportsProgress();
}

