/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import java.awt.Dimension;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.Parameter;
import org.geotools.process.feature.AbstractFeatureCollectionProcessFactory;
import org.geotools.process.raster.VectorToRasterProcess;
import org.geotools.text.Text;
import org.opengis.geometry.Envelope;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorToRasterFactory
extends AbstractFeatureCollectionProcessFactory {
    private static final String VERSION = "1.0.0";
    static final Parameter<Dimension> GRID_DIM = new Parameter("dim", Dimension.class, Text.text("Dim"), Text.text("Dimensions of the output grid in cells"), true, 1, 1, null, null);
    static final Parameter<String> TITLE = new Parameter("title", String.class, Text.text("Title"), Text.text("An optional title for the output grid"), false, 1, 1, null, null);
    static final Parameter<String> ATTRIBUTE = new Parameter("attribute", String.class, Text.text("Attribute"), Text.text("The feature attribute to use for raster cell values"), true, 1, 1, null, null);
    static final Parameter<Envelope> BOUNDS = new Parameter("bounds", Envelope.class, Text.text("Bounds"), Text.text("Bounds of the area to rasterize"), false, 1, 1, null, null);
    static final Parameter<GridCoverage2D> RESULT = new Parameter("result", GridCoverage2D.class, Text.text("Result"), Text.text("Rasterized features"));
    static final Map<String, Parameter<?>> resultInfo = new HashMap();

    @Override
    protected void addParameters(Map<String, Parameter<?>> parameters) {
        parameters.put(VectorToRasterFactory.BOUNDS.key, BOUNDS);
    }

    @Override
    public InternationalString getTitle() {
        return Text.text("Rasterize features");
    }

    @Override
    public InternationalString getDescription() {
        return Text.text("Rasterize all or selected features in a FeatureCollection");
    }

    @Override
    public VectorToRasterProcess create() {
        return new VectorToRasterProcess(this);
    }

    @Override
    public Map<String, Parameter<?>> getResultInfo(Map<String, Object> parameters) throws IllegalArgumentException {
        return Collections.unmodifiableMap(resultInfo);
    }

    @Override
    public boolean supportsProgress() {
        return true;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    static {
        resultInfo.put(VectorToRasterFactory.ATTRIBUTE.key, ATTRIBUTE);
        resultInfo.put(VectorToRasterFactory.GRID_DIM.key, GRID_DIM);
        resultInfo.put(VectorToRasterFactory.RESULT.key, RESULT);
    }
}

