/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryFinder;
import org.geotools.factory.FactoryRegistry;
import org.geotools.process.Process;
import org.geotools.process.ProcessExecutor;
import org.geotools.process.ProcessFactory;
import org.geotools.process.ThreadPoolProcessExecutor;
import org.geotools.resources.LazySet;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.type.Name;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Processors
extends FactoryFinder {
    private static FactoryRegistry registry;

    private Processors() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FactoryRegistry getServiceRegistry() {
        Class<Processors> clazz = Processors.class;
        synchronized (Processors.class) {
            if (registry == null) {
                registry = new FactoryCreator(Arrays.asList(ProcessFactory.class));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return registry;
        }
    }

    public static Set<ProcessFactory> getProcessFactories() {
        return new LazySet(Processors.getServiceRegistry().getServiceProviders(ProcessFactory.class, null, null));
    }

    public static synchronized ProcessFactory createProcessFactory(Name name) {
        for (ProcessFactory factory : Processors.getProcessFactories()) {
            if (!factory.getNames().contains(name)) continue;
            return factory;
        }
        return null;
    }

    public static synchronized Process createProcess(Name name) {
        ProcessFactory factory = Processors.createProcessFactory(name);
        if (factory == null) {
            return null;
        }
        return factory.create(name);
    }

    public static Callable<Map<String, Object>> createCallable(final Process process, final Map<String, Object> input) {
        return new Callable<Map<String, Object>>(){

            @Override
            public Map<String, Object> call() throws Exception {
                return process.execute(input, (ProgressListener)new CallableProgressListener());
            }
        };
    }

    public static ProcessExecutor newProcessExecutor(int nThreads, ThreadFactory threadFactory) {
        if (threadFactory == null) {
            threadFactory = Executors.defaultThreadFactory();
        }
        return new ThreadPoolProcessExecutor(nThreads, threadFactory);
    }

    static class CallableProgressListener
    extends NullProgressListener {
        CallableProgressListener() {
        }

        public boolean isCanceled() {
            return Thread.currentThread().isInterrupted();
        }
    }
}

