/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.impl;

import java.awt.RenderingHints;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.Parameter;
import org.geotools.process.Process;
import org.geotools.process.ProcessFactory;
import org.geotools.process.impl.SimpleProcess;
import org.geotools.text.Text;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanProcessFactory
implements ProcessFactory {
    public Process create() {
        return new SimpleProcess(this){

            public void process() throws Exception {
                BeanProcessFactory.this.process(this.input, this.result);
            }
        };
    }

    public InternationalString getDescription() {
        return null;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public Map<String, Parameter<?>> getParameterInfo() {
        BeanInfo info;
        try {
            info = Introspector.getBeanInfo(this.getInputBean());
        }
        catch (IntrospectionException e) {
            return null;
        }
        HashMap parameterInfo = new HashMap();
        for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
            Method getter = descriptor.getReadMethod();
            if (getter == null) continue;
            Parameter parameter = new Parameter(descriptor.getName(), descriptor.getPropertyType(), Text.text(descriptor.getDisplayName()), Text.text(descriptor.getShortDescription()));
            parameterInfo.put(descriptor.getName(), parameter);
        }
        return parameterInfo;
    }

    public Map<String, Parameter<?>> getResultInfo() {
        BeanInfo info;
        try {
            info = Introspector.getBeanInfo(this.getResultBean());
        }
        catch (IntrospectionException e) {
            return null;
        }
        HashMap parameterInfo = new HashMap();
        for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
            Method setter = descriptor.getWriteMethod();
            if (setter == null) continue;
            Parameter parameter = new Parameter(descriptor.getName(), descriptor.getPropertyType(), Text.text(descriptor.getDisplayName()), Text.text(descriptor.getShortDescription()));
            parameterInfo.put(descriptor.getName(), parameter);
        }
        return parameterInfo;
    }

    public Map<String, Parameter<?>> getResultInfo(Map<String, Object> parameters) throws IllegalArgumentException {
        return null;
    }

    public InternationalString getTitle() {
        return Text.text(this.getClass().getSimpleName());
    }

    protected void process(Map<String, Object> inputMap, Map<String, Object> resultMap) throws Exception {
        BeanInfo inputInfo = Introspector.getBeanInfo(this.getInputBean());
        Constructor<?> inputBean = inputInfo.getBeanDescriptor().getBeanClass().getConstructor(new Class[0]);
        this.configure(inputInfo, inputMap, inputBean);
        Object resultBean = this.process(inputBean);
        BeanInfo resultInfo = Introspector.getBeanInfo(this.getResultBean(), Object.class);
        this.results(resultMap, resultBean, resultInfo);
    }

    private void results(Map<String, Object> resultMap, Object bean, BeanInfo info) {
        for (PropertyDescriptor property : info.getPropertyDescriptors()) {
            if (!resultMap.containsKey(property.getName())) continue;
            Method setter = property.getReadMethod();
            try {
                Object value = setter.invoke(bean, new Object[0]);
                resultMap.put(property.getName(), value);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void configure(BeanInfo info, Map<String, Object> inputMap, Object bean) {
        for (PropertyDescriptor property : info.getPropertyDescriptors()) {
            if (!inputMap.containsKey(property.getName())) continue;
            Method setter = property.getWriteMethod();
            try {
                setter.invoke(bean, inputMap.get(property.getName()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public boolean isAvailable() {
        return true;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }

    protected abstract Class<?> getInputBean();

    protected abstract Class<?> getResultBean();

    protected abstract Object process(Object var1);
}

