/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.literal;

import com.vividsolutions.jts.geom.Geometry;
import java.util.HashMap;
import java.util.Map;
import org.geotools.process.ProcessFactory;
import org.geotools.process.impl.AbstractProcess;
import org.geotools.process.literal.BufferFactory;
import org.geotools.text.Text;
import org.geotools.util.NullProgressListener;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BufferProcess
extends AbstractProcess {
    private boolean started = false;

    public BufferProcess(BufferFactory bufferFactory) {
        super(bufferFactory);
    }

    public ProcessFactory getFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> execute(Map<String, Object> input, ProgressListener monitor) {
        if (this.started) {
            throw new IllegalStateException("Process can only be run once");
        }
        this.started = true;
        if (monitor == null) {
            monitor = new NullProgressListener();
        }
        try {
            monitor.started();
            monitor.setTask(Text.text("Grabbing arguments"));
            monitor.progress(10.0f);
            Geometry geom1 = (Geometry)input.get(BufferFactory.GEOM1.key);
            Double buffer = (Double)input.get(BufferFactory.BUFFER.key);
            monitor.setTask(Text.text("Processing Buffer"));
            monitor.progress(25.0f);
            if (monitor.isCanceled()) {
                Map<String, Object> map = null;
                return map;
            }
            Geometry resultGeom = geom1.buffer(buffer.doubleValue());
            monitor.setTask(Text.text("Encoding result"));
            monitor.progress(90.0f);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put(BufferFactory.RESULT.key, resultGeom);
            monitor.complete();
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (Exception eek) {
            monitor.exceptionOccurred((Throwable)eek);
            Map<String, Object> map = null;
            return map;
        }
        finally {
            monitor.dispose();
        }
    }
}

