/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.RenderingHints;
import java.io.File;
import org.geotools.data.FeatureSource;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.test.TestData;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeometryTransformationTest {
    private static final long TIME = 2000L;
    SimpleFeatureSource fs;
    SimpleFeatureSource bfs;
    ReferencedEnvelope bounds;
    ReferencedEnvelope bbounds;

    @Before
    public void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"line.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.fs = ds.getFeatureSource("line");
        this.bounds = this.fs.getBounds();
        this.bounds.expandBy(3.0, 3.0);
        this.bfs = ds.getFeatureSource("buildings");
        this.bbounds = this.bfs.getBounds();
        this.bbounds.expandBy(3.0, 3.0);
    }

    @Test
    public void testBufferLine() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "lineBuffer.sld");
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((FeatureSource)this.fs, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)mc);
        RendererBaseTest.showRender("lineBuffer.sld", (GTRenderer)renderer, 2000L, this.bounds);
    }

    @Test
    public void testBufferPoly() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "polyBuffer.sld");
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((FeatureSource)this.bfs, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)mc);
        RendererBaseTest.showRender("polyBuffer.sld", (GTRenderer)renderer, 2000L, this.bounds);
    }

    @Test
    public void testVertices() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "lineVertices.sld");
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((FeatureSource)this.fs, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)mc);
        RendererBaseTest.showRender("lineVertices.sld", (GTRenderer)renderer, 2000L, this.bounds);
    }

    @Test
    public void testStartEnd() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "lineStartEnd.sld");
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((FeatureSource)this.fs, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)mc);
        RendererBaseTest.showRender("lineStartEnd.sld", (GTRenderer)renderer, 2000L, this.bounds);
    }

    @Test
    public void testIsometric() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "isometric.sld");
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((FeatureSource)this.bfs, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        RendererBaseTest.showRender("lineStartEnd.sld", (GTRenderer)renderer, 2000L, this.bbounds);
    }
}

