/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Color;
import java.awt.Font;
import java.awt.RenderingHints;
import java.io.File;
import org.geotools.data.FeatureSource;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.style.FontCache;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.SLD;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.geotools.test.TestData;
import org.junit.Before;
import org.junit.Test;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FillTest {
    private static final long TIME = 4000L;
    SimpleFeatureSource fs;
    SimpleFeatureSource bfs;
    ReferencedEnvelope bounds;

    @Before
    public void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)this, (String)"square.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.fs = ds.getFeatureSource("square");
        this.bfs = ds.getFeatureSource("bigsquare");
        this.bounds = this.fs.getBounds();
        this.bounds.expandBy(0.2, 0.2);
        Font f = Font.createFont(0, TestData.getResource((Object)this, (String)"recreate.ttf").openStream());
        FontCache.getDefaultInstance().registerFont(f);
    }

    @Test
    public void testSolidFill() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "fillSolid.sld");
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((FeatureSource)this.fs, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)mc);
        RendererBaseTest.showRender("SolidFill", (GTRenderer)renderer, 4000L, this.bounds);
    }

    @Test
    public void testCrossFill() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "fillCross.sld");
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((FeatureSource)this.fs, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        RendererBaseTest.showRender("CrossFill", (GTRenderer)renderer, 4000L, this.bounds);
    }

    @Test
    public void testTriangleFill() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "fillTriangle.sld");
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((FeatureSource)this.fs, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        RendererBaseTest.showRender("TriangleFill", (GTRenderer)renderer, 4000L, this.bounds);
    }

    @Test
    public void testCircleFill() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "fillCircle.sld");
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((FeatureSource)this.fs, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        RendererBaseTest.showRender("CircleFill", (GTRenderer)renderer, 4000L, this.bounds);
    }

    @Test
    public void testSlash() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "fillSlash.sld");
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((FeatureSource)this.fs, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        RendererBaseTest.showRender("SlashFill", (GTRenderer)renderer, 4000L, this.bounds);
    }

    @Test
    public void testImageFill() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "fillImage.sld");
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((FeatureSource)this.fs, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)mc);
        RendererBaseTest.showRender("ImageFill", (GTRenderer)renderer, 4000L, this.bounds);
    }

    @Test
    public void testFontFill() throws Exception {
        Style style = RendererBaseTest.loadStyle(this, "fillTTFDecorative.sld");
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((FeatureSource)this.fs, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        RendererBaseTest.showRender("TTF decorative", (GTRenderer)renderer, 4000L, this.bounds);
    }

    @Test
    public void testFTSComposition() throws Exception {
        Style bgStyle = RendererBaseTest.loadStyle(this, "fillSolid.sld");
        Style fgStyle = RendererBaseTest.loadStyle(this, "fillSolidFTS.sld");
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((FeatureSource)this.bfs, bgStyle);
        mc.addLayer((FeatureSource)this.fs, fgStyle);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        renderer.setContext((MapContext)mc);
        RendererBaseTest.showRender("FTS composition", (GTRenderer)renderer, 4000L, this.bounds);
    }

    @Test
    public void testGEOT3111() throws Exception {
        FilterFactory2 ff2 = CommonFactoryFinder.getFilterFactory2(null);
        StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
        PolygonSymbolizer sym = sf.createPolygonSymbolizer(Stroke.NULL, sf.createFill((Expression)ff2.literal((Object)Color.CYAN)), null);
        Style style = SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{sym});
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((FeatureSource)this.fs, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        RendererBaseTest.showRender("TTF decorative", (GTRenderer)renderer, 4000L, this.bounds);
    }
}

