/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTReader;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.BandCombineDescriptor;
import javax.media.jai.operator.BinarizeDescriptor;
import javax.media.jai.operator.ExtremaDescriptor;
import javax.media.jai.operator.OrDescriptor;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class LabelObstacleTest {
    static MemoryDataStore mem;

    @BeforeClass
    public static void setUpData() throws Exception {
        mem = new MemoryDataStore();
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("roads");
        tb.setSRS("epsg:4326");
        tb.add("geom", LineString.class);
        tb.add("name", String.class);
        mem.createSchema(tb.buildFeatureType());
        tb.setName("points");
        tb.add("geom", Point.class);
        mem.createSchema(tb.buildFeatureType());
        tb.setName("lines");
        tb.add("geom", LineString.class);
        mem.createSchema(tb.buildFeatureType());
        tb.setName("polys");
        tb.add("geom", Polygon.class);
        mem.createSchema(tb.buildFeatureType());
        tb.setName("lines2");
        tb.add("geom", MultiLineString.class);
        tb.add("name", String.class);
        mem.createSchema(tb.buildFeatureType());
        LabelObstacleTest.loadData(mem, "roads");
        LabelObstacleTest.loadData(mem, "points");
        LabelObstacleTest.loadData(mem, "lines");
        LabelObstacleTest.loadData(mem, "polys");
        LabelObstacleTest.loadData(mem, "lines2");
    }

    static void loadData(MemoryDataStore mem, String name) throws Exception {
        WKTReader wkt = new WKTReader();
        FeatureWriter w = mem.getFeatureWriter(name, Transaction.AUTO_COMMIT);
        BufferedReader r = new BufferedReader(new InputStreamReader(LabelObstacleTest.class.getResourceAsStream("test-data/obstacles/" + name + ".txt")));
        String line = null;
        while ((line = r.readLine()) != null) {
            String[] values = line.split(";");
            SimpleFeature f = (SimpleFeature)w.next();
            for (int i = 0; i < f.getAttributeCount(); ++i) {
                AttributeDescriptor ad = f.getType().getDescriptor(i);
                if (ad instanceof GeometryDescriptor) {
                    f.setAttribute(i, (Object)wkt.read(values[i]));
                    continue;
                }
                f.setAttribute(i, (Object)values[i]);
            }
            w.write();
        }
        r.close();
    }

    Style style(String name) throws Exception {
        SLDParser p = new SLDParser(CommonFactoryFinder.getStyleFactory(null), this.getClass().getResourceAsStream("test-data/obstacles/" + name + ".sld"));
        return p.readXML()[0];
    }

    Style[] styles(String ... names) throws Exception {
        ArrayList<Style> styles = new ArrayList<Style>();
        for (String name : names) {
            styles.add(name != null ? this.style(name) : null);
        }
        return styles.toArray(new Style[styles.size()]);
    }

    FeatureSource[] sources(String ... names) throws Exception {
        ArrayList<SimpleFeatureSource> sources = new ArrayList<SimpleFeatureSource>();
        for (String name : names) {
            sources.add(mem.getFeatureSource(name));
        }
        return sources.toArray(new FeatureSource[sources.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BufferedImage render(FeatureSource[] sources, Style[] styles) throws Exception {
        int i;
        DefaultMapContext map = new DefaultMapContext();
        ReferencedEnvelope env = sources[0].getBounds();
        for (i = 1; i < sources.length; ++i) {
            env.expandToInclude((Envelope)sources[i].getBounds());
        }
        map.setAreaOfInterest(env);
        map.setCoordinateReferenceSystem(env.getCoordinateReferenceSystem());
        for (i = 0; i < sources.length; ++i) {
            if (styles[i] == null) continue;
            map.addLayer(sources[i], styles[i]);
        }
        try {
            StreamingRenderer r = new StreamingRenderer();
            r.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            r.setContext((MapContext)map);
            BufferedImage bufferedImage = RendererBaseTest.showRender("testPointLabeling", (GTRenderer)r, 5000L, env);
            return bufferedImage;
        }
        finally {
            map.dispose();
        }
    }

    File file(String name) {
        return new File("src/test/resources/org/geotools/renderer/lite/test-data/obstacles/" + name + ".png");
    }

    @Test
    public void testExternalGraphicNoObstacle() throws Exception {
        BufferedImage labels = this.render(this.sources("roads", "points"), this.styles("label", "grinNoObstacle"));
        BufferedImage points = this.render(this.sources("roads", "points"), this.styles(null, "grinNoObstacle"));
        RenderedImage extrema = this.intersectionExtrema(labels, points);
        double[] minimum = (double[])extrema.getProperty("minimum");
        Assert.assertEquals((double)0.0, (double)minimum[0], (double)0.0);
    }

    @Test
    public void testExternalGraphic() throws Exception {
        BufferedImage labels = this.render(this.sources("roads", "points"), this.styles("label", "grin"));
        BufferedImage points = this.render(this.sources("roads", "points"), this.styles(null, "grin"));
        this.checkNoIntersection(labels, points);
    }

    @Test
    public void testMark() throws Exception {
        BufferedImage labels = this.render(this.sources("roads", "points"), this.styles("label", "mark"));
        BufferedImage marks = this.render(this.sources("roads", "points"), this.styles(null, "mark"));
        this.checkNoIntersection(labels, marks);
    }

    @Test
    public void testPolygon() throws Exception {
        BufferedImage labels = this.render(this.sources("roads", "polys"), this.styles("label", "poly"));
        BufferedImage polys = this.render(this.sources("roads", "polys"), this.styles(null, "poly"));
        this.checkNoIntersection(labels, polys);
    }

    @Test
    public void testLine() throws Exception {
        BufferedImage labels = this.render(this.sources("roads", "lines"), this.styles("label", "line"));
        BufferedImage roads = this.render(this.sources("roads", "lines"), this.styles(null, "line"));
        this.checkNoIntersection(labels, roads);
    }

    @Test
    public void testLineWithGraphicStroke() throws Exception {
        BufferedImage img = this.render(this.sources("lines2"), this.styles("hatch"));
        ImageAssert.assertEquals((File)this.file("hatch"), (RenderedImage)img, (int)10);
    }

    private void checkNoIntersection(BufferedImage labels, BufferedImage obstacle) {
        RenderedImage extrema = this.intersectionExtrema(labels, obstacle);
        double[] minimum = (double[])extrema.getProperty("minimum");
        Assert.assertEquals((double)1.0, (double)minimum[0], (double)0.0);
    }

    RenderedImage intersectionExtrema(BufferedImage labels, BufferedImage obstacles) {
        RenderedOp labelsCombine = BandCombineDescriptor.create((RenderedImage)labels, (double[][])new double[][]{{0.3333333333333333, 0.3333333333333333, 0.3333333333333333, 0.0, 0.0}}, null);
        RenderedOp pointsCombine = BandCombineDescriptor.create((RenderedImage)obstacles, (double[][])new double[][]{{0.3333333333333333, 0.3333333333333333, 0.3333333333333333, 0.0, 0.0}}, null);
        RenderedOp binaryLabel = BinarizeDescriptor.create((RenderedImage)labelsCombine, (Double)1.0, null);
        RenderedOp binaryObstacles = BinarizeDescriptor.create((RenderedImage)pointsCombine, (Double)250.0, null);
        RenderedOp and = OrDescriptor.create((RenderedImage)binaryObstacles, (RenderedImage)binaryLabel, null);
        RenderedOp extrema = ExtremaDescriptor.create((RenderedImage)and, null, (Integer)1, (Integer)1, (Boolean)false, (Integer)1, null);
        return extrema;
    }
}

