/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import junit.framework.TestCase;
import org.geotools.data.FeatureSource;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.test.TestData;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class LineTest
extends TestCase {
    private static final long TIME = 4000L;
    SimpleFeatureSource fs;
    ReferencedEnvelope bounds;

    protected void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)((Object)this), (String)"line.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.fs = ds.getFeatureSource("line");
        this.bounds = new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    File file(String name) {
        return new File("src/test/resources/org/geotools/renderer/lite/test-data/line/" + name + ".png");
    }

    public void testLineCircle() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "lineCircle.sld");
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((FeatureSource)this.fs, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = RendererBaseTest.showRender("Lines with circl stroke", (GTRenderer)renderer, 4000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("circle"), (RenderedImage)image, (int)10);
    }

    public void testLineRailway() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "lineRailway.sld");
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((FeatureSource)this.fs, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = RendererBaseTest.showRender("Lines with circl stroke", (GTRenderer)renderer, 4000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("railway"), (RenderedImage)image, (int)10);
    }

    public void testDotsStars() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "dotsStars.sld");
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer((FeatureSource)this.fs, style);
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext((MapContext)mc);
        renderer.setJava2DHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        BufferedImage image = RendererBaseTest.showRender("Lines with circl stroke", (GTRenderer)renderer, 4000L, this.bounds);
        ImageAssert.assertEquals((File)this.file("dotstar"), (RenderedImage)image, (int)10);
    }
}

