/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.style;

import java.net.URL;
import javax.swing.Icon;
import junit.framework.TestCase;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.style.ImageGraphicFactory;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class ImageGraphicFactoryTest
extends TestCase {
    private ImageGraphicFactory image;
    private FilterFactory ff;

    protected void setUp() throws Exception {
        this.image = new ImageGraphicFactory();
        this.ff = CommonFactoryFinder.getFilterFactory(null);
    }

    public void testFormats() throws Exception {
        ImageGraphicFactoryTest.assertTrue((boolean)this.image.getSupportedMimeTypes().contains("image/png"));
        ImageGraphicFactoryTest.assertTrue((boolean)this.image.getSupportedMimeTypes().contains("image/jpeg"));
    }

    public void testInvalidPaths() throws Exception {
        ImageGraphicFactoryTest.assertNull((Object)this.image.getIcon(null, (Expression)this.ff.literal((Object)"http://www.nowhere.com"), "image/not!", 20));
        try {
            this.image.getIcon(null, (Expression)this.ff.literal((Object)"ThisIsNotAUrl"), "image/png", 20);
            ImageGraphicFactoryTest.fail((String)"Should have throw an exception, invalid url");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testLocalURL() throws Exception {
        URL url = StreamingRenderer.class.getResource("test-data/draw.png");
        ImageGraphicFactoryTest.assertNotNull((Object)url);
        Icon icon = this.image.getIcon(null, (Expression)this.ff.literal((Object)url), "image/png", 80);
        ImageGraphicFactoryTest.assertNotNull((Object)icon);
        ImageGraphicFactoryTest.assertEquals((int)80, (int)icon.getIconHeight());
    }

    public void testNaturalSize() throws Exception {
        URL url = StreamingRenderer.class.getResource("test-data/draw.png");
        ImageGraphicFactoryTest.assertNotNull((Object)url);
        Icon icon = this.image.getIcon(null, (Expression)this.ff.literal((Object)url), "image/png", -1);
        ImageGraphicFactoryTest.assertNotNull((Object)icon);
        ImageGraphicFactoryTest.assertEquals((int)22, (int)icon.getIconHeight());
    }
}

