/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 * 
 *    (C) 2004-2008, Open Source Geospatial Foundation (OSGeo)
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */
package org.geotools.renderer.lite;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.List;

import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Graphic;

/**
 *
 * @author  jamesm
 * @source $URL: http://svn.osgeo.org/geotools/tags/2.6.0/modules/library/render/src/main/java/org/geotools/renderer/lite/GlyphRenderer.java $
 */
public interface GlyphRenderer {
 
    public boolean canRender(String format);
    public List getFormats();
    /**
     * 
     * @param graphic
     * @param eg
     * @param feature
     * @param height use <=0 if you dont want any scaling done.  THIS MIGHT BE IGNORED by the renderer!
     */
    public BufferedImage render(Graphic graphic, ExternalGraphic eg, Object feature, int height);
    
    /**
     * Method for rendering the glyph directly onto a specified Graphics. 
     * @param g the Graphics on which to render.
     * @param graphic a Graphic to be rendered.
     * @param eg an ExternalGraphic to rendered.
     * @param feature a Feature to be rendered.
     * @param height the height of the glyph to be rendered. 
     */
    public void render(Graphics2D g, Graphic graphic, ExternalGraphic eg, Object feature, int height, float centerX, float centerY);
}
