/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.io.File;
import java.lang.constant.Constable;
import java.util.HashMap;
import junit.framework.TestCase;
import org.geotools.data.FeatureSource;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.RendererBaseTest;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.test.TestData;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class QueryOptimizeTest
extends TestCase {
    private static final long TIME = 2000L;
    FeatureSource<SimpleFeatureType, SimpleFeature> squareFS;
    ReferencedEnvelope bounds;
    StreamingRenderer renderer;
    DefaultMapContext context;
    int count = 0;

    protected void setUp() throws Exception {
        File property = new File(TestData.getResource((Object)((Object)this), (String)"square.properties").toURI());
        PropertyDataStore ds = new PropertyDataStore(property.getParentFile());
        this.squareFS = ds.getFeatureSource("square");
        this.bounds = new ReferencedEnvelope(0.0, 10.0, 0.0, 10.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.renderer = new StreamingRenderer();
        this.context = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        this.renderer.setContext((MapContext)this.context);
        HashMap<String, Constable> hints = new HashMap<String, Constable>();
        hints.put("maxFiltersToSendToDatastore", Integer.valueOf(2));
        hints.put("optimizedDataLoadingEnabled", Boolean.valueOf(true));
        this.renderer.setRendererHints(hints);
    }

    public void testLessFilters() throws Exception {
        Style style = RendererBaseTest.loadStyle((Object)this, "fillSolidTwoRules.sld");
        DefaultMapContext mc = new DefaultMapContext((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        mc.addLayer(this.squareFS, style);
        this.renderer.setContext((MapContext)mc);
        this.renderer.addRenderListener(new RenderListener(){

            public void featureRenderer(SimpleFeature feature) {
                ++QueryOptimizeTest.this.count;
            }

            public void errorOccurred(Exception e) {
            }
        });
        RendererBaseTest.showRender("OneSquare", this.renderer, 2000L, this.bounds);
        QueryOptimizeTest.assertEquals((int)2, (int)this.count);
    }
}

