/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sfs;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.geotools.data.Query;
import org.geotools.data.sfs.SFSFilterVisitor;
import org.geotools.factory.Hints;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.sort.SortOrder;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;

class SFSDataStoreUtil {
    static final String DEFAULT_ENCODING = "UTF-8";

    SFSDataStoreUtil() {
    }

    public static void flipFeatureYX(Geometry fnG) {
        fnG.apply(new CoordinateSequenceFilter(){

            public boolean isGeometryChanged() {
                return true;
            }

            public boolean isDone() {
                return false;
            }

            public void filter(CoordinateSequence seq, int i) {
                double x = seq.getX(i);
                double y = seq.getY(i);
                seq.setOrdinate(i, 0, y);
                seq.setOrdinate(i, 1, x);
            }
        });
    }

    public static void flipYXInsideTheBoundingBox(ArrayList fnAL) {
        double ymin = Double.parseDouble(fnAL.get(0).toString());
        double xmin = Double.parseDouble(fnAL.get(1).toString());
        double ymax = Double.parseDouble(fnAL.get(2).toString());
        double xmax = Double.parseDouble(fnAL.get(3).toString());
        fnAL.clear();
        fnAL.add(0, xmin);
        fnAL.add(1, ymin);
        fnAL.add(2, xmax);
        fnAL.add(3, ymax);
    }

    public static String encodeQuery(Query fnQuery, SimpleFeatureType targetType) throws UnsupportedEncodingException {
        boolean firstChar = false;
        StringBuilder urlBuilder = new StringBuilder();
        if (!fnQuery.isMaxFeaturesUnlimited()) {
            urlBuilder.append(SFSDataStoreUtil.getGlueChar(firstChar));
            firstChar = false;
            urlBuilder.append("limit=");
            urlBuilder.append(fnQuery.getMaxFeatures());
        }
        boolean no_geom = true;
        if (!fnQuery.retrieveAllProperties() && fnQuery.getPropertyNames().length > 0) {
            urlBuilder.append(SFSDataStoreUtil.getGlueChar(firstChar));
            firstChar = false;
            urlBuilder.append("attrs=");
            for (int i = 0; i < fnQuery.getPropertyNames().length; ++i) {
                if (targetType.getDescriptor(fnQuery.getPropertyNames()[i]) instanceof GeometryDescriptor) {
                    no_geom = false;
                }
                urlBuilder.append(URLEncoder.encode(fnQuery.getPropertyNames()[i], DEFAULT_ENCODING));
                if (i >= fnQuery.getPropertyNames().length - 1) continue;
                urlBuilder.append(",");
            }
            if (no_geom) {
                urlBuilder.append(SFSDataStoreUtil.getGlueChar(firstChar));
                urlBuilder.append("no_geom=");
                urlBuilder.append(no_geom);
            }
        }
        if (fnQuery.getStartIndex() != null) {
            urlBuilder.append(SFSDataStoreUtil.getGlueChar(firstChar));
            firstChar = false;
            urlBuilder.append("offset=");
            urlBuilder.append(fnQuery.getStartIndex());
        }
        if (fnQuery.getSortBy() != null && fnQuery.getSortBy().length > 0) {
            urlBuilder.append(SFSDataStoreUtil.getGlueChar(firstChar));
            firstChar = false;
            urlBuilder.append("order_by=");
            urlBuilder.append(URLEncoder.encode(fnQuery.getSortBy()[0].getPropertyName().getPropertyName(), DEFAULT_ENCODING));
            urlBuilder.append(SFSDataStoreUtil.getGlueChar(firstChar));
            urlBuilder.append("dir=");
            SortOrder order = fnQuery.getSortBy()[0].getSortOrder();
            urlBuilder.append(URLEncoder.encode(order.name(), DEFAULT_ENCODING));
        }
        if (fnQuery.getFilter() != null) {
            SFSFilterVisitor visitor = new SFSFilterVisitor(false);
            fnQuery.getFilter().accept((FilterVisitor)visitor, null);
            visitor.finish(urlBuilder, !firstChar);
            firstChar = false;
        }
        if (fnQuery.getHints() != null && fnQuery.getHints().get((Object)Hints.VIRTUAL_TABLE_PARAMETERS) != null) {
            Map params = (Map)fnQuery.getHints().get((Object)Hints.VIRTUAL_TABLE_PARAMETERS);
            urlBuilder.append(SFSDataStoreUtil.getGlueChar(firstChar));
            firstChar = false;
            urlBuilder.append("hints=");
            Iterator it = params.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry pair = it.next();
                urlBuilder.append(URLEncoder.encode(((String)pair.getKey()).toString(), DEFAULT_ENCODING));
                urlBuilder.append(":");
                urlBuilder.append(URLEncoder.encode(((String)pair.getValue()).toString(), DEFAULT_ENCODING));
                if (!it.hasNext()) continue;
                urlBuilder.append(";");
            }
        }
        if (urlBuilder.length() > 1) {
            return urlBuilder.substring(1).toString();
        }
        return "";
    }

    private static String getGlueChar(boolean fcFlag) {
        if (fcFlag) {
            return "";
        }
        return "&";
    }

    public static String strip(String json) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < json.length(); ++i) {
            char c = json.charAt(i);
            if (c == ' ' || c == '\n') continue;
            if (c == '\'') {
                sb.append("\"");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static Class getClass(String strObj) {
        if (strObj == null) {
            return String.class;
        }
        if (strObj.equalsIgnoreCase("String")) {
            return String.class;
        }
        if (strObj.equalsIgnoreCase("int")) {
            return Integer.class;
        }
        if (strObj.equalsIgnoreCase("double")) {
            return Double.class;
        }
        if (strObj.equalsIgnoreCase("boolean")) {
            return Boolean.class;
        }
        if (strObj.equalsIgnoreCase("geometry")) {
            return Geometry.class;
        }
        if (strObj.equalsIgnoreCase("point")) {
            return Point.class;
        }
        if (strObj.equalsIgnoreCase("multipoint")) {
            return MultiPoint.class;
        }
        if (strObj.equalsIgnoreCase("linestring")) {
            return LineString.class;
        }
        if (strObj.equalsIgnoreCase("multilinestring")) {
            return MultiLineString.class;
        }
        if (strObj.equalsIgnoreCase("polygon")) {
            return Polygon.class;
        }
        if (strObj.equalsIgnoreCase("multipolygon")) {
            return MultiPolygon.class;
        }
        if (strObj.equalsIgnoreCase("geometrycollection")) {
            return GeometryCollection.class;
        }
        if (strObj.equalsIgnoreCase("timestamp")) {
            return Date.class;
        }
        if (strObj.equalsIgnoreCase("number")) {
            return Double.class;
        }
        return String.class;
    }

    public static CoordinateReferenceSystem decodeXY(String srsName) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateReferenceSystem crs = CRS.decode((String)srsName, (boolean)true);
        if (!SFSDataStoreUtil.isXYOriented(crs)) {
            return CRS.decode((String)("EPSG:" + CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false)), (boolean)true);
        }
        return crs;
    }

    static boolean isXYOriented(CoordinateReferenceSystem crs) {
        CoordinateSystem cs = null;
        if (crs instanceof ProjectedCRS) {
            ProjectedCRS pcrs = (ProjectedCRS)crs;
            cs = pcrs.getBaseCRS().getCoordinateSystem();
        } else if (crs instanceof GeographicCRS) {
            cs = crs.getCoordinateSystem();
        } else {
            return true;
        }
        int dimension = cs.getDimension();
        int longitudeDim = -1;
        int latitudeDim = -1;
        for (int i = 0; i < dimension; ++i) {
            AxisDirection dir = cs.getAxis(i).getDirection().absolute();
            if (dir.equals((Object)AxisDirection.EAST)) {
                longitudeDim = i;
            }
            if (!dir.equals((Object)AxisDirection.NORTH)) continue;
            latitudeDim = i;
        }
        if (longitudeDim >= 0 && latitudeDim >= 0) {
            return longitudeDim < latitudeDim;
        }
        return false;
    }
}

