/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.shape;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.geotools.renderer.shape.SimpleGeometry;

public abstract class AbstractShape
implements Shape {
    protected SimpleGeometry geom;

    public AbstractShape(SimpleGeometry geom) {
        this.geom = geom;
    }

    public Rectangle getBounds() {
        return new Rectangle((int)this.geom.bbox.getMinX(), (int)this.geom.bbox.getMinY(), (int)this.geom.bbox.getWidth(), (int)this.geom.bbox.getHeight());
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.geom.bbox.getMinX(), this.geom.bbox.getMinY(), this.geom.bbox.getWidth(), this.geom.bbox.getHeight());
    }

    public boolean contains(double x, double y) {
        return this.geom.bbox.contains(x, y);
    }

    public boolean contains(Point2D p) {
        return this.geom.bbox.contains(p.getX(), p.getY());
    }

    public boolean intersects(double x, double y, double w, double h) {
        return this.geom.bbox.intersects(new Envelope(x, x + w, y, y + h));
    }

    public boolean intersects(Rectangle2D r) {
        return this.geom.bbox.intersects(new Envelope(r.getMinX(), r.getMaxX(), r.getMinY(), r.getMaxY()));
    }

    public boolean contains(double x, double y, double w, double h) {
        return this.geom.bbox.contains(new Envelope(x, x + w, y, y + h));
    }

    public boolean contains(Rectangle2D r) {
        return this.geom.bbox.contains(new Envelope(r.getMinX(), r.getMaxX(), r.getMinY(), r.getMaxY()));
    }
}

