/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.indexed;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.logging.Logger;
import org.geotools.data.shapefile.FileWriter;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.StorageFile;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.data.shapefile.shp.ShapefileHeader;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.index.LockTimeoutException;
import org.geotools.index.TreeException;
import org.geotools.index.quadtree.QuadTree;
import org.geotools.index.quadtree.StoreException;
import org.geotools.index.quadtree.fs.FileSystemIndexStore;
import org.geotools.util.NullProgressListener;
import org.geotools.util.logging.Logging;
import org.opengis.util.ProgressListener;

public class ShapeFileIndexer
implements FileWriter {
    private static final Logger LOGGER = Logging.getLogger(ShapeFileIndexer.class);
    private int max = -1;
    private String byteOrder;
    private boolean interactive = false;
    private ShpFiles shpFiles;

    public static void main(String[] args) throws IOException {
        if (args.length < 1 || (args.length - 1) % 2 != 0) {
            ShapeFileIndexer.usage();
        }
        long start = System.currentTimeMillis();
        ShapeFileIndexer idx = new ShapeFileIndexer();
        idx.interactive = true;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-t")) {
                ++i;
                continue;
            }
            if (args[i].equals("-M")) {
                idx.setMax(Integer.parseInt(args[++i]));
                continue;
            }
            if (args[i].equals("-b")) {
                idx.setByteOrder(args[++i]);
                continue;
            }
            if (!args[i].toLowerCase().endsWith(".shp")) {
                System.out.println("File extension must be '.shp'");
                System.exit(1);
            }
            idx.setShapeFileName(new ShpFiles(args[i]));
        }
        try {
            System.out.print("Indexing ");
            int cnt = idx.index(true, (ProgressListener)new NullProgressListener());
            System.out.println();
            System.out.print(cnt + " features indexed ");
            System.out.println("in " + (System.currentTimeMillis() - start) + "ms.");
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
            ShapeFileIndexer.usage();
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.println("Usage: ShapeFileIndexer -t <QIX> [-M <max entries per node>] [-s <split algorithm>] [-b <byte order NL | NM>] <shape file>");
        System.out.println();
        System.out.println("Options:");
        System.out.println("\t-t Index type: RTREE or QUADTREE");
        System.out.println();
        System.out.println("Following options apllies only to RTREE:");
        System.out.println("\t-M maximum number of entries per node");
        System.out.println("\t-m minimum number of entries per node");
        System.out.println("\t-s split algorithm to use");
        System.out.println();
        System.out.println("Following options apllies only to QUADTREE:");
        System.out.println("\t-b byte order to use: NL = LSB; NM = MSB (default)");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int index(boolean verbose, ProgressListener listener) throws MalformedURLException, IOException, TreeException, StoreException, LockTimeoutException {
        if (this.shpFiles == null) {
            throw new IOException("You have to set a shape file name!");
        }
        int cnt = 0;
        ShapefileReader reader = null;
        StorageFile storage = this.shpFiles.getStorageFile(ShpFileType.QIX);
        File treeFile = storage.getFile();
        try {
            reader = new ShapefileReader(this.shpFiles, true, false, new GeometryFactory());
            if (this.max == -1) {
                int features = reader.getCount(0);
                this.max = 1;
                int nodes = 1;
                while (nodes * 8 < features) {
                    ++this.max;
                    nodes *= 4;
                }
                reader.close();
                reader = new ShapefileReader(this.shpFiles, true, false, new GeometryFactory());
            }
            cnt = this.buildQuadTree(reader, treeFile, verbose);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        storage.replaceOriginal();
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int buildQuadTree(ShapefileReader reader, File file, boolean verbose) throws IOException, StoreException {
        LOGGER.info("Building quadtree spatial index with depth " + this.max + " for file " + file.getAbsolutePath());
        byte order = 0;
        if (this.byteOrder == null || this.byteOrder.equalsIgnoreCase("NM")) {
            order = 2;
        } else if (this.byteOrder.equalsIgnoreCase("NL")) {
            order = 1;
        } else {
            throw new StoreException("Asked byte order '" + this.byteOrder + "' must be 'NL' or 'NM'!");
        }
        IndexFile shpIndex = new IndexFile(this.shpFiles, false);
        QuadTree tree = null;
        int cnt = 0;
        int numRecs = shpIndex.getRecordCount();
        ShapefileHeader header = reader.getHeader();
        Envelope bounds = new Envelope(header.minX(), header.maxX(), header.minY(), header.maxY());
        tree = new QuadTree(numRecs, this.max, bounds, shpIndex);
        try {
            ShapefileReader.Record rec = null;
            while (reader.hasNext()) {
                rec = reader.nextRecord();
                tree.insert(cnt++, new Envelope(rec.minX, rec.maxX, rec.minY, rec.maxY));
                if (verbose && cnt % 1000 == 0) {
                    System.out.print('.');
                }
                if (cnt % 100000 != 0) continue;
                System.out.print('\n');
            }
            if (verbose) {
                System.out.println("done");
            }
            FileSystemIndexStore store = new FileSystemIndexStore(file, order);
            store.store(tree);
        }
        finally {
            tree.close();
        }
        return cnt;
    }

    public void setMax(int i) {
        this.max = i;
    }

    public void setShapeFileName(ShpFiles shpFiles) {
        this.shpFiles = shpFiles;
    }

    public void setByteOrder(String byteOrder) {
        this.byteOrder = byteOrder;
    }

    public String id() {
        return this.getClass().getName();
    }
}

