/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.tool;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import javax.measure.unit.Unit;
import javax.swing.ImageIcon;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapLayer;
import org.geotools.swing.JTextReporter;
import org.geotools.swing.TextReporterListener;
import org.geotools.swing.event.MapMouseEvent;
import org.geotools.swing.tool.CursorTool;
import org.geotools.swing.utils.MapLayerUtils;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.geometry.DirectPosition;

public class InfoTool
extends CursorTool
implements TextReporterListener {
    private static final ResourceBundle stringRes = ResourceBundle.getBundle("org/geotools/swing/Text");
    public static final String TOOL_NAME = stringRes.getString("tool_name_info");
    public static final String TOOL_TIP = stringRes.getString("tool_tip_info");
    public static final String CURSOR_IMAGE = "/org/geotools/swing/icons/mActionIdentify.png";
    public static final java.awt.Point CURSOR_HOTSPOT = new java.awt.Point(0, 0);
    public static final String ICON_IMAGE = "/org/geotools/swing/icons/mActionIdentify.png";
    public static final double DEFAULT_DISTANCE_FRACTION = 0.04;
    private Cursor cursor;
    private FilterFactory2 filterFactory;
    private GeometryFactory geomFactory;
    private JTextReporter reporter;

    public InfoTool() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        ImageIcon cursorIcon = new ImageIcon(this.getClass().getResource("/org/geotools/swing/icons/mActionIdentify.png"));
        int iconWidth = cursorIcon.getIconWidth();
        int iconHeight = cursorIcon.getIconHeight();
        Dimension bestCursorSize = tk.getBestCursorSize(cursorIcon.getIconWidth(), cursorIcon.getIconHeight());
        this.cursor = tk.createCustomCursor(cursorIcon.getImage(), CURSOR_HOTSPOT, TOOL_TIP);
        this.filterFactory = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        this.geomFactory = new GeometryFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMouseClicked(MapMouseEvent ev) {
        DirectPosition2D pos = ev.getMapPosition();
        Unit uom = this.getMapPane().getMapContext().getCoordinateReferenceSystem().getCoordinateSystem().getAxis(0).getUnit();
        ReferencedEnvelope mapEnv = this.getMapPane().getDisplayArea();
        double len = Math.max(mapEnv.getWidth(), mapEnv.getHeight());
        double thresholdDistance = len * 0.04;
        String uomName = uom.toString();
        Point posGeom = this.geomFactory.createPoint(new Coordinate(pos.x, pos.y));
        this.report(pos);
        for (MapLayer layer : this.getMapPane().getMapContext().getLayers()) {
            FeatureIterator iter = null;
            if (!layer.isSelected()) continue;
            String layerName = layer.getTitle();
            if (layerName == null || layerName.length() == 0) {
                layerName = layer.getFeatureSource().getName().getLocalPart();
            }
            if (layerName == null || layerName.length() == 0) {
                layerName = layer.getFeatureSource().getSchema().getName().getLocalPart();
            }
            try {
                Map<String, Object> result = MapLayerUtils.isGridLayer(layer);
                if (((Boolean)result.get("is_grid")).booleanValue()) {
                    iter = layer.getFeatureSource().getFeatures().features();
                    String gridAttr = (String)result.get("grid_attr");
                    Object obj = iter.next().getProperty(gridAttr).getValue();
                    GridCoverage2D cov = null;
                    if (((Boolean)result.get("is_grid_reader")).booleanValue()) {
                        AbstractGridCoverage2DReader reader = (AbstractGridCoverage2DReader)obj;
                        cov = reader.read(null);
                    } else {
                        cov = (GridCoverage2D)obj;
                    }
                    try {
                        Object objArray = cov.evaluate((DirectPosition)pos);
                        Number[] bandValues = this.asNumberArray(objArray);
                        this.report(layerName, bandValues);
                    }
                    catch (CannotEvaluateException ex) {}
                    continue;
                }
                Object filter = null;
                GeometryDescriptor geomDesc = layer.getFeatureSource().getSchema().getGeometryDescriptor();
                String attrName = geomDesc.getLocalName();
                Class geomClass = geomDesc.getType().getBinding();
                filter = Polygon.class.isAssignableFrom(geomClass) || MultiPolygon.class.isAssignableFrom(geomClass) ? this.filterFactory.intersects((Expression)this.filterFactory.property(attrName), (Expression)this.filterFactory.literal((Object)posGeom)) : this.filterFactory.dwithin((Expression)this.filterFactory.property(attrName), (Expression)this.filterFactory.literal((Object)posGeom), thresholdDistance, uomName);
                FeatureCollection selectedFeatures = layer.getFeatureSource().getFeatures((Filter)filter);
                iter = selectedFeatures.features();
                while (iter.hasNext()) {
                    this.report(layerName, iter.next());
                }
            }
            catch (IOException ioEx) {
            }
            finally {
                if (iter != null) {
                    iter.close();
                }
            }
        }
    }

    private void report(DirectPosition2D pos) {
        this.createReporter();
        this.reporter.append(String.format("Pos x=%.4f y=%.4f\n\n", pos.x, pos.y));
    }

    private void report(String layerName, Feature feature) {
        this.createReporter();
        Collection props = feature.getProperties();
        String valueStr = null;
        this.reporter.append(layerName);
        this.reporter.append("\n");
        for (Property prop : props) {
            String name = prop.getName().getLocalPart();
            Object value = prop.getValue();
            if (value instanceof Geometry) {
                name = "  Geometry";
                valueStr = value.getClass().getSimpleName();
            } else {
                valueStr = value.toString();
            }
            this.reporter.append(name + ": " + valueStr);
            this.reporter.append("\n");
        }
        this.reporter.append("\n");
    }

    private void report(String layerName, Number[] bandValues) {
        this.createReporter();
        this.reporter.append(layerName);
        this.reporter.append("\n");
        for (int i = 0; i < bandValues.length; ++i) {
            this.reporter.append(String.format("  Band %d: %s\n", i + 1, bandValues[i].toString()));
        }
        this.reporter.append("\n");
    }

    private void createReporter() {
        if (this.reporter == null) {
            this.reporter = new JTextReporter("Feature info");
            this.reporter.addListener(this);
            this.reporter.setSize(400, 400);
            this.reporter.setVisible(true);
        }
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public boolean drawDragBox() {
        return false;
    }

    public void onReporterClosed(WindowEvent ev) {
        this.reporter = null;
    }

    private Number[] asNumberArray(Object objArray) {
        Number[] numbers;
        block5: {
            block7: {
                block6: {
                    block4: {
                        numbers = null;
                        if (!(objArray instanceof byte[])) break block4;
                        byte[] values = (byte[])objArray;
                        numbers = new Number[values.length];
                        for (int i = 0; i < values.length; ++i) {
                            numbers[i] = values[i] & 0xFF;
                        }
                        break block5;
                    }
                    if (!(objArray instanceof int[])) break block6;
                    int[] values = (int[])objArray;
                    numbers = new Number[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        numbers[i] = values[i];
                    }
                    break block5;
                }
                if (!(objArray instanceof float[])) break block7;
                float[] values = (float[])objArray;
                numbers = new Number[values.length];
                for (int i = 0; i < values.length; ++i) {
                    numbers[i] = Float.valueOf(values[i]);
                }
                break block5;
            }
            if (!(objArray instanceof double[])) break block5;
            double[] values = (double[])objArray;
            numbers = new Number[values.length];
            for (int i = 0; i < values.length; ++i) {
                numbers[i] = values[i];
            }
        }
        return numbers;
    }
}

