/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib.swig;

import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import org.apache.log4j.Logger;
import org.geotools.data.terralib.persistence.exception.AttributeNotFoundException;
import org.geotools.data.terralib.swig.CoreJNI;
import org.geotools.data.terralib.swig.StringStringMap;
import org.geotools.data.terralib.swig.TeAttrDataType;

public class PersistenceTransferenceObject {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    private static final Logger _logger = Logger.getLogger(PersistenceTransferenceObject.class);

    protected PersistenceTransferenceObject(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(PersistenceTransferenceObject obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public synchronized void setToFreeNativeTarget(boolean isToFreenativeTarget) {
        this.swigCMemOwn = isToFreenativeTarget;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            CoreJNI.delete_PersistenceTransferenceObject(this.swigCPtr);
        }
        this.swigCPtr = 0L;
    }

    public PersistenceTransferenceObject() {
        this(CoreJNI.new_PersistenceTransferenceObject(), true);
    }

    public void setIntegerAttribute(String name, int value) {
        CoreJNI.PersistenceTransferenceObject_setIntegerAttribute(this.swigCPtr, this, name, value);
    }

    public int getIntegerAttribute(String name) throws AttributeNotFoundException {
        return CoreJNI.PersistenceTransferenceObject_getIntegerAttribute(this.swigCPtr, this, name);
    }

    public void setDoubleAttribute(String name, double value) {
        CoreJNI.PersistenceTransferenceObject_setDoubleAttribute(this.swigCPtr, this, name, value);
    }

    public double getDoubleAttribute(String name) throws AttributeNotFoundException {
        return CoreJNI.PersistenceTransferenceObject_getDoubleAttribute(this.swigCPtr, this, name);
    }

    public void setStringAttribute(String name, String value) {
        CoreJNI.PersistenceTransferenceObject_setStringAttribute(this.swigCPtr, this, name, value);
    }

    public String getStringAttribute(String name) throws AttributeNotFoundException {
        return CoreJNI.PersistenceTransferenceObject_getStringAttribute(this.swigCPtr, this, name);
    }

    public void setDateAttribute(String name, String value) {
        CoreJNI.PersistenceTransferenceObject_setDateAttribute(this.swigCPtr, this, name, value);
    }

    public String getDateAttribute(String name) {
        return CoreJNI.PersistenceTransferenceObject_getDateAttribute(this.swigCPtr, this, name);
    }

    public boolean hasPoints() {
        return CoreJNI.PersistenceTransferenceObject_hasPoints(this.swigCPtr, this);
    }

    public void setPointGeometries(MultiPoint pointSet) {
        CoreJNI.PersistenceTransferenceObject_setPointGeometries(this.swigCPtr, this, pointSet);
    }

    public MultiPoint getPointGeometries() {
        return CoreJNI.PersistenceTransferenceObject_getPointGeometries(this.swigCPtr, this);
    }

    public boolean hasPolygons() {
        return CoreJNI.PersistenceTransferenceObject_hasPolygons(this.swigCPtr, this);
    }

    public void setPolygonGeometries(MultiPolygon polygonSet) {
        CoreJNI.PersistenceTransferenceObject_setPolygonGeometries(this.swigCPtr, this, polygonSet);
    }

    public MultiPolygon getPolygonGeometries() {
        return CoreJNI.PersistenceTransferenceObject_getPolygonGeometries(this.swigCPtr, this);
    }

    public boolean hasLines() {
        return CoreJNI.PersistenceTransferenceObject_hasLines(this.swigCPtr, this);
    }

    public void setLineGeometries(MultiLineString lineSet) {
        CoreJNI.PersistenceTransferenceObject_setLineGeometries(this.swigCPtr, this, lineSet);
    }

    public MultiLineString getLineGeometries() {
        return CoreJNI.PersistenceTransferenceObject_getLineGeometries(this.swigCPtr, this);
    }

    public StringStringMap getAttributesMap() {
        return new StringStringMap(CoreJNI.PersistenceTransferenceObject_getAttributesMap(this.swigCPtr, this), true);
    }

    public TeAttrDataType getAttributeType(String attributeName) {
        return TeAttrDataType.swigToEnum(CoreJNI.PersistenceTransferenceObject_getAttributeType(this.swigCPtr, this, attributeName));
    }
}

