package org.geotools.data.terralib.connection;

import org.apache.log4j.Logger;
import org.geotools.data.terralib.NativeLibraryLoader;
import org.geotools.data.terralib.swig.DBConnectionFactoryNative;

public class DBConnectionFactory extends DBConnectionFactoryNative
{
    private static final Logger _logger = Logger.getLogger(DBConnectionFactory.class);

    static
    {
        _logger.info("Loading the provider DLLs...");

        boolean dllsLoaded = NativeLibraryLoader.loadLibraries();

        if (dllsLoaded)
        {
            _logger.info("Terralib provider DLLs loaded successfully.");
        }
        else
        {
            _logger.error("Failed to load the terralib provider DLLs!");
        }
    }

    public DBConnectionFactory()
    {
    }
}
