/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2009(c).
 * 
 * file: TerralibDefaultFeatureReader.java
 * created: 20/03/2009
 */
package org.geotools.data.terralib.feature;

import java.io.IOException;

import org.geotools.data.AttributeReader;
import org.geotools.data.DefaultFeatureReader;
import org.geotools.data.terralib.query.TerralibQueryData;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

/**
 * @author fmoura
 *
 */
public class TerralibFeatureReader extends DefaultFeatureReader
{
//    protected static final String FEATURE_ID_ATTRIBUTE_NAME = TerralibServiceNative.getFEATURE_ID_COLUMN_NAME();
    
    private SimpleFeatureBuilder _builder;
    
   
    /**
     * @param attributeReader
     * @param schema
     * @throws SchemaException
     */
    public TerralibFeatureReader(AttributeReader attributeReader,
            SimpleFeatureType schema) throws SchemaException
    {
        super(attributeReader, schema);
        SimpleFeatureType typeSchema = schema;
        if (typeSchema == null) {
            typeSchema = createSchema();
        }
        _builder = new SimpleFeatureBuilder(typeSchema);
    }
    
    /* (non-Javadoc)
     * @see org.geotools.data.DefaultFeatureReader#readFeature(org.geotools.data.AttributeReader)
     */
    @Override
    protected SimpleFeature readFeature(AttributeReader atts)
    throws IllegalAttributeException, IOException 
    {
        
        if (!(atts instanceof TerralibQueryData))
        	throw new IllegalAttributeException("TerralibFeatureRead's attribute reader should be a TerralibQueryData");

        String id = ((TerralibQueryData)atts).getObjectId();
        
        int size = atts.getAttributeCount();
        
        for (int i = 0; i < size; i++) {
            attributes[i] = atts.read(i);
        }
        
        _builder.addAll(attributes);
        return _builder.buildFeature(id);
    
    }

}
