package org.geotools.data.terralib.geometry;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;

public class TextGeometry extends Point
{

	private static final long serialVersionUID = 6376261136655554443L;
	
	private String _text;
	double _angle = 0;	
	
	public TextGeometry(Point point)
	{
		super(point.getCoordinateSequence(),point.getFactory());
		_text = "";
	}
	
	protected TextGeometry(Point point, String text)
	{
		super(point.getCoordinateSequence(),point.getFactory());
		_text = text;
	}
	
	protected TextGeometry(Point point, String text, double angle)
	{
		super(point.getCoordinateSequence(),point.getFactory());
		_text = text;
		_angle = angle;
	}
	
	public String getText()
	{
		return _text;
	}
	
	public void setText(String text)
	{
		_text = text;
	}
	
	/**
	 * @return the angle
	 */
	public double getAngle() {
		return _angle;
	}

	/**
	 * @param angle the angle to set
	 */
	public void setAngle(double angle) {
		this._angle = angle;
	}

	@Override
	public boolean equals(Geometry g) 
	{
		if(!(g instanceof TextGeometry)) return false;
		if(super.equals(g) && _text.equals(((TextGeometry)g)._text) &&  _angle == ((TextGeometry)g)._angle  ) return true;
		return false;
	}
	
	
	@Override
	public boolean equalsExact(Geometry other, double tolerance) {
		if(!(other instanceof TextGeometry)) return false;
		if(super.equalsExact(other, tolerance) && _text.equals(((TextGeometry)other)._text) && _angle == ((TextGeometry)other)._angle )  return true;
		return false;
		
	}
	
	@Override
	public String getGeometryType() {
		return "Text";
	}
}
