/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2008(c).
 * 
 * file: TerralibAttributeHelper.java
 * created: 14/05/2008
 */
package org.geotools.data.terralib.util;

import java.util.List;

import org.geotools.feature.AttributeTypeBuilder;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.filter.Filter;

/**
 * Helper class, provides methods to work with attributes at the TerralibProvider
 * @author fabiomano
 * @since TDK3.0.0
 */
public class TerralibAttributeHelper 
{

	/**
	 * <p>Creates an AttributeDescriptor.</p>
	 * <p>AttributeDescriptors can have other parameters, but these are the ones
	 * TerralibProvider uses.</p>
	 * @param name Attribute's name
	 * @param binding The attribute's binding type
	 * @param primaryKey If the attribute is a primary key
	 * @param nullable If the attribute accepts null
	 * @param length Length of the attribute (not valid for geometry attributes)
	 * @see TypeAttributeMap
	 * @return The AttributeDescriptor created
	 */
    public static AttributeDescriptor buildType(String name, TypeAttributeMap binding, boolean primaryKey, boolean nullable, int maxOccurs)
    {
    	return buildType(name, binding, primaryKey, nullable, maxOccurs,null);
    }

	/**
	 * <p>Creates an AttributeDescriptor.</p>
	 * <p>AttributeDescriptors can have other parameters, but these are the ones
	 * TerralibProvider uses.</p>
	 * @param name Attribute's name
	 * @param binding The attribute's binding type
	 * @param primaryKey If the attribute is a primary key
	 * @param nullable If the attribute accepts null
	 * @param length Length of the attribute (not valid for geometry attributes)
	 * @param restrictions Filter restrictions for the attributeDescritor
	 * @see TypeAttributeMap
	 * @return The AttributeDescriptor created
	 */
    public static AttributeDescriptor buildType(String name, TypeAttributeMap binding, boolean primaryKey, boolean nullable, int maxOccurs, List<Filter> restrictions)
    {
    	AttributeTypeBuilder typeBuilder = new AttributeTypeBuilder();
		typeBuilder.setBinding(binding.getBindingClass());
    	typeBuilder.setName(name);
    	typeBuilder.setIdentifiable(primaryKey);
    	typeBuilder.setNillable(nullable);
    	typeBuilder.setLength(maxOccurs);
    	typeBuilder.setMaxOccurs(maxOccurs);
    	if (restrictions != null)
    	{
	    	for (Filter filter: restrictions)
	    		typeBuilder.addRestriction(filter);
    	}
		AttributeType attribute = typeBuilder.buildType();
		AttributeDescriptor attrDescriptor = typeBuilder.buildDescriptor(name, attribute);
		return attrDescriptor;
    } 	
	
}
