/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.log4j.Logger;
import org.geotools.data.AbstractDataStoreFactory;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.terralib.NativeLibraryLoader;
import org.geotools.data.terralib.TerralibDataStore;
import org.geotools.data.terralib.connection.DBConnectionFactory;
import org.geotools.data.terralib.connection.DBConnectionParamUtils;

public class TerralibDataStoreFactory
extends AbstractDataStoreFactory {
    private static final Logger _logger = Logger.getLogger(TerralibDataStoreFactory.class);

    public DataStore createDataStore(Map<String, Serializable> params) throws IOException {
        if (params == null) {
            throw new IllegalArgumentException("The TerraLib connection parameters map can't be null.");
        }
        if (!this.canProcess(params)) {
            throw new IOException("The parameters map isn't correct!!");
        }
        return new TerralibDataStore(new DBConnectionFactory(), params);
    }

    public boolean canProcess(Map params) {
        if (params == null) {
            throw new IllegalArgumentException("The TerraLib connection parameters map can't be null.");
        }
        if (!super.canProcess(params)) {
            return false;
        }
        if (!this.loadDlls()) {
            return false;
        }
        try {
            DBConnectionParamUtils.checkParams(params);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private boolean loadDlls() {
        boolean result = NativeLibraryLoader.loadLibraries();
        if (!result) {
            _logger.error((Object)"Error trying to load terralib provider dlls. Please check your java.library.path property.");
        }
        return result;
    }

    public DataStore createNewDataStore(Map<String, Serializable> params) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getDescription() {
        return "TerraLib database";
    }

    public String getDisplayName() {
        return "TerraLib";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{DBConnectionParamUtils.DBTYPE, DBConnectionParamUtils.DBDRIVER, DBConnectionParamUtils.DBPATH, DBConnectionParamUtils.DBNAME, DBConnectionParamUtils.HOST, DBConnectionParamUtils.PORT, DBConnectionParamUtils.USER, DBConnectionParamUtils.PASSWD};
    }

    public boolean isAvailable() {
        return this.loadDlls();
    }
}

