/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.data.terralib.TerralibDataStore;
import org.geotools.data.terralib.exception.NullArgumentException;
import org.geotools.data.terralib.exception.TerralibProviderRuntimeException;
import org.geotools.data.terralib.util.TypeAttributeMap;
import org.opengis.feature.simple.SimpleFeatureType;

public class TerralibMetadata {
    private static final String THEME_IDENTIFIER = "@";
    private static final String POINTS_TABLE_PREFIX = "Points";
    private static final String LINES_TABLE_PREFIX = "Lines";
    private static final String POLYGONS_TABLE_PREFIX = "Polygons";
    private TerralibDataStore _dataStore;
    private Map<String, TypeInfo> _typeInfoMap;
    private Connection _con;
    private Object _lock = new Object();
    private PreparedStatement _stmtLayerAttr;
    private PreparedStatement _stmtThemeAttr;
    private PreparedStatement _stmtLayerId;
    private PreparedStatement _stmtThemeId;

    public TerralibMetadata(TerralibDataStore dataStore, Connection con) {
        if (dataStore == null) {
            throw new NullArgumentException("dataStore");
        }
        if (con == null) {
            throw new NullArgumentException("con");
        }
        this._dataStore = dataStore;
        this._typeInfoMap = new HashMap<String, TypeInfo>();
        this._con = con;
        this.buildPreparedStatements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGeometryTable(String typeName) throws IOException {
        if (typeName == null) {
            throw new NullArgumentException("typeName");
        }
        if (typeName.trim().isEmpty()) {
            throw new IllegalArgumentException("typeName shouldn't be empty");
        }
        if (!this._typeInfoMap.containsKey(typeName)) {
            Object object = this._lock;
            synchronized (object) {
                if (!this._typeInfoMap.containsKey(typeName)) {
                    try {
                        this.fillCache(typeName);
                    }
                    catch (SQLException e) {
                        throw new IOException("Error getting metadata information about typename " + typeName, e);
                    }
                }
            }
        }
        return this._typeInfoMap.get(typeName).getGeometryTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AttributeTableInfo> getAttributeTables(String typeName) throws IOException {
        if (typeName == null) {
            throw new NullArgumentException("typeName");
        }
        if (typeName.trim().isEmpty()) {
            throw new IllegalArgumentException("typeName shouldn't be empty");
        }
        if (!this._typeInfoMap.containsKey(typeName)) {
            Object object = this._lock;
            synchronized (object) {
                if (!this._typeInfoMap.containsKey(typeName)) {
                    try {
                        this.fillCache(typeName);
                    }
                    catch (SQLException e) {
                        throw new IOException("Error getting metadata information about typename " + typeName, e);
                    }
                }
            }
        }
        return this._typeInfoMap.get(typeName).getAttributeTables();
    }

    private void buildPreparedStatements() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT t.layer_id , lt.attr_table, lt.unique_id ");
        stringBuilder.append(" from te_theme t, te_theme_table tt, te_layer_table lt ");
        stringBuilder.append(" where t.name = ?");
        stringBuilder.append(" and t.view_id = ?");
        stringBuilder.append(" and t.theme_id = tt.theme_id ");
        stringBuilder.append(" and tt.table_id = lt.table_id ");
        try {
            this._stmtThemeAttr = this._con.prepareStatement(stringBuilder.toString());
        }
        catch (SQLException e) {
            throw new TerralibProviderRuntimeException("Error creating query to retrieve theme metadata.", e);
        }
        stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT L.layer_id ,T.attr_table, T.unique_id");
        stringBuilder.append(" from te_layer L, te_layer_table T ");
        stringBuilder.append(" where L.layer_id = T.layer_id ");
        stringBuilder.append(" and L.name = ?");
        try {
            this._stmtLayerAttr = this._con.prepareStatement(stringBuilder.toString());
        }
        catch (SQLException e) {
            throw new TerralibProviderRuntimeException("Error creating query to retrieve layer metadata.", e);
        }
        try {
            this._stmtThemeId = this._con.prepareStatement("SELECT layer_id from te_theme where name = ? and view_id = ?");
        }
        catch (SQLException e) {
            throw new TerralibProviderRuntimeException("Error creating query to retrieve layer metadata.", e);
        }
        try {
            this._stmtLayerId = this._con.prepareStatement("SELECT layer_id from te_layer where name = ?");
        }
        catch (SQLException e) {
            throw new TerralibProviderRuntimeException("Error creating query to retrieve layer metadata.", e);
        }
    }

    private void fillCache(String typeName) throws SQLException, IOException {
        ResultSet rs;
        if (typeName.contains(THEME_IDENTIFIER)) {
            this._stmtThemeAttr.setString(1, this.getThemeName(typeName));
            this._stmtThemeAttr.setInt(2, this.getViewId(typeName));
            rs = this._stmtThemeAttr.executeQuery();
        } else {
            this._stmtLayerAttr.setString(1, typeName);
            rs = this._stmtLayerAttr.executeQuery();
        }
        int layerId = -1;
        ArrayList<AttributeTableInfo> names = new ArrayList<AttributeTableInfo>();
        while (rs.next()) {
            layerId = rs.getInt("layer_id");
            names.add(new AttributeTableInfo(rs.getString("attr_table"), rs.getString("unique_id")));
        }
        rs.close();
        TypeInfo info = new TypeInfo();
        info.setAttributeTableInfo(names);
        if (layerId == -1) {
            layerId = this.retrieveLayerID(typeName);
        }
        if (layerId == -1) {
            throw new TerralibProviderRuntimeException("The layer " + typeName + " you are trying to read was not found. If you are using access and has just created the layer, it is an access known bug. Try to wait a little before reading the data.");
        }
        SimpleFeatureType schema = this._dataStore.getSchema(typeName);
        Class binding = schema.getGeometryDescriptor().getType().getBinding();
        TypeAttributeMap type = TypeAttributeMap.fromBindingClass(binding);
        if (type == null) {
            throw new TerralibProviderRuntimeException("Geometry type " + binding + " not supported");
        }
        switch (type) {
            case TA_POINT: 
            case TA_MULTIPOINT: {
                info.setGeometryTable(POINTS_TABLE_PREFIX + layerId);
                break;
            }
            case TA_LINE: 
            case TA_MULTILINE: {
                info.setGeometryTable(LINES_TABLE_PREFIX + layerId);
                break;
            }
            case TA_POLYGON: 
            case TA_MULTIPOLYGON: {
                info.setGeometryTable(POLYGONS_TABLE_PREFIX + layerId);
                break;
            }
            default: {
                throw new TerralibProviderRuntimeException("Geometry type " + binding + " not supported");
            }
        }
        this._typeInfoMap.put(typeName, info);
    }

    private int retrieveLayerID(String typeName) throws SQLException {
        ResultSet rs;
        if (typeName.contains(THEME_IDENTIFIER)) {
            this._stmtThemeAttr.setString(1, this.getThemeName(typeName));
            this._stmtThemeAttr.setInt(2, this.getViewId(typeName));
            rs = this._stmtThemeAttr.executeQuery();
        } else {
            this._stmtLayerAttr.setString(1, typeName);
            rs = this._stmtLayerAttr.executeQuery();
        }
        if (rs.next()) {
            return rs.getInt("layer_id");
        }
        return -1;
    }

    private int getViewId(String typeName) {
        return Integer.parseInt(typeName.substring(0, typeName.indexOf(THEME_IDENTIFIER)));
    }

    private String getThemeName(String typeName) {
        return typeName.substring(typeName.indexOf(THEME_IDENTIFIER) + 1);
    }

    public void dispose() {
        try {
            this._stmtLayerAttr.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            this._stmtThemeAttr.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            this._stmtLayerId.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            this._stmtThemeId.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static class AttributeTableInfo {
        private String _tableName;
        private String _uniqueId;

        private AttributeTableInfo(String tableName, String uniqueId) {
            this._tableName = tableName;
            this._uniqueId = uniqueId;
        }

        public String getTableName() {
            return this._tableName;
        }

        public String getUniqueId() {
            return this._uniqueId;
        }
    }

    private static class TypeInfo {
        private String _geometryTable;
        private List<AttributeTableInfo> _attributeTables = new ArrayList<AttributeTableInfo>();

        public String getGeometryTable() {
            return this._geometryTable;
        }

        public void setGeometryTable(String geometryTable) {
            this._geometryTable = geometryTable;
        }

        public List<AttributeTableInfo> getAttributeTables() {
            return this._attributeTables;
        }

        public void setAttributeTableInfo(List<AttributeTableInfo> attributeTables) {
            this._attributeTables = attributeTables;
        }
    }
}

