/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib.connection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.geotools.data.terralib.NativeLibraryLoader;
import org.geotools.data.terralib.swig.DBConnectionFactoryNative;

public class DBConnectionFactory
extends DBConnectionFactoryNative {
    private static final Logger _logger = Logger.getLogger(DBConnectionFactory.class);
    private final String ACCESS_DRIVER = "sun.jdbc.odbc.JdbcOdbcDriver";

    public Connection createJDBCAccessConnection(String path) {
        try {
            String URL2 = "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=" + path + ";}";
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            return DriverManager.getConnection(URL2);
        }
        catch (SQLException e) {
            _logger.error((Object)"Error connecting to Access database.", (Throwable)e);
            return null;
        }
        catch (ClassNotFoundException e) {
            _logger.error((Object)"Error connecting to Access database.", (Throwable)e);
            return null;
        }
    }

    public Connection createJDBCSqlServerConnection(String host, String userName, String password, String databaseName, int portNumber) {
        try {
            String connectionString = "jdbc:jtds:sqlserver://" + this.fixHost(host) + ":" + portNumber + "/" + databaseName;
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
            Connection conn = DriverManager.getConnection(connectionString, userName, password);
            return conn;
        }
        catch (ClassNotFoundException e) {
            _logger.error((Object)"Error connecting to SqlServer database.", (Throwable)e);
            return null;
        }
        catch (SQLException e) {
            _logger.error((Object)"Error connecting to SqlServer database.", (Throwable)e);
            return null;
        }
    }

    private String fixHost(String host) {
        String jtdsHost = host.contains("\\") ? host.substring(0, host.indexOf("\\")) : (host.contains("/") ? host.substring(0, host.indexOf("/")) : (host.contains(",") ? host.substring(0, host.indexOf(",")) : host));
        return jtdsHost;
    }

    static {
        _logger.info((Object)"Loading the provider DLLs...");
        boolean dllsLoaded = NativeLibraryLoader.loadLibraries();
        if (dllsLoaded) {
            _logger.info((Object)"Terralib provider DLLs loaded successfully.");
        } else {
            _logger.error((Object)"Failed to load the terralib provider DLLs!");
        }
    }
}

