/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib.feature;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.geotools.data.AbstractFeatureStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.terralib.TerralibDataStore;
import org.geotools.data.terralib.exception.NullArgumentException;
import org.geotools.data.terralib.feature.TerralibFeatureReaderWriter;
import org.geotools.data.terralib.feature.TerralibQueryCapabilities;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;

public class TerralibFeatureStore
extends AbstractFeatureStore {
    private TerralibDataStore _dataStore;
    private final SimpleFeatureType _featureType;
    private TerralibQueryCapabilities _capabilities;

    public TerralibFeatureStore(TerralibDataStore dataStore, Set hints, SimpleFeatureType featureType) {
        super(hints);
        if (dataStore == null) {
            throw new NullArgumentException("dataStore");
        }
        if (featureType == null) {
            throw new NullArgumentException("featureType");
        }
        this._dataStore = dataStore;
        this._featureType = featureType;
        this._capabilities = new TerralibQueryCapabilities();
    }

    public QueryCapabilities getQueryCapabilities() {
        return this._capabilities;
    }

    public DataStore getDataStore() {
        return this._dataStore;
    }

    public void addFeatureListener(FeatureListener listener) {
        this._dataStore.listenerManager.addFeatureListener((FeatureSource)this, listener);
    }

    public SimpleFeatureType getSchema() {
        return this._featureType;
    }

    public void removeFeatureListener(FeatureListener listener) {
        this._dataStore.listenerManager.removeFeatureListener((FeatureSource)this, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FeatureId> addFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) throws IOException {
        LinkedList<FeatureId> addedFids = new LinkedList<FeatureId>();
        String typeName = this.getSchema().getTypeName();
        SimpleFeature feature = null;
        FeatureCollection fcCopy = FeatureCollections.newCollection();
        FeatureIterator iterator = collection.features();
        try {
            while (iterator.hasNext()) {
                fcCopy.add(iterator.next());
            }
        }
        finally {
            collection.close(iterator);
        }
        FeatureWriter writer = this.getDataStore().getFeatureWriterAppend(typeName, this.getTransaction());
        iterator = fcCopy.features();
        try {
            while (iterator.hasNext()) {
                feature = (SimpleFeature)iterator.next();
                SimpleFeature newFeature = (SimpleFeature)writer.next();
                try {
                    newFeature.setAttributes(feature.getAttributes());
                    if (newFeature instanceof TerralibFeatureReaderWriter.TerralibSimpleFeature) {
                        ((TerralibFeatureReaderWriter.TerralibSimpleFeature)newFeature).setID(feature.getID());
                    }
                }
                catch (Exception writeProblem) {
                    throw new DataSourceException("Could not create " + typeName + " out of provided feature: " + feature.getID(), (Throwable)writeProblem);
                }
                writer.write();
                addedFids.add(newFeature.getIdentifier());
            }
        }
        finally {
            collection.close(iterator);
            writer.close();
        }
        return addedFids;
    }

    public void removeFeatures(Filter filter) throws IOException {
        if (Filter.INCLUDE.equals(filter)) {
            this._dataStore.removeAllFeatures(this._featureType.getTypeName());
        } else {
            super.removeFeatures(filter);
        }
    }
}

