/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib.query;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;
import org.geotools.data.terralib.TerralibMetadata;
import org.geotools.data.terralib.TerralibService;
import org.geotools.data.terralib.exception.NullArgumentException;
import org.geotools.data.terralib.exception.TerralibProviderRuntimeException;
import org.geotools.data.terralib.exception.TypeNotFoundException;
import org.geotools.data.terralib.query.QuerierParams;
import org.geotools.data.terralib.query.QueryData;
import org.geotools.data.terralib.query.TerralibQueryData;
import org.geotools.data.terralib.query.check.QueryChecker;
import org.geotools.data.terralib.query.filter.TerralibFilterToSQL;
import org.geotools.data.terralib.query.portal.JavaPortal;
import org.geotools.data.terralib.util.TerralibResultSet;
import org.geotools.data.terralib.util.TypeAttributeMap;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.filter.spatial.BinarySpatialOperator;

public class JavaQuerier {
    private static final String COL_GEOM_ID = "geom_id";
    private static final String COL_OBJECT_ID = "object_id";
    private static final String ROW_NUMBER_COL = "rowNumber";
    private final String START_INDEX_TABLE = "StartIndexFrom";
    private final String START_INDEX_OBJECT_ID = "StartIndexObjectId";
    private static Logger _logger = Logger.getLogger(JavaQuerier.class);
    private TerralibService _service;
    private Connection _con;
    private QueryChecker _checker;
    private TerralibMetadata _metadata;

    public JavaQuerier(TerralibService service, Connection jdbcConnection, TerralibMetadata metadata, QueryChecker checker) {
        if (service == null) {
            throw new NullArgumentException("service");
        }
        if (metadata == null) {
            throw new NullArgumentException("metadata");
        }
        if (checker == null) {
            throw new NullArgumentException("checker");
        }
        this._metadata = metadata;
        this._service = service;
        this._con = jdbcConnection;
        this._checker = checker;
    }

    public QueryData execute(QuerierParams params) throws IOException, TypeNotFoundException {
        if (this._con == null) {
            throw new IOException("The connection with the database could not be estabilished");
        }
        if (params == null) {
            throw new NullArgumentException("params");
        }
        this._checker.checkQuery(params.getQuery());
        String query = this.buildQuery(params);
        JavaPortal portal = new JavaPortal(this.executeQuery(query));
        return new TerralibQueryData(this._service, portal, params.getFeatureTypeInfo());
    }

    private ResultSet executeQuery(String query) throws IOException {
        try {
            Statement stmt = this._con.createStatement();
            return new TerralibResultSet(stmt.executeQuery(query));
        }
        catch (SQLException e) {
            throw new IOException("Error executing query to retrieve terralib geometries.", e);
        }
    }

    protected String buildQuery(QuerierParams params) throws IOException {
        String query = "";
        Class binding = params.getFeatureTypeInfo().getDefaultGeometryType().getBinding();
        TypeAttributeMap type = TypeAttributeMap.fromBindingClass(binding);
        if (type == null) {
            throw new TerralibProviderRuntimeException("Type " + binding + " not supported");
        }
        if (!type.isGeometry()) {
            throw new TerralibProviderRuntimeException("Type " + binding + " is not a geometry");
        }
        Filter filter = params.getFilter();
        TerralibFilterToSQL filterToSQL = new TerralibFilterToSQL(params.getFeatureTypeInfo().getFeatureType(), this._metadata.getGeometryTable(params.getFeatureTypeInfo().getTypeName()));
        if (!filterToSQL.supports(filter)) {
            _logger.warn((Object)("Filter " + params.getFilter() + " is not supported by JavaQuerier. All features will be retrieved and it will be filtered in memory (slower)"));
            return this.buildSelectSimple(params, "", false, "");
        }
        if (this.hasMaxFeatures(params) || this.hasStartIndex(params)) {
            query = this.buildStartIndexMaxFeaturesSelect(params, filterToSQL.encodeToString(filter));
        } else if (BinarySpatialOperator.class.isAssignableFrom(filter.getClass())) {
            TerralibFilterToSQL optimizedFilterToSQL = new TerralibFilterToSQL(params.getFeatureTypeInfo().getFeatureType());
            String spatialWhere = optimizedFilterToSQL.encodeToString(filter);
            query = this.buildSelectSimple(params, "", true, spatialWhere);
        } else if (this.isAndSpatialFilter(filter)) {
            TerralibFilterToSQL optimizedFilterToSQL = new TerralibFilterToSQL(params.getFeatureTypeInfo().getFeatureType());
            Filter spatial = this.getSpatialAndFilter((And)filter);
            Filter nonSpatial = this.getNonSpatialAndFilter((And)filter);
            String where = filterToSQL.encodeToString(nonSpatial);
            String spatialWhere = optimizedFilterToSQL.encodeToString(spatial);
            query = this.buildSelectSimple(params, where, true, spatialWhere);
        } else {
            String where = filterToSQL.encodeToString(filter);
            query = this.buildSelectSimple(params, where, false, "");
        }
        return query;
    }

    private Filter getSpatialAndFilter(And filter) {
        Filter left = (Filter)filter.getChildren().get(0);
        if (BinarySpatialOperator.class.isAssignableFrom(left.getClass())) {
            return left;
        }
        return (Filter)filter.getChildren().get(1);
    }

    private Filter getNonSpatialAndFilter(And filter) {
        Filter left = (Filter)filter.getChildren().get(0);
        if (!BinarySpatialOperator.class.isAssignableFrom(left.getClass())) {
            return left;
        }
        return (Filter)filter.getChildren().get(1);
    }

    private boolean isAndSpatialFilter(Filter filter) {
        if (And.class.isAssignableFrom(filter.getClass()) && ((And)filter).getChildren().size() == 2) {
            Filter left = (Filter)((And)filter).getChildren().get(0);
            Filter right = (Filter)((And)filter).getChildren().get(1);
            if (BinarySpatialOperator.class.isAssignableFrom(left.getClass()) && !BinarySpatialOperator.class.isAssignableFrom(right.getClass())) {
                return true;
            }
            if (BinarySpatialOperator.class.isAssignableFrom(right.getClass()) && !BinarySpatialOperator.class.isAssignableFrom(left.getClass())) {
                return true;
            }
        }
        return false;
    }

    private String buildSelectSimple(QuerierParams params, String where, boolean optimize, String optimizedSpatialWhere) throws IOException {
        String whereQuery;
        String typeName = params.getFeatureTypeInfo().getTypeName();
        String geomTable = this._metadata.getGeometryTable(typeName);
        List<TerralibMetadata.AttributeTableInfo> attrTables = this._metadata.getAttributeTables(typeName);
        String query = "SELECT * FROM " + geomTable + " AS P ";
        if (optimize) {
            query = query + ", (select distinct " + COL_OBJECT_ID + " as spatial_object_id from " + geomTable + " " + optimizedSpatialWhere + ") as spatialAux";
            whereQuery = where.isEmpty() ? " WHERE " : where + " AND ";
            whereQuery = whereQuery + " p." + COL_OBJECT_ID + " = spatialAux.spatial_object_id ";
        } else {
            whereQuery = where;
        }
        query = query + this.buildAttributeFrom(attrTables) + " ";
        whereQuery = whereQuery.isEmpty() ? " WHERE " + this.buildAttributeJoinWhere(attrTables, "P") : whereQuery + " AND " + this.buildAttributeJoinWhere(attrTables, "P");
        query = query + whereQuery + this.buildOrderBy(params, true, attrTables);
        return query;
    }

    private String buildAttributeFrom(List<TerralibMetadata.AttributeTableInfo> attrTables) {
        String from = "";
        int i = 1;
        for (TerralibMetadata.AttributeTableInfo info : attrTables) {
            from = from + ", " + info.getTableName() + " t" + i;
            ++i;
        }
        return from;
    }

    private String buildAttributeJoinWhere(List<TerralibMetadata.AttributeTableInfo> attrTables, String attrTableAlias) {
        String where = "";
        int i = 1;
        for (TerralibMetadata.AttributeTableInfo info : attrTables) {
            if (!where.isEmpty()) {
                where = where + " AND ";
            }
            where = where + attrTableAlias + "." + COL_OBJECT_ID + " = t" + i + "." + info.getUniqueId();
            ++i;
        }
        return where;
    }

    private String buildMaxFeaturesStartIndexWhereQuery(QuerierParams params) {
        String rowNumberWhere = "";
        if (this.hasMaxFeatures(params) || this.hasStartIndex(params)) {
            rowNumberWhere = " AND object_id = StartIndexObjectId";
            int startIndex = 1;
            if (this.hasStartIndex(params)) {
                startIndex = params.getQuery().getStartIndex();
                rowNumberWhere = rowNumberWhere + " AND " + ROW_NUMBER_COL + " >= " + startIndex;
            }
            if (this.hasMaxFeatures(params)) {
                rowNumberWhere = rowNumberWhere + " AND " + ROW_NUMBER_COL + " < " + (startIndex + params.getQuery().getMaxFeatures());
            }
        }
        return rowNumberWhere;
    }

    private String buildRowNumberFromQuery(QuerierParams params, String geomTable, String where, List<TerralibMetadata.AttributeTableInfo> attrTables) throws IOException {
        if (this.hasMaxFeatures(params) || this.hasStartIndex(params)) {
            String internalQuery = "SELECT DISTINCT P.object_id FROM " + geomTable + " AS P " + this.buildAttributeFrom(attrTables);
            String whereQuery = where;
            whereQuery = whereQuery.isEmpty() ? " WHERE " + this.buildAttributeJoinWhere(attrTables, "P") : " " + whereQuery + " AND " + this.buildAttributeJoinWhere(attrTables, "P");
            internalQuery = internalQuery + whereQuery;
            return ", ( SELECT ROW_NUMBER() OVER (" + this.buildOrderBy(params, false, attrTables) + ") AS " + ROW_NUMBER_COL + ", " + COL_OBJECT_ID + " AS " + "StartIndexObjectId" + " FROM (" + internalQuery + ") AS TEMP " + this.buildAttributeFrom(attrTables) + " WHERE " + this.buildAttributeJoinWhere(attrTables, "TEMP") + ") AS " + "StartIndexFrom";
        }
        return "";
    }

    private String buildOrderBy(QuerierParams params, boolean includeGeom, List<TerralibMetadata.AttributeTableInfo> attrTables) {
        String orderBy = "";
        if (params.getQuery().getSortBy() != null) {
            for (SortBy sort : params.getQuery().getSortBy()) {
                orderBy = this.orderBySeparator(orderBy);
                orderBy = orderBy + sort.getPropertyName();
                if (sort.getSortOrder() != SortOrder.DESCENDING) continue;
                orderBy = orderBy + " DESC ";
            }
        }
        if (includeGeom) {
            orderBy = this.orderBySeparator(orderBy);
            orderBy = orderBy + " P.object_id, P.geom_id";
        } else if (attrTables.size() > 0) {
            orderBy = this.orderBySeparator(orderBy);
            orderBy = orderBy + attrTables.get(0).getUniqueId();
        }
        return orderBy;
    }

    private String orderBySeparator(String orderBy) {
        if (orderBy.isEmpty()) {
            return " ORDER BY ";
        }
        return orderBy + ",";
    }

    private boolean hasStartIndex(QuerierParams params) {
        return params.getQuery().getStartIndex() != null;
    }

    private boolean hasMaxFeatures(QuerierParams params) {
        return params.getQuery().getMaxFeatures() != Integer.MAX_VALUE;
    }

    private String buildStartIndexMaxFeaturesSelect(QuerierParams params, String where) throws IOException {
        String typeName = params.getFeatureTypeInfo().getTypeName();
        String geomTable = this._metadata.getGeometryTable(typeName);
        List<TerralibMetadata.AttributeTableInfo> attrTables = this._metadata.getAttributeTables(typeName);
        String rowNumberFromQuery = this.buildRowNumberFromQuery(params, geomTable, where, attrTables);
        String rowNumberWhere = this.buildMaxFeaturesStartIndexWhereQuery(params);
        String query = "SELECT * FROM " + geomTable + " AS P " + rowNumberFromQuery;
        String whereQuery = "";
        int i = 1;
        for (TerralibMetadata.AttributeTableInfo info : attrTables) {
            query = query + ", " + info.getTableName() + " t" + i;
            whereQuery = whereQuery.isEmpty() ? " WHERE " : " " + whereQuery + " AND ";
            whereQuery = whereQuery + "P." + COL_OBJECT_ID + " = t" + i + "." + info.getUniqueId();
            ++i;
        }
        query = query + whereQuery + rowNumberWhere + this.buildOrderBy(params, true, attrTables);
        return query;
    }
}

