/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib.query.filter;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.data.terralib.exception.NullArgumentException;
import org.geotools.data.terralib.query.filter.TerralibFilterToSQLException;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.identity.Identifier;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Within;

public class TerralibFilterToSQL {
    public static final String SYMBOL_NOT_EQUAL = "symbol_not_equal";
    private static final String SYMBOL_NOT_EQUAL_DEFAULT = "!=";
    private SimpleFeatureType _featureType;
    private Map<String, Serializable> _hints;
    private String _geometryTableName;

    public TerralibFilterToSQL(SimpleFeatureType featureType) {
        if (featureType == null) {
            throw new NullArgumentException("featureType");
        }
        this._featureType = featureType;
        this._hints = new HashMap<String, Serializable>();
        this._geometryTableName = null;
    }

    public TerralibFilterToSQL(SimpleFeatureType featureType, String geometryTableName) {
        if (featureType == null) {
            throw new NullArgumentException("featureType");
        }
        if (geometryTableName == null) {
            throw new NullArgumentException("geometryTableName");
        }
        if (geometryTableName.trim().isEmpty()) {
            throw new IllegalArgumentException("geometryTableName can't be empty");
        }
        this._featureType = featureType;
        this._hints = new HashMap<String, Serializable>();
        this._geometryTableName = geometryTableName;
    }

    public void setHint(String hintKey, Serializable hintValue) {
        this._hints.put(hintKey, hintValue);
    }

    public void clearHints() {
        this._hints.clear();
    }

    public void encode(Filter filter, Writer writer) throws TerralibFilterToSQLException {
        if (filter == null) {
            throw new NullArgumentException("filter can't be null");
        }
        if (writer == null) {
            throw new NullArgumentException("writer can't be null");
        }
        InternalFilterToSQL encoder = new InternalFilterToSQL(writer, this._hints, this._geometryTableName);
        encoder.setFeatureType(this._featureType);
        try {
            encoder.encode(filter);
        }
        catch (FilterToSQLException e) {
            throw new TerralibFilterToSQLException(filter, e.getMessage());
        }
    }

    public String encodeToString(Filter filter) throws TerralibFilterToSQLException {
        StringWriter out = new StringWriter();
        this.encode(filter, (Writer)out);
        return out.getBuffer().toString();
    }

    public void encode(Expression expression, Writer writer) throws TerralibFilterToSQLException {
        if (expression == null) {
            throw new NullArgumentException("expression can't be null");
        }
        if (writer == null) {
            throw new NullArgumentException("writer can't be null");
        }
        InternalFilterToSQL encoder = new InternalFilterToSQL(writer, this._hints, this._geometryTableName);
        encoder.setFeatureType(this._featureType);
        try {
            encoder.encode(expression);
        }
        catch (FilterToSQLException e) {
            throw new TerralibFilterToSQLException(expression, e.getMessage());
        }
    }

    public String encodeToString(Expression expression) throws TerralibFilterToSQLException {
        StringWriter out = new StringWriter();
        this.encode(expression, (Writer)out);
        return out.getBuffer().toString();
    }

    public boolean supports(Filter filter) {
        if (filter == null) {
            throw new NullArgumentException("filter");
        }
        InternalFilterToSQL encoder = new InternalFilterToSQL(null, this._hints, this._geometryTableName);
        return encoder.getCapabilities().fullySupports(filter);
    }

    private static class InternalFilterToSQL
    extends FilterToSQL {
        private Map<String, Serializable> _hints;
        private String _geometryTableName;

        public InternalFilterToSQL(Writer writer, Map<String, Serializable> hints, String geometryTableName) {
            super(writer);
            this._hints = hints;
            this._geometryTableName = geometryTableName;
        }

        protected FilterCapabilities createFilterCapabilities() {
            FilterCapabilities capabilities = super.createFilterCapabilities();
            capabilities.addType(Contains.class);
            capabilities.addType(Within.class);
            capabilities.addType(BBOX.class);
            capabilities.addType(Intersects.class);
            capabilities.addType(PropertyIsLike.class);
            return capabilities;
        }

        public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
            String differentSymbol = this._hints.containsKey(TerralibFilterToSQL.SYMBOL_NOT_EQUAL) ? (String)((Object)this._hints.get(TerralibFilterToSQL.SYMBOL_NOT_EQUAL)) : TerralibFilterToSQL.SYMBOL_NOT_EQUAL_DEFAULT;
            this.visitBinaryComparisonOperator((BinaryComparisonOperator)filter, differentSymbol);
            return extraData;
        }

        public Object visit(Id filter, Object extraData) {
            Set ids = filter.getIdentifiers();
            try {
                if (ids.size() > 1) {
                    boolean first = true;
                    this.out.write(" object_id IN (");
                    for (Identifier id : ids) {
                        if (!first) {
                            this.out.write(",");
                        } else {
                            first = false;
                        }
                        this.out.write("'");
                        this.out.write((String)id.getID());
                        this.out.write("'");
                    }
                    this.out.write(")");
                } else if (ids.size() == 1) {
                    this.out.write(" object_id = '" + ((Identifier)ids.iterator().next()).getID() + "'");
                }
            }
            catch (IOException e) {
                throw new TerralibFilterToSQLException((Filter)filter, "Error writing query to Writer.");
            }
            return extraData;
        }

        public Object visit(PropertyIsLike filter, Object extraData) {
            if (filter == null) {
                throw new NullArgumentException("filter");
            }
            if (filter.getLiteral() == null) {
                throw new IllegalArgumentException("like filter pattern value can't be null.");
            }
            return super.visit(filter, extraData);
        }

        public Object visit(Contains filter, Object extraData) {
            QueryInfo info = this.analyzeFilter((BinarySpatialOperator)filter);
            try {
                if (this._geometryTableName != null) {
                    this.writeInOpen();
                }
                if (this.isPoint(info.getGeometryBinding())) {
                    this.out.write("(");
                    this.out.write(" x >= " + info.getBounds().getMinX());
                    this.out.write(" AND x <= " + info.getBounds().getMaxX());
                    this.out.write(" AND y >= " + info.getBounds().getMinY());
                    this.out.write(" AND y <= " + info.getBounds().getMaxY());
                    this.out.write(")");
                } else if (this.isLine(info.getGeometryBinding()) || this.isPolygon(info.getGeometryBinding())) {
                    this.out.write("(");
                    this.out.write(" lower_x >= " + info.getBounds().getMinX());
                    this.out.write(" AND upper_x <= " + info.getBounds().getMaxX());
                    this.out.write(" AND lower_y >= " + info.getBounds().getMinY());
                    this.out.write(" AND upper_y <= " + info.getBounds().getMaxY());
                    this.out.write(")");
                } else {
                    throw new TerralibFilterToSQLException((Filter)filter, "Unsupported geometry");
                }
                if (this._geometryTableName != null) {
                    this.writeInClose();
                }
            }
            catch (IOException e) {
                throw new TerralibFilterToSQLException((Filter)filter, "Error writing query to Writer.");
            }
            return extraData;
        }

        public Object visit(Intersects filter, Object extraData) {
            return this.internalBBoxIntersectVisit((BinarySpatialOperator)filter, extraData);
        }

        private Object internalBBoxIntersectVisit(BinarySpatialOperator filter, Object extraData) {
            QueryInfo info = this.analyzeFilter(filter);
            try {
                if (this._geometryTableName != null) {
                    this.writeInOpen();
                }
                if (this.isPoint(info.getGeometryBinding())) {
                    this.out.write("(");
                    this.out.write(" x >= " + info.getBounds().getMinX());
                    this.out.write(" AND x <= " + info.getBounds().getMaxX());
                    this.out.write(" AND y >= " + info.getBounds().getMinY());
                    this.out.write(" AND y <= " + info.getBounds().getMaxY());
                    this.out.write(")");
                } else if (this.isLine(info.getGeometryBinding()) || this.isPolygon(info.getGeometryBinding())) {
                    this.out.write("(");
                    this.out.write("NOT");
                    this.out.write("(");
                    this.out.write(" lower_x > " + info.getBounds().getMaxX());
                    this.out.write(" OR ");
                    this.out.write(" upper_x < " + info.getBounds().getMinX());
                    this.out.write(")");
                    this.out.write(" AND ");
                    this.out.write("NOT");
                    this.out.write("(");
                    this.out.write(" lower_y > " + info.getBounds().getMaxY());
                    this.out.write(" OR ");
                    this.out.write(" upper_y < " + info.getBounds().getMinY());
                    this.out.write(")");
                    this.out.write(")");
                } else {
                    throw new TerralibFilterToSQLException((Filter)filter, "Unsupported geometry");
                }
                if (this._geometryTableName != null) {
                    this.writeInClose();
                }
            }
            catch (IOException e) {
                throw new TerralibFilterToSQLException((Filter)filter, "Error writing query to Writer.");
            }
            return extraData;
        }

        public Object visit(BBOX filter, Object extraData) {
            return this.internalBBoxIntersectVisit((BinarySpatialOperator)filter, extraData);
        }

        public Object visit(Within filter, Object extraData) {
            QueryInfo info = this.analyzeFilter((BinarySpatialOperator)filter);
            try {
                if (this._geometryTableName != null) {
                    this.writeInOpen();
                }
                if (this.isPoint(info.getGeometryBinding())) {
                    this.out.write("(");
                    this.out.write(" x > " + info.getBounds().getMinX());
                    this.out.write(" AND x < " + info.getBounds().getMaxX());
                    this.out.write(" AND y > " + info.getBounds().getMinY());
                    this.out.write(" AND y < " + info.getBounds().getMaxY());
                    this.out.write(")");
                } else if (this.isLine(info.getGeometryBinding()) || this.isPolygon(info.getGeometryBinding())) {
                    this.out.write("(");
                    this.out.write(" lower_x > " + info.getBounds().getMinX());
                    this.out.write(" AND upper_x < " + info.getBounds().getMaxX());
                    this.out.write(" AND lower_y > " + info.getBounds().getMinY());
                    this.out.write(" AND upper_y < " + info.getBounds().getMaxY());
                    this.out.write(")");
                } else {
                    throw new TerralibFilterToSQLException((Filter)filter, "Unsupported geometry");
                }
                if (this._geometryTableName != null) {
                    this.writeInClose();
                }
            }
            catch (IOException e) {
                throw new TerralibFilterToSQLException((Filter)filter, "Error writing query to Writer.");
            }
            return extraData;
        }

        protected void writeInOpen() throws IOException {
            this.out.write(" OBJECT_ID IN ");
            this.out.write("(");
            this.out.write(" SELECT DISTINCT OBJECT_ID FROM ");
            this.out.write(this._geometryTableName);
            this.out.write(" WHERE ");
        }

        protected void writeInClose() throws IOException {
            this.out.write(")");
        }

        protected boolean isPoint(Class<?> bindingClass) {
            return Point.class.isAssignableFrom(bindingClass) || MultiPoint.class.isAssignableFrom(bindingClass);
        }

        protected boolean isLine(Class<?> bindingClass) {
            return LineString.class.isAssignableFrom(bindingClass) || MultiLineString.class.isAssignableFrom(bindingClass);
        }

        protected boolean isPolygon(Class<?> bindingClass) {
            return Polygon.class.isAssignableFrom(bindingClass) || MultiPolygon.class.isAssignableFrom(bindingClass);
        }

        protected QueryInfo analyzeFilter(BinarySpatialOperator filter) {
            Expression geometry;
            Expression property;
            FilterFactoryImpl ff;
            if (filter.getExpression1() == null) {
                ff = new FilterFactoryImpl();
                property = ff.property(this.featureType.getGeometryDescriptor().getLocalName());
                geometry = filter.getExpression2();
            } else if (filter.getExpression2() == null) {
                ff = new FilterFactoryImpl();
                property = ff.property(this.featureType.getGeometryDescriptor().getLocalName());
                geometry = filter.getExpression1();
            } else if (filter.getExpression1() instanceof PropertyName) {
                property = filter.getExpression1();
                geometry = filter.getExpression2();
            } else if (filter.getExpression2() instanceof PropertyName) {
                geometry = filter.getExpression1();
                property = filter.getExpression2();
            } else {
                throw new TerralibFilterToSQLException((Filter)filter, "Didn't find a expression for the geometry attribute name");
            }
            if (geometry == null) {
                throw new TerralibFilterToSQLException((Filter)filter, "The expression that should contain the geometry is null.");
            }
            AttributeDescriptor attType = (AttributeDescriptor)property.evaluate((Object)this.featureType);
            if (attType == null) {
                throw new TerralibFilterToSQLException((Filter)filter, "Didn't find the geometry binding class");
            }
            Class geometryBinding = attType.getType().getBinding();
            if (!Geometry.class.isAssignableFrom(geometryBinding)) {
                throw new TerralibFilterToSQLException((Filter)filter, "Didn't find the geometry binding class");
            }
            ReferencedEnvelope envelopeBound = null;
            Object value = geometry.evaluate((Object)this.featureType);
            if (value instanceof Polygon) {
                Polygon bounds = (Polygon)geometry.evaluate((Object)this.featureType);
                envelopeBound = new ReferencedEnvelope(bounds.getEnvelopeInternal(), this.featureType.getCoordinateReferenceSystem());
            } else if (value instanceof ReferencedEnvelope) {
                envelopeBound = (ReferencedEnvelope)value;
            } else {
                throw new TerralibFilterToSQLException((Filter)filter, "Unknown geometry evaluate type");
            }
            return new QueryInfo(envelopeBound, geometryBinding);
        }

        private static class QueryInfo {
            private Class<?> _geometryBinding;
            private ReferencedEnvelope _bounds;

            public QueryInfo(ReferencedEnvelope bounds, Class<?> geometryBinding) {
                this._geometryBinding = geometryBinding;
                this._bounds = bounds;
            }

            public Class<?> getGeometryBinding() {
                return this._geometryBinding;
            }

            public ReferencedEnvelope getBounds() {
                return this._bounds;
            }
        }
    }
}

