/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib.query.portal;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import org.geotools.data.terralib.exception.NullArgumentException;
import org.geotools.data.terralib.exception.TerralibProviderRuntimeException;
import org.geotools.data.terralib.geometry.GeometryBuilder;
import org.geotools.data.terralib.geometry.MultiTextGeometry;
import org.geotools.data.terralib.geometry.TextGeometry;
import org.geotools.data.terralib.query.portal.Portal;

public class JavaPortal
implements Portal {
    private static final String TERRALIB_OBJECT_ID_FIELD_NAME = "object_id";
    private static final String TERRALIB_POLYGON_PARENT_ID_FIELD_NAME = "parent_id";
    private static final String TERRALIB_POINT_Y_FIELD_NAME = "y";
    private static final String TERRALIB_POINT_X_FIELD_NAME = "x";
    private static final String TERRALIB_GEOM_ID_FIELD_NAME = "geom_id";
    private static final String TERRALIB_POLYGON_NUM_HOLES_FIELD_NAME = "num_holes";
    private static final String TERRALIB_LINE_NUM_COORDS_FIELD_NAME = "num_coords";
    private static final String TERRALIB_SPATIAL_DATA_FIELD_NAME = "spatial_data";
    ResultSet _resultSet;
    boolean _hasNext;
    private String _currentObjectId;

    public JavaPortal(ResultSet resultSet) {
        if (resultSet == null) {
            throw new NullArgumentException("resultSet");
        }
        this._resultSet = resultSet;
        try {
            this._hasNext = resultSet.next();
        }
        catch (SQLException e) {
            throw new TerralibProviderRuntimeException("Error fetching first line");
        }
    }

    @Override
    public void close() {
        try {
            Statement stmt = this._resultSet.getStatement();
            this._resultSet.close();
            stmt.close();
        }
        catch (SQLException e) {
            throw new TerralibProviderRuntimeException("Error closing portal", e);
        }
    }

    @Override
    public MultiTextGeometry fetchText() {
        try {
            String objectId = this._currentObjectId == null ? this._resultSet.getString(TERRALIB_OBJECT_ID_FIELD_NAME) : this._currentObjectId;
            ArrayList<TextGeometry> texts = new ArrayList<TextGeometry>();
            do {
                TextGeometry textGeometry = JavaPortal.readTextGeometry(this._resultSet);
                texts.add(textGeometry);
                this._hasNext = this._resultSet.next();
                if (!this._hasNext) continue;
                this._currentObjectId = this._resultSet.getString(TERRALIB_OBJECT_ID_FIELD_NAME);
            } while (this._hasNext && objectId.equals(this._currentObjectId));
            TextGeometry[] textGeometryArray = new TextGeometry[texts.size()];
            texts.toArray(textGeometryArray);
            return new MultiTextGeometry(textGeometryArray, GeometryBuilder.getGeometryFactory());
        }
        catch (SQLException e) {
            throw new TerralibProviderRuntimeException("Error retrieving text geometry", e);
        }
    }

    @Override
    public MultiLineString fetchLine() throws IOException {
        try {
            String objectId = this._currentObjectId == null ? this._resultSet.getString(TERRALIB_OBJECT_ID_FIELD_NAME) : this._currentObjectId;
            ArrayList<LineString> lines = new ArrayList<LineString>();
            do {
                LineString line = JavaPortal.readLine(this._resultSet);
                lines.add(line);
                this._hasNext = this._resultSet.next();
                if (!this._hasNext) continue;
                this._currentObjectId = this._resultSet.getString(TERRALIB_OBJECT_ID_FIELD_NAME);
            } while (this._hasNext && objectId.equals(this._currentObjectId));
            LineString[] lineStringArray = new LineString[lines.size()];
            lines.toArray(lineStringArray);
            return GeometryBuilder.getGeometryFactory().createMultiLineString(lineStringArray);
        }
        catch (SQLException e) {
            throw new IOException("Error retrieving line geometry", e);
        }
    }

    @Override
    public MultiPoint fetchPoint() throws IOException {
        try {
            String objectId = this._currentObjectId == null ? this._resultSet.getString(TERRALIB_OBJECT_ID_FIELD_NAME) : this._currentObjectId;
            ArrayList<Point> points = new ArrayList<Point>();
            do {
                Point point = JavaPortal.readPoint(this._resultSet);
                points.add(point);
                this._hasNext = this._resultSet.next();
                if (!this._hasNext) continue;
                this._currentObjectId = this._resultSet.getString(TERRALIB_OBJECT_ID_FIELD_NAME);
            } while (this._hasNext && objectId.equals(this._currentObjectId));
            Point[] pointArray = new Point[points.size()];
            points.toArray(pointArray);
            return GeometryBuilder.getGeometryFactory().createMultiPoint(pointArray);
        }
        catch (SQLException e) {
            throw new IOException("Error retrieving point geometry", e);
        }
    }

    @Override
    public MultiPolygon fetchPolygon() throws IOException {
        try {
            String objectId = this._currentObjectId == null ? this._resultSet.getString(TERRALIB_OBJECT_ID_FIELD_NAME) : this._currentObjectId;
            ArrayList<Polygon> polygons = new ArrayList<Polygon>();
            do {
                Polygon polygon = JavaPortal.readPolygon(this._resultSet);
                polygons.add(polygon);
                this._hasNext = this._resultSet.next();
                if (!this._hasNext) continue;
                this._currentObjectId = this._resultSet.getString(TERRALIB_OBJECT_ID_FIELD_NAME);
            } while (this._hasNext && objectId.equals(this._currentObjectId));
            Polygon[] polygonArray = new Polygon[polygons.size()];
            polygons.toArray(polygonArray);
            return GeometryBuilder.getGeometryFactory().createMultiPolygon(polygonArray);
        }
        catch (SQLException e) {
            throw new IOException("Error retrieving polygon geometry", e);
        }
    }

    @Override
    public String getDate(String fieldName) {
        if (fieldName == null) {
            throw new NullArgumentException("fieldName");
        }
        try {
            Timestamp time = this._resultSet.getTimestamp(fieldName);
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(time.getTime());
            String dateStr = calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5) + " " + calendar.get(11) + ":" + calendar.get(12) + ":" + calendar.get(13);
            return dateStr;
        }
        catch (SQLException e) {
            throw new TerralibProviderRuntimeException("Error reading date field", e);
        }
    }

    @Override
    public double getDouble(String fieldName) {
        if (fieldName == null) {
            throw new NullArgumentException("fieldName");
        }
        try {
            return this._resultSet.getDouble(fieldName);
        }
        catch (SQLException e) {
            throw new TerralibProviderRuntimeException("Error reading double field", e);
        }
    }

    @Override
    public int getInt(String fieldName) {
        if (fieldName == null) {
            throw new NullArgumentException("fieldName");
        }
        try {
            return this._resultSet.getInt(fieldName);
        }
        catch (SQLException e) {
            throw new TerralibProviderRuntimeException("Error reading int field", e);
        }
    }

    @Override
    public String getString(String fieldName) {
        if (fieldName == null) {
            throw new NullArgumentException("fieldName");
        }
        try {
            return this._resultSet.getString(fieldName);
        }
        catch (SQLException e) {
            throw new TerralibProviderRuntimeException("Error reading string field", e);
        }
    }

    @Override
    public boolean hasNext() {
        return this._hasNext;
    }

    @Override
    public boolean isClosed() {
        try {
            return this._resultSet.isClosed();
        }
        catch (SQLException e) {
            throw new TerralibProviderRuntimeException("Error checking if portal is closed");
        }
    }

    private static Point readPoint(ResultSet rs) throws SQLException {
        double x = rs.getDouble(TERRALIB_POINT_X_FIELD_NAME);
        double y = rs.getDouble(TERRALIB_POINT_Y_FIELD_NAME);
        return GeometryBuilder.buildPoint(x, y);
    }

    private static TextGeometry readTextGeometry(ResultSet rs) throws SQLException {
        Point point = JavaPortal.readPoint(rs);
        String text = rs.getString("text_value");
        double angle = rs.getDouble("angle");
        TextGeometry textGeometry = new TextGeometry(point);
        textGeometry.setText(text);
        textGeometry.setAngle(angle);
        return textGeometry;
    }

    private static LineString readLine(ResultSet rs) throws SQLException {
        double[] vertices = JavaPortal.readVertices(rs);
        return GeometryBuilder.buildLineString(vertices);
    }

    private static Polygon readPolygon(ResultSet rs) throws SQLException {
        int numHoles = rs.getInt(TERRALIB_POLYGON_NUM_HOLES_FIELD_NAME);
        int geomID = rs.getInt(TERRALIB_GEOM_ID_FIELD_NAME);
        double[] shellVertices = JavaPortal.readVertices(rs);
        double[][] holesVertices = new double[numHoles][];
        for (int i = 0; i < numHoles; ++i) {
            rs.next();
            int parentID = rs.getInt(TERRALIB_POLYGON_PARENT_ID_FIELD_NAME);
            int currentGeomId = rs.getInt(TERRALIB_GEOM_ID_FIELD_NAME);
            if (parentID != geomID) {
                throw new SQLException("The current record has a hole that is not from this polygon. Current geom : " + currentGeomId);
            }
            holesVertices[i] = JavaPortal.readVertices(rs);
        }
        return GeometryBuilder.buildPolygon(shellVertices, holesVertices);
    }

    private static double[] readVertices(ResultSet rs) throws SQLException {
        byte[] allBytesInBlob = JavaPortal.readGeometryBlob(rs);
        int numCoords = rs.getInt(TERRALIB_LINE_NUM_COORDS_FIELD_NAME);
        int numDoubles = numCoords * 2;
        double[] vertices = null;
        vertices = numCoords == 1 ? new double[4] : new double[numDoubles];
        for (int i = 0; i < numDoubles; ++i) {
            vertices[i] = JavaPortal.readDouble(allBytesInBlob, i);
        }
        if (numCoords == 1) {
            vertices[2] = vertices[0];
            vertices[3] = vertices[1];
        }
        return vertices;
    }

    private static byte[] readGeometryBlob(ResultSet rs) throws SQLException {
        byte[] allBytesInBlob = null;
        try {
            Blob aBlob = rs.getBlob(TERRALIB_SPATIAL_DATA_FIELD_NAME);
            allBytesInBlob = aBlob.getBytes(1L, (int)aBlob.length());
        }
        catch (Exception ex) {
            allBytesInBlob = rs.getBytes(TERRALIB_SPATIAL_DATA_FIELD_NAME);
        }
        return allBytesInBlob;
    }

    private static double readDouble(byte[] allBytesInBlob, int i) {
        int doubleSize = 8;
        int initialArrayIndex = i * doubleSize;
        return JavaPortal.arr2double(allBytesInBlob, initialArrayIndex);
    }

    public static double arr2double(byte[] arr, int start) {
        int i = 0;
        int len = 8;
        int cnt = 0;
        byte[] tmp = new byte[len];
        for (i = start; i < start + len; ++i) {
            tmp[cnt] = arr[i];
            ++cnt;
        }
        long accum = 0L;
        i = 0;
        for (int shiftBy = 0; shiftBy < 64; shiftBy += 8) {
            accum |= (long)(tmp[i] & 0xFF) << shiftBy;
            ++i;
        }
        return Double.longBitsToDouble(accum);
    }

    @Override
    public void finalizePortal() {
        try {
            Statement stmt = this._resultSet.getStatement();
            this._resultSet.close();
            stmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

