/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib.util;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.geotools.data.terralib.exception.NullArgumentException;

public class TerralibResultSet
implements ResultSet {
    private ResultSet _target;
    private Map<String, Object> _valueCache;
    private boolean _isClosed;

    public TerralibResultSet(ResultSet target) {
        if (target == null) {
            throw new NullArgumentException("target");
        }
        this._target = target;
        this._valueCache = new HashMap<String, Object>();
        this._isClosed = false;
    }

    private String getFieldNameWithoutTable(String columnLabel) {
        if (columnLabel == null) {
            throw new NullArgumentException("columnLabel");
        }
        if (columnLabel.contains(".")) {
            return columnLabel.substring(columnLabel.indexOf(".") + 1);
        }
        return columnLabel;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        return this._target.absolute(row);
    }

    @Override
    public void afterLast() throws SQLException {
        this._target.afterLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this._target.beforeFirst();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this._target.cancelRowUpdates();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this._target.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this._isClosed = true;
        this._target.close();
    }

    @Override
    public void deleteRow() throws SQLException {
        this._target.deleteRow();
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this._target.findColumn(columnLabel);
    }

    @Override
    public boolean first() throws SQLException {
        return this._target.first();
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        return this._target.getArray(columnIndex);
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this._target.getArray(columnLabel);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this._target.getAsciiStream(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this._target.getAsciiStream(columnLabel);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this._target.getBigDecimal(columnIndex, scale);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this._target.getBigDecimal(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this._target.getBigDecimal(columnLabel, scale);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this._target.getBigDecimal(columnLabel);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this._target.getBinaryStream(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this._target.getBinaryStream(columnLabel);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return this._target.getBlob(columnIndex);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this._target.getBlob(columnLabel);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this._target.getBoolean(columnIndex);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this._target.getBoolean(columnLabel);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this._target.getByte(columnIndex);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this._target.getByte(columnLabel);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this._target.getBytes(columnIndex);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this._target.getBytes(columnLabel);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this._target.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this._target.getCharacterStream(columnLabel);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return this._target.getClob(columnIndex);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this._target.getClob(columnLabel);
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this._target.getConcurrency();
    }

    @Override
    public String getCursorName() throws SQLException {
        return this._target.getCursorName();
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this._target.getDate(columnIndex, cal);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this._target.getDate(columnIndex);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        columnLabel = this.getFieldNameWithoutTable(columnLabel);
        return this._target.getDate(columnLabel, cal);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        if (!this._valueCache.containsKey(columnLabel = this.getFieldNameWithoutTable(columnLabel))) {
            this._valueCache.put(columnLabel, this._target.getDate(columnLabel));
        }
        return (Date)this._valueCache.get(columnLabel);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this._target.getDouble(columnIndex);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        if (!this._valueCache.containsKey(columnLabel = this.getFieldNameWithoutTable(columnLabel))) {
            this._valueCache.put(columnLabel, this._target.getDouble(columnLabel));
        }
        return (Double)this._valueCache.get(columnLabel);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this._target.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this._target.getFetchSize();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this._target.getFloat(columnIndex);
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this._target.getFloat(columnLabel);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this._target.getHoldability();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this._target.getInt(columnIndex);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        if (!this._valueCache.containsKey(columnLabel = this.getFieldNameWithoutTable(columnLabel))) {
            this._valueCache.put(columnLabel, this._target.getInt(columnLabel));
        }
        return (Integer)this._valueCache.get(columnLabel);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this._target.getLong(columnIndex);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        if (!this._valueCache.containsKey(columnLabel = this.getFieldNameWithoutTable(columnLabel))) {
            this._valueCache.put(columnLabel, this._target.getLong(columnLabel));
        }
        return (Long)this._valueCache.get(columnLabel);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this._target.getMetaData();
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this._target.getNCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this._target.getNCharacterStream(columnLabel);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return this._target.getNClob(columnIndex);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this._target.getNClob(columnLabel);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this._target.getNString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this._target.getNString(columnLabel);
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        return this._target.getObject(columnIndex, map);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this._target.getObject(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this._target.getObject(columnLabel, map);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this._target.getObject(columnLabel);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        return this._target.getRef(columnIndex);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return this._target.getRef(columnLabel);
    }

    @Override
    public int getRow() throws SQLException {
        return this._target.getRow();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return this._target.getRowId(columnIndex);
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this._target.getRowId(columnLabel);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this._target.getShort(columnIndex);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this._target.getShort(columnLabel);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return this._target.getSQLXML(columnIndex);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this._target.getSQLXML(columnLabel);
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this._target.getStatement();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this._target.getString(columnIndex);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        if (!this._valueCache.containsKey(columnLabel = this.getFieldNameWithoutTable(columnLabel))) {
            this._valueCache.put(columnLabel, this._target.getString(columnLabel));
        }
        return (String)this._valueCache.get(columnLabel);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this._target.getTime(columnIndex, cal);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this._target.getTime(columnIndex);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this._target.getTime(columnLabel, cal);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this._target.getTime(columnLabel);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this._target.getTimestamp(columnIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this._target.getTimestamp(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this._target.getTimestamp(columnLabel, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        if (!this._valueCache.containsKey(columnLabel = this.getFieldNameWithoutTable(columnLabel))) {
            this._valueCache.put(columnLabel, this._target.getTimestamp(columnLabel));
        }
        return (Timestamp)this._valueCache.get(columnLabel);
    }

    @Override
    public int getType() throws SQLException {
        return this._target.getType();
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this._target.getUnicodeStream(columnIndex);
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this._target.getUnicodeStream(columnLabel);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return this._target.getURL(columnIndex);
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this._target.getURL(columnLabel);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this._target.getWarnings();
    }

    @Override
    public void insertRow() throws SQLException {
        this._target.insertRow();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this._target.isAfterLast();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this._target.isBeforeFirst();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._isClosed;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this._target.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this._target.isLast();
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return this._target.isWrapperFor(arg0);
    }

    @Override
    public boolean last() throws SQLException {
        return this._target.last();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this._target.moveToCurrentRow();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this._target.moveToInsertRow();
    }

    @Override
    public boolean next() throws SQLException {
        this._valueCache.clear();
        return this._target.next();
    }

    @Override
    public boolean previous() throws SQLException {
        this._valueCache.clear();
        return this._target.previous();
    }

    @Override
    public void refreshRow() throws SQLException {
        this._target.refreshRow();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        return this._target.relative(rows);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this._target.rowDeleted();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this._target.rowInserted();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this._target.rowUpdated();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this._target.setFetchDirection(direction);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this._target.setFetchSize(rows);
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return this._target.unwrap(arg0);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this._target.updateArray(columnIndex, x);
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        this._target.updateArray(columnLabel, x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this._target.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this._target.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this._target.updateAsciiStream(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this._target.updateAsciiStream(columnLabel, x, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this._target.updateAsciiStream(columnLabel, x, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this._target.updateAsciiStream(columnLabel, x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this._target.updateBigDecimal(columnIndex, x);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this._target.updateBigDecimal(columnLabel, x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this._target.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this._target.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this._target.updateBinaryStream(columnIndex, x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this._target.updateBinaryStream(columnLabel, x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this._target.updateBinaryStream(columnLabel, x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this._target.updateBinaryStream(columnLabel, x);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this._target.updateBlob(columnIndex, x);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this._target.updateBlob(columnIndex, inputStream, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this._target.updateBlob(columnIndex, inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        this._target.updateBlob(columnLabel, x);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this._target.updateBlob(columnLabel, inputStream, length);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this._target.updateBlob(columnLabel, inputStream);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this._target.updateBoolean(columnIndex, x);
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this._target.updateBoolean(columnLabel, x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this._target.updateByte(columnIndex, x);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this._target.updateByte(columnLabel, x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this._target.updateBytes(columnIndex, x);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this._target.updateBytes(columnLabel, x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this._target.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this._target.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this._target.updateCharacterStream(columnIndex, x);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this._target.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this._target.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this._target.updateCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this._target.updateClob(columnIndex, x);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this._target.updateClob(columnIndex, reader, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this._target.updateClob(columnIndex, reader);
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        this._target.updateClob(columnLabel, x);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this._target.updateClob(columnLabel, reader, length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this._target.updateClob(columnLabel, reader);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this._target.updateDate(columnIndex, x);
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this._target.updateDate(columnLabel, x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this._target.updateDouble(columnIndex, x);
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this._target.updateDouble(columnLabel, x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this._target.updateFloat(columnIndex, x);
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this._target.updateFloat(columnLabel, x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this._target.updateInt(columnIndex, x);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this._target.updateInt(columnLabel, x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this._target.updateLong(columnIndex, x);
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this._target.updateLong(columnLabel, x);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this._target.updateNCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this._target.updateNCharacterStream(columnIndex, x);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this._target.updateNCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this._target.updateNCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateNClob(int columnIndex, NClob clob) throws SQLException {
        this._target.updateNClob(columnIndex, clob);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this._target.updateNClob(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this._target.updateNClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(String columnLabel, NClob clob) throws SQLException {
        this._target.updateNClob(columnLabel, clob);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this._target.updateNClob(columnLabel, reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this._target.updateNClob(columnLabel, reader);
    }

    @Override
    public void updateNString(int columnIndex, String string) throws SQLException {
        this._target.updateNString(columnIndex, string);
    }

    @Override
    public void updateNString(String columnLabel, String string) throws SQLException {
        this._target.updateNString(columnLabel, string);
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this._target.updateNull(columnIndex);
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this._target.updateNull(columnLabel);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this._target.updateObject(columnIndex, x, scaleOrLength);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this._target.updateObject(columnIndex, x);
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this._target.updateObject(columnLabel, x, scaleOrLength);
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this._target.updateObject(columnLabel, x);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this._target.updateRef(columnIndex, x);
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this._target.updateRef(columnLabel, x);
    }

    @Override
    public void updateRow() throws SQLException {
        this._target.updateRow();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this._target.updateRowId(columnIndex, x);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this._target.updateRowId(columnLabel, x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this._target.updateShort(columnIndex, x);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this._target.updateShort(columnLabel, x);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this._target.updateSQLXML(columnIndex, xmlObject);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this._target.updateSQLXML(columnLabel, xmlObject);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this._target.updateString(columnIndex, x);
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this._target.updateString(columnLabel, x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this._target.updateTime(columnIndex, x);
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this._target.updateTime(columnLabel, x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this._target.updateTimestamp(columnIndex, x);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this._target.updateTimestamp(columnLabel, x);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this._target.wasNull();
    }
}

