/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.relate;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureIterator;
import org.geotools.util.logging.Logging;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.relate.RelationIntegrity;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;

public class TouchesIntegrity
extends RelationIntegrity {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.validation");

    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        LOGGER.finer("Starting test " + this.getName() + " (" + this.getClass().getName() + ")");
        String typeRef1 = this.getGeomTypeRefA();
        LOGGER.finer(typeRef1 + ": looking up SimpleFeatureSource ");
        SimpleFeatureSource geomSource1 = (SimpleFeatureSource)layers.get(typeRef1);
        LOGGER.finer(typeRef1 + ": found " + ((SimpleFeatureType)geomSource1.getSchema()).getTypeName());
        String typeRef2 = this.getGeomTypeRefB();
        if (typeRef2 == "" || typeRef1.equals(typeRef2)) {
            return this.validateSingleLayer(geomSource1, this.isExpected(), results, envelope);
        }
        LOGGER.finer(typeRef2 + ": looking up SimpleFeatureSource ");
        SimpleFeatureSource geomSource2 = (SimpleFeatureSource)layers.get(typeRef2);
        LOGGER.finer(typeRef2 + ": found " + ((SimpleFeatureType)geomSource2.getSchema()).getTypeName());
        return this.validateMultipleLayers(geomSource1, geomSource2, this.isExpected(), results, envelope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateMultipleLayers(SimpleFeatureSource featureSourceA, SimpleFeatureSource featureSourceB, boolean expected, ValidationResults results, Envelope bBox) throws Exception {
        boolean success = true;
        Filter filter = null;
        SimpleFeatureCollection collectionA = featureSourceA.getFeatures(filter);
        SimpleFeatureCollection collectionB = featureSourceB.getFeatures(filter);
        SimpleFeatureIterator fr1 = null;
        SimpleFeatureIterator fr2 = null;
        try {
            fr1 = collectionA.features();
            if (fr1 == null) {
                boolean bl = false;
                return bl;
            }
            while (fr1.hasNext()) {
                SimpleFeature f1 = (SimpleFeature)fr1.next();
                Geometry g1 = (Geometry)f1.getDefaultGeometry();
                fr2 = collectionB.features();
                try {
                    while (fr2 != null && fr2.hasNext()) {
                        SimpleFeature f2 = (SimpleFeature)fr2.next();
                        Geometry g2 = (Geometry)f2.getDefaultGeometry();
                        if (g1.touches(g2) == expected) continue;
                        results.error(f1, ((Geometry)f1.getDefaultGeometry()).getGeometryType() + " " + this.getGeomTypeRefA() + " touches " + this.getGeomTypeRefB() + "(" + f2.getID() + "), Result was not " + expected);
                        success = false;
                    }
                }
                finally {
                    collectionB.close((FeatureIterator)fr2);
                }
            }
        }
        finally {
            collectionA.close((FeatureIterator)fr1);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateSingleLayer(SimpleFeatureSource featureSourceA, boolean expected, ValidationResults results, Envelope bBox) throws Exception {
        boolean success = true;
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Filter filter = null;
        SimpleFeatureCollection collection = featureSourceA.getFeatures(filter);
        SimpleFeatureIterator fr1 = null;
        SimpleFeatureIterator fr2 = null;
        try {
            fr1 = collection.features();
            if (fr1 == null) {
                boolean bl = false;
                return bl;
            }
            while (fr1.hasNext()) {
                SimpleFeature f1 = (SimpleFeature)fr1.next();
                Geometry g1 = (Geometry)f1.getDefaultGeometry();
                fr2 = collection.features();
                try {
                    while (fr2 != null && fr2.hasNext()) {
                        SimpleFeature f2 = (SimpleFeature)fr2.next();
                        Geometry g2 = (Geometry)f2.getDefaultGeometry();
                        if (f1.getID().equals(f2.getID()) || g1.touches(g2) == expected) continue;
                        results.error(f1, ((Geometry)f1.getDefaultGeometry()).getGeometryType() + " " + this.getGeomTypeRefA() + " touches " + this.getGeomTypeRefA() + "(" + f2.getID() + "), Result was not " + expected);
                        success = false;
                    }
                }
                finally {
                    collection.close((FeatureIterator)fr2);
                }
            }
        }
        finally {
            collection.close((FeatureIterator)fr1);
        }
        return success;
    }
}

