/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.xml;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.geotools.filter.ExpressionDOMParser;
import org.geotools.filter.FilterDOMParser;
import org.geotools.filter.FilterTransformer;
import org.geotools.gml.producer.GeometryTransformer;
import org.geotools.validation.xml.ReaderUtils;
import org.geotools.validation.xml.ValidationException;
import org.opengis.filter.Filter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ArgHelper {
    private static final Mapping[] argumentTypeMappings = new Mapping[]{new FilterMapping(), new GeometryMapping(), new EnvelopeMapping(), new ShortMapping(), new IntegerMapping(), new LongMapping(), new FloatMapping(), new DoubleMapping(), new DateMapping(), new URIMapping(), new BooleanMapping(), new StringMapping()};

    public static Object getArgumentInstance(String elementName, Element value) throws ValidationException {
        if (elementName == null) {
            throw new NullPointerException("A Typename must be specified.");
        }
        for (int i = 0; i < argumentTypeMappings.length; ++i) {
            if (!elementName.equals(argumentTypeMappings[i].getElementName())) continue;
            return argumentTypeMappings[i].getInstance(value);
        }
        return null;
    }

    public static Object getArgumentInstance(String elementName, String value) throws ValidationException {
        if (elementName == null) {
            throw new NullPointerException("A Typename must be specified.");
        }
        for (int i = 0; i < argumentTypeMappings.length; ++i) {
            if (!elementName.equals(argumentTypeMappings[i].getType())) continue;
            return argumentTypeMappings[i].getInstance(value);
        }
        return null;
    }

    public static String getArgumentType(Object o) {
        if (o == null) {
            throw new NullPointerException("An argument instance must be specified.");
        }
        if (o instanceof Class) {
            for (int i = 0; i < argumentTypeMappings.length; ++i) {
                if (!argumentTypeMappings[i].isClass((Class)o)) continue;
                return argumentTypeMappings[i].getType();
            }
        } else {
            for (int i = 0; i < argumentTypeMappings.length; ++i) {
                if (!argumentTypeMappings[i].isClassInstance(o)) continue;
                return argumentTypeMappings[i].getType();
            }
        }
        return "";
    }

    public static String getArgumentEncoding(Object o) throws ValidationException {
        if (o == null) {
            throw new NullPointerException("An argument instance must be specified.");
        }
        for (int i = 0; i < argumentTypeMappings.length; ++i) {
            if (!argumentTypeMappings[i].isClassInstance(o)) continue;
            return argumentTypeMappings[i].encode(o);
        }
        return "";
    }

    public static String getArgumentStringEncoding(Object o) {
        if (o == null) {
            throw new NullPointerException("An argument instance must be specified.");
        }
        for (int i = 0; i < argumentTypeMappings.length; ++i) {
            if (!argumentTypeMappings[i].isClassInstance(o)) continue;
            return argumentTypeMappings[i].toString(o);
        }
        return "";
    }

    protected static class StringMapping
    implements Mapping {
        protected StringMapping() {
        }

        public String getType() {
            return "xs:string";
        }

        public String getElementName() {
            return "string";
        }

        public Object getInstance(Element elem) {
            if (elem == null) {
                throw new NullPointerException("The string passed in was null");
            }
            return new String(ReaderUtils.getElementText(elem));
        }

        public Object getInstance(String value) {
            if (value == null) {
                throw new NullPointerException("The string passed in was null");
            }
            return new String(value);
        }

        public boolean isClassInstance(Object c) {
            return c != null && c instanceof String;
        }

        public boolean isClass(Class c) {
            return c != null && String.class.equals((Object)c);
        }

        public String encode(Object obj) {
            if (obj == null) {
                throw new NullPointerException("The string obj passed in was null");
            }
            if (!(obj instanceof String)) {
                throw new ClassCastException("Object of type Long was expected.");
            }
            return "<string>" + ((String)obj).toString() + "</string>\n";
        }

        public String toString(Object o) {
            return o.toString();
        }
    }

    protected static class BooleanMapping
    implements Mapping {
        protected BooleanMapping() {
        }

        public String getType() {
            return "xs:boolean";
        }

        public String getElementName() {
            return "boolean";
        }

        public Object getInstance(Element elem) {
            if (elem == null) {
                throw new NullPointerException("The boolean passed in was null");
            }
            return new Boolean(ReaderUtils.getElementText(elem));
        }

        public Object getInstance(String elem) {
            if (elem == null) {
                throw new NullPointerException("The boolean passed in was null");
            }
            return new Boolean(elem);
        }

        public boolean isClassInstance(Object c) {
            return c != null && c instanceof Boolean;
        }

        public boolean isClass(Class c) {
            return c != null && (Boolean.class.equals((Object)c) || Boolean.TYPE.equals(c));
        }

        public String encode(Object obj) {
            if (obj == null) {
                throw new NullPointerException("The boolean obj passed in was null");
            }
            if (!(obj instanceof Boolean)) {
                throw new ClassCastException("Object of type Long was expected.");
            }
            return "<boolean>" + ((Boolean)obj).toString() + "</boolean>\n";
        }

        public String toString(Object o) {
            return o.toString();
        }
    }

    protected static class URIMapping
    implements Mapping {
        protected URIMapping() {
        }

        public String getType() {
            return "xs:anyURI";
        }

        public String getElementName() {
            return "anyURI";
        }

        public Object getInstance(Element elem) throws ValidationException {
            if (elem == null) {
                throw new NullPointerException("The anyUri passed in was null");
            }
            try {
                return new URI(ReaderUtils.getElementText(elem).trim());
            }
            catch (URISyntaxException e) {
                throw new ValidationException(e);
            }
        }

        public Object getInstance(String value) throws ValidationException {
            if (value == null) {
                throw new NullPointerException("The anyUri passed in was null");
            }
            try {
                return new URI(value);
            }
            catch (URISyntaxException e) {
                throw new ValidationException(e);
            }
        }

        public boolean isClassInstance(Object c) {
            return c != null && c instanceof URI;
        }

        public boolean isClass(Class c) {
            return c != null && URI.class.equals((Object)c);
        }

        public String encode(Object obj) {
            if (obj == null) {
                throw new NullPointerException("The anyUri obj passed in was null");
            }
            if (!(obj instanceof URI)) {
                throw new ClassCastException("Object of type Long was expected.");
            }
            return "<anyURI>" + ((URI)obj).toString() + "</anyURI>\n";
        }

        public String toString(Object o) {
            return o.toString();
        }
    }

    protected static class DateMapping
    implements Mapping {
        protected DateMapping() {
        }

        public String getType() {
            return "xs:dateTime";
        }

        public String getElementName() {
            return "dateTime";
        }

        public Object getInstance(Element elem) throws ValidationException {
            if (elem == null) {
                throw new NullPointerException("The dateTime passed in was null");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd'T'hh:mm:ssZ");
            try {
                return sdf.parse(ReaderUtils.getElementText(elem));
            }
            catch (ParseException e) {
                throw new ValidationException(e);
            }
        }

        public Object getInstance(String elem) throws ValidationException {
            if (elem == null) {
                throw new NullPointerException("The dateTime passed in was null");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd'T'hh:mm:ssZ");
            try {
                return sdf.parse(elem);
            }
            catch (ParseException e) {
                throw new ValidationException(e);
            }
        }

        public boolean isClassInstance(Object c) {
            return c != null && c instanceof Date;
        }

        public boolean isClass(Class c) {
            return c != null && Date.class.equals((Object)c);
        }

        public String encode(Object obj) {
            if (obj == null) {
                throw new NullPointerException("The dateTime obj passed in was null");
            }
            if (!(obj instanceof Date)) {
                throw new ClassCastException("Object of type Long was expected.");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd'T'hh:mm:ssZ");
            return "<dateTime>" + sdf.format((Date)obj) + "</dateTime>\n";
        }

        public String toString(Object o) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd'T'hh:mm:ssZ");
            return sdf.format((Date)o);
        }
    }

    protected static class DoubleMapping
    implements Mapping {
        protected DoubleMapping() {
        }

        public String getType() {
            return "xs:double";
        }

        public String getElementName() {
            return "double";
        }

        public Object getInstance(Element elem) {
            if (elem == null) {
                throw new NullPointerException("The double passed in was null");
            }
            return new Double(ReaderUtils.getElementText(elem));
        }

        public Object getInstance(String elem) {
            if (elem == null) {
                throw new NullPointerException("The double passed in was null");
            }
            return new Double(elem);
        }

        public boolean isClassInstance(Object c) {
            return c != null && c instanceof Double;
        }

        public boolean isClass(Class c) {
            return c != null && (Double.class.equals((Object)c) || Double.TYPE.equals(c));
        }

        public String encode(Object obj) {
            if (obj == null) {
                throw new NullPointerException("The double obj passed in was null");
            }
            if (!(obj instanceof Double)) {
                throw new ClassCastException("Object of type Long was expected.");
            }
            return "<double>" + ((Double)obj).toString() + "</double>\n";
        }

        public String toString(Object o) {
            return o.toString();
        }
    }

    protected static class FloatMapping
    implements Mapping {
        protected FloatMapping() {
        }

        public String getType() {
            return "xs:float";
        }

        public String getElementName() {
            return "float";
        }

        public Object getInstance(Element elem) {
            if (elem == null) {
                throw new NullPointerException("The float passed in was null");
            }
            return new Float(ReaderUtils.getElementText(elem));
        }

        public Object getInstance(String elem) {
            if (elem == null) {
                throw new NullPointerException("The float passed in was null");
            }
            return new Float(elem);
        }

        public boolean isClassInstance(Object c) {
            return c != null && c instanceof Float;
        }

        public boolean isClass(Class c) {
            return c != null && (Float.class.equals((Object)c) || Float.TYPE.equals(c));
        }

        public String encode(Object obj) {
            if (obj == null) {
                throw new NullPointerException("The float obj passed in was null");
            }
            if (!(obj instanceof Float)) {
                throw new ClassCastException("Object of type Long was expected.");
            }
            return "<float>" + ((Float)obj).toString() + "</float>\n";
        }

        public String toString(Object o) {
            return o.toString();
        }
    }

    protected static class LongMapping
    implements Mapping {
        protected LongMapping() {
        }

        public String getType() {
            return "xs:long";
        }

        public String getElementName() {
            return "long";
        }

        public Object getInstance(Element elem) {
            if (elem == null) {
                throw new NullPointerException("The long passed in was null");
            }
            return new Long(ReaderUtils.getElementText(elem));
        }

        public Object getInstance(String value) {
            if (value == null) {
                throw new NullPointerException("The long passed in was null");
            }
            return new Long(value);
        }

        public boolean isClassInstance(Object c) {
            return c != null && c instanceof Long;
        }

        public boolean isClass(Class c) {
            return c != null && (Long.class.equals((Object)c) || Long.TYPE.equals(c));
        }

        public String encode(Object obj) {
            if (obj == null) {
                throw new NullPointerException("The long obj passed in was null");
            }
            if (!(obj instanceof Long)) {
                throw new ClassCastException("Object of type Long was expected.");
            }
            return "<long>" + ((Long)obj).toString() + "</long>\n";
        }

        public String toString(Object o) {
            return o.toString();
        }
    }

    protected static class IntegerMapping
    implements Mapping {
        protected IntegerMapping() {
        }

        public String getType() {
            return "xs:integer";
        }

        public String getElementName() {
            return "integer";
        }

        public Object getInstance(Element elem) {
            if (elem == null) {
                throw new NullPointerException("The integer passed in was null");
            }
            return new Integer(ReaderUtils.getElementText(elem));
        }

        public Object getInstance(String value) {
            if (value == null) {
                throw new NullPointerException("The integer passed in was null");
            }
            return new Integer(value);
        }

        public boolean isClassInstance(Object c) {
            return c != null && c instanceof Integer;
        }

        public boolean isClass(Class c) {
            return c != null && (Integer.class.equals((Object)c) || Integer.TYPE.equals(c));
        }

        public String encode(Object obj) {
            if (obj == null) {
                throw new NullPointerException("The integer obj passed in was null");
            }
            if (!(obj instanceof Integer)) {
                throw new ClassCastException("Object of type Integer was expected.");
            }
            return "<integer>" + ((Integer)obj).toString() + "</integer>\n";
        }

        public String toString(Object o) {
            return o.toString();
        }
    }

    protected static class ShortMapping
    implements Mapping {
        protected ShortMapping() {
        }

        public String getType() {
            return "xs:short";
        }

        public String getElementName() {
            return "short";
        }

        public Object getInstance(Element elem) {
            if (elem == null) {
                throw new NullPointerException("The short element passed in was null");
            }
            return new Short(ReaderUtils.getElementText(elem));
        }

        public Object getInstance(String value) {
            if (value == null) {
                throw new NullPointerException("The short element passed in was null");
            }
            return new Short(value);
        }

        public boolean isClassInstance(Object c) {
            return c != null && c instanceof Short;
        }

        public boolean isClass(Class c) {
            return c != null && (Short.class.equals((Object)c) || Short.TYPE.equals(c));
        }

        public String encode(Object obj) {
            if (obj == null) {
                throw new NullPointerException("The short obj passed in was null");
            }
            if (!(obj instanceof Short)) {
                throw new ClassCastException("Object of type Short was expected.");
            }
            return "<short>" + ((Short)obj).toString() + "</short>\n";
        }

        public String toString(Object o) {
            return o.toString();
        }
    }

    protected static class EnvelopeMapping
    implements Mapping {
        protected EnvelopeMapping() {
        }

        public String getType() {
            return "ogc:BBOXType";
        }

        public String getElementName() {
            return "bbox";
        }

        public Object getInstance(Element bboxElem) throws ValidationException {
            if (bboxElem == null) {
                throw new NullPointerException("The bounding Box element passed in was null");
            }
            try {
                boolean dynamic = ReaderUtils.getBooleanAttribute(bboxElem, "dynamic", false);
                if (!dynamic) {
                    double minx = ReaderUtils.getDoubleAttribute(bboxElem, "minx", true);
                    double miny = ReaderUtils.getDoubleAttribute(bboxElem, "miny", true);
                    double maxx = ReaderUtils.getDoubleAttribute(bboxElem, "maxx", true);
                    double maxy = ReaderUtils.getDoubleAttribute(bboxElem, "maxy", true);
                    return new Envelope(minx, maxx, miny, maxy);
                }
            }
            catch (SAXException e) {
                throw new ValidationException(e);
            }
            return null;
        }

        public Object getInstance(String bbox) throws ValidationException {
            if (bbox == null) {
                throw new NullPointerException("The bounding Box element passed in was null");
            }
            try {
                String[] tmp = bbox.split(",");
                double minx = Double.parseDouble(tmp[0].trim());
                double maxx = Double.parseDouble(tmp[1].trim());
                double miny = Double.parseDouble(tmp[2].trim());
                double maxy = Double.parseDouble(tmp[3].trim());
                return new Envelope(minx, maxx, miny, maxy);
            }
            catch (Exception e) {
                throw new ValidationException(e);
            }
        }

        public boolean isClassInstance(Object c) {
            return c != null && c instanceof Envelope;
        }

        public boolean isClass(Class c) {
            return c != null && Envelope.class.equals((Object)c);
        }

        public String encode(Object obj) {
            if (obj == null) {
                throw new NullPointerException("The bounding Box obj passed in was null");
            }
            if (!(obj instanceof Envelope)) {
                throw new ClassCastException("Object of type Envelope was expected.");
            }
            String s = "";
            Envelope e = (Envelope)obj;
            s = s + "<bbox ";
            if (!e.isNull()) {
                s = s + "dynamic = \"false\" ";
                s = s + "minx = \"" + e.getMinX() + "\" ";
                s = s + "miny = \"" + e.getMinY() + "\" ";
                s = s + "maxx = \"" + e.getMaxX() + "\" ";
                s = s + "maxy = \"" + e.getMaxY() + "\" ";
            } else {
                s = s + "dynamic = \"true\" ";
            }
            s = s + " />\n";
            return s;
        }

        public String toString(Object obj) {
            if (obj == null) {
                throw new NullPointerException("The bounding Box obj passed in was null");
            }
            if (!(obj instanceof Envelope)) {
                throw new ClassCastException("Object of type Envelope was expected.");
            }
            String s = "";
            Envelope e = (Envelope)obj;
            if (!e.isNull()) {
                s = s + e.getMinX();
                s = s + "," + e.getMaxX();
                s = s + "," + e.getMinY();
                s = s + "," + e.getMaxY();
            }
            return s;
        }
    }

    protected static class GeometryMapping
    implements Mapping {
        protected GeometryMapping() {
        }

        public String getType() {
            return "gml:AbstractGeometryType";
        }

        public String getElementName() {
            return "geometry";
        }

        public Object getInstance(Element value) {
            return ExpressionDOMParser.parseGML((Node)value);
        }

        public Object getInstance(String value) {
            Element elem;
            try {
                StringReader sr = new StringReader(value);
                elem = ReaderUtils.loadConfig(sr);
                sr.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
                return null;
            }
            catch (SAXException e) {
                e.printStackTrace();
                return null;
            }
            return ExpressionDOMParser.parseGML((Node)elem);
        }

        public boolean isClassInstance(Object c) {
            return c != null && c instanceof Geometry;
        }

        public boolean isClass(Class c) {
            return c != null && Geometry.class.equals((Object)c);
        }

        public String encode(Object obj) throws ValidationException {
            StringWriter sw = new StringWriter();
            GeometryTransformer transformer = new GeometryTransformer();
            try {
                transformer.transform(obj, (Writer)sw);
            }
            catch (TransformerException e) {
                throw new ValidationException(e);
            }
            return "<geometry>\n" + sw.toString() + "</geometry>\n";
        }

        public String toString(Object obj) {
            StringWriter sw = new StringWriter();
            GeometryTransformer transformer = new GeometryTransformer();
            try {
                transformer.transform(obj, (Writer)sw);
            }
            catch (TransformerException e) {
                return null;
            }
            return "<geometry>\n" + sw.toString() + "</geometry>\n";
        }
    }

    protected static class FilterMapping
    implements Mapping {
        protected FilterMapping() {
        }

        public String getType() {
            return "ogc:FilterType";
        }

        public String getElementName() {
            return "filter";
        }

        public Object getInstance(Element value) {
            if (value != null && (value = ReaderUtils.getFirstChildElement(value)) != null) {
                return FilterDOMParser.parseFilter((Node)value);
            }
            return null;
        }

        public Object getInstance(String elem) {
            Element value;
            try {
                StringReader sr = new StringReader(elem);
                value = ReaderUtils.loadConfig(sr);
                sr.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
                return null;
            }
            catch (SAXException e) {
                e.printStackTrace();
                return null;
            }
            if (value != null && (value = ReaderUtils.getFirstChildElement(value)) != null) {
                return FilterDOMParser.parseFilter((Node)value);
            }
            return null;
        }

        public boolean isClassInstance(Object c) {
            return c != null && c instanceof Filter;
        }

        public boolean isClass(Class c) {
            return c != null && Filter.class.equals((Object)c);
        }

        public String encode(Object obj) throws ValidationException {
            Filter f = null;
            if (obj == null) {
                throw new NullPointerException("Cannot encode a null Filter.");
            }
            if (!(obj instanceof Filter)) {
                throw new ClassCastException("Cannot cast " + obj.getClass().toString() + " to a Filter.");
            }
            f = (Filter)obj;
            StringWriter sw = new StringWriter();
            try {
                sw.write(new FilterTransformer().transform(f));
            }
            catch (TransformerException e) {
                throw new ValidationException(e);
            }
            return "<filter>\n" + sw.toString() + "</filter>\n";
        }

        public String toString(Object obj) {
            Filter f = null;
            if (obj == null) {
                throw new NullPointerException("Cannot encode a null Filter.");
            }
            if (!(obj instanceof Filter)) {
                throw new ClassCastException("Cannot cast " + obj.getClass().toString() + " to a Filter.");
            }
            f = (Filter)obj;
            StringWriter sw = new StringWriter();
            try {
                sw.write(new FilterTransformer().transform(f));
            }
            catch (TransformerException e) {
                return null;
            }
            return "<filter>\n" + sw.toString() + "</filter>\n";
        }
    }

    protected static interface Mapping {
        public String getType();

        public Object getInstance(Element var1) throws ValidationException;

        public Object getInstance(String var1) throws ValidationException;

        public boolean isClassInstance(Object var1);

        public boolean isClass(Class var1);

        public String encode(Object var1) throws ValidationException;

        public String toString(Object var1);

        public String getElementName();
    }
}

