/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ows;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.geotools.data.ows.CRSEnvelope;
import org.geotools.data.ows.StyleImpl;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Layer
implements Comparable<Layer> {
    private String name;
    private String title;
    private String _abstract;
    private String[] keywords;
    private Set<String> srs = null;
    private Set<String> allSRSCache = null;
    private HashMap<Object, CRSEnvelope> boundingBoxes = null;
    private CRSEnvelope latLonBoundingBox = null;
    private List<StyleImpl> styles;
    private Boolean queryable = null;
    private double scaleHintMin = Double.NaN;
    private double scaleHintMax = Double.NaN;
    private double scaleDenominatorMin = Double.NaN;
    private double scaleDenominatorMax = Double.NaN;
    private Layer parent;
    private Layer[] children;
    private Map envelopeCache = Collections.synchronizedMap(new WeakHashMap());

    public Layer() {
        this(null);
    }

    public Layer(String title) {
        this.title = title;
    }

    public HashMap<Object, CRSEnvelope> getBoundingBoxes() {
        if (this.boundingBoxes == null) {
            for (Layer parent = this.getParent(); parent != null; parent = parent.getParent()) {
                HashMap<Object, CRSEnvelope> bb = parent.getBoundingBoxes();
                if (bb == null) continue;
                return bb;
            }
        }
        return this.boundingBoxes;
    }

    public void setBoundingBoxes(HashMap boundingBoxes) {
        this.boundingBoxes = boundingBoxes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSrs() {
        Layer layer = this;
        synchronized (layer) {
            if (this.allSRSCache == null) {
                Set<String> parentSrs;
                this.allSRSCache = new HashSet<String>(this.srs);
                Layer parent = this.getParent();
                if (parent != null && (parentSrs = parent.getSrs()) != null) {
                    this.allSRSCache.addAll(parentSrs);
                }
            }
            return this.allSRSCache;
        }
    }

    public void setSrs(Set srs) {
        this.srs = srs;
    }

    public List<StyleImpl> getStyles() {
        List<StyleImpl> parentStyles;
        ArrayList<StyleImpl> allStyles = new ArrayList<StyleImpl>();
        Layer parent = this.getParent();
        if (parent != null && (parentStyles = parent.getStyles()) != null) {
            allStyles.addAll(parentStyles);
        }
        if (this.styles != null && !this.styles.isEmpty()) {
            for (StyleImpl style : this.styles) {
                if (allStyles.contains(style)) continue;
                allStyles.add(style);
            }
        }
        return allStyles;
    }

    public void setStyles(List styles) {
        this.styles = styles;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isQueryable() {
        if (this.queryable == null) {
            for (Layer parent = this.getParent(); parent != null; parent = parent.getParent()) {
                Boolean q = parent.getQueryable();
                if (q == null) continue;
                return q;
            }
            return false;
        }
        return this.queryable;
    }

    private Boolean getQueryable() {
        return this.queryable;
    }

    public void setQueryable(boolean queryable) {
        this.queryable = new Boolean(queryable);
    }

    @Override
    public int compareTo(Layer layer) {
        if (this.getName() != null && layer.getName() != null) {
            return this.getName().compareTo(layer.getName());
        }
        return this.getTitle().compareTo(layer.getTitle());
    }

    public Layer getParent() {
        return this.parent;
    }

    public void setParent(Layer parent) {
        this.parent = parent;
    }

    public CRSEnvelope getLatLonBoundingBox() {
        if (this.latLonBoundingBox == null) {
            for (Layer parent = this.getParent(); parent != null; parent = parent.getParent()) {
                CRSEnvelope llbb = parent.getLatLonBoundingBox();
                if (llbb == null) continue;
                return llbb;
            }
        }
        return this.latLonBoundingBox;
    }

    public void setLatLonBoundingBox(CRSEnvelope latLonBoundingBox) {
        this.latLonBoundingBox = latLonBoundingBox;
    }

    public Layer[] getChildren() {
        return this.children;
    }

    public void setChildren(Layer[] children) {
        this.children = children;
    }

    public String get_abstract() {
        return this._abstract;
    }

    public void set_abstract(String _abstract) {
        this._abstract = _abstract;
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String[] keywords) {
        this.keywords = keywords;
    }

    public void setScaleDenominatorMax(double scaleDenominatorMax) {
        this.scaleDenominatorMax = scaleDenominatorMax;
    }

    public double getScaleDenominatorMax() {
        return this.scaleDenominatorMax;
    }

    public void setScaleDenominatorMin(double scaleDenominatorMin) {
        this.scaleDenominatorMin = scaleDenominatorMin;
    }

    public double getScaleDenominatorMin() {
        return this.scaleDenominatorMin;
    }

    public double getScaleHintMax() {
        return this.scaleHintMax;
    }

    public void setScaleHintMax(double scaleHintMax) {
        this.scaleHintMax = scaleHintMax;
    }

    public double getScaleHintMin() {
        return this.scaleHintMin;
    }

    public void setScaleHintMin(double scaleHintMin) {
        this.scaleHintMin = scaleHintMin;
    }

    public GeneralEnvelope getEnvelope(CoordinateReferenceSystem crs) {
        GeneralEnvelope result = (GeneralEnvelope)this.envelopeCache.get(crs);
        if (result != null) {
            return result;
        }
        Collection<Object> identifiers = crs.getIdentifiers();
        if (crs == DefaultGeographicCRS.WGS84 || crs == DefaultGeographicCRS.WGS84_3D) {
            identifiers = Arrays.asList("EPSG:4326");
        }
        Iterator i = identifiers.iterator();
        while (i.hasNext()) {
            String epsgCode = i.next().toString();
            CRSEnvelope tempBBox = null;
            Layer parentLayer = this;
            while (tempBBox == null && parentLayer != null) {
                HashMap<Object, CRSEnvelope> boxes = parentLayer.getBoundingBoxes();
                if (boxes == null) continue;
                tempBBox = boxes.get(epsgCode);
                parentLayer = parentLayer.getParent();
            }
            if (tempBBox == null && "EPSG:4326".equals(epsgCode.toUpperCase())) {
                CRSEnvelope latLonBBox = null;
                for (parentLayer = this; latLonBBox == null && parentLayer != null; parentLayer = parentLayer.getParent()) {
                    latLonBBox = parentLayer.getLatLonBoundingBox();
                    if (latLonBBox == null) continue;
                    try {
                        new GeneralEnvelope(new double[]{latLonBBox.getMinX(), latLonBBox.getMinY()}, new double[]{latLonBBox.getMaxX(), latLonBBox.getMaxY()});
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        latLonBBox = null;
                    }
                }
                tempBBox = latLonBBox == null ? new CRSEnvelope("EPSG:4326", -180.0, -90.0, 180.0, 90.0) : new CRSEnvelope("EPSG:4326", latLonBBox.getMinX(), latLonBBox.getMinY(), latLonBBox.getMaxX(), latLonBBox.getMaxY());
            }
            if (tempBBox == null) {
                String epsg = null;
                if (this.getLatLonBoundingBox() != null) {
                    CRSEnvelope latLonBBox = this.getLatLonBoundingBox();
                    tempBBox = new CRSEnvelope("EPSG:4326", latLonBBox.getMinX(), latLonBBox.getMinY(), latLonBBox.getMaxX(), latLonBBox.getMaxY());
                    epsg = "EPSG:4326";
                }
                if (tempBBox == null && this.getBoundingBoxes() != null && this.getBoundingBoxes().size() > 0) {
                    tempBBox = this.getBoundingBoxes().values().iterator().next();
                    epsg = tempBBox.getEPSGCode();
                }
                if (tempBBox == null) continue;
                GeneralEnvelope env = new GeneralEnvelope(new double[]{tempBBox.getMinX(), tempBBox.getMinY()}, new double[]{tempBBox.getMaxX(), tempBBox.getMaxY()});
                CoordinateReferenceSystem fromCRS = null;
                try {
                    fromCRS = CRS.decode((String)epsg);
                    ReferencedEnvelope oldEnv = new ReferencedEnvelope(env.getMinimum(0), env.getMaximum(0), env.getMinimum(1), env.getMaximum(1), fromCRS);
                    ReferencedEnvelope newEnv = oldEnv.transform(crs, true);
                    env = new GeneralEnvelope(new double[]{newEnv.getMinimum(0), newEnv.getMinimum(1)}, new double[]{newEnv.getMaximum(0), newEnv.getMaximum(1)});
                    env.setCoordinateReferenceSystem(crs);
                    this.envelopeCache.put(crs, env);
                    return env;
                }
                catch (NoSuchAuthorityCodeException e) {
                }
                catch (FactoryException e) {
                }
                catch (MismatchedDimensionException e) {
                }
                catch (TransformException e) {
                    // empty catch block
                }
            }
            if (tempBBox == null) continue;
            GeneralEnvelope env = new GeneralEnvelope(new double[]{tempBBox.getMinX(), tempBBox.getMinY()}, new double[]{tempBBox.getMaxX(), tempBBox.getMaxY()});
            env.setCoordinateReferenceSystem(crs);
            return env;
        }
        return null;
    }

    public String toString() {
        if (this.title != null) {
            return this.title;
        }
        return this.name;
    }
}

